package cz.cuni.pogamut.posh.palette;

import cz.cuni.amis.pogamut.sposh.elements.Goal;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.openide.nodes.Children;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.ExTransferable.Single;

/**
 * Node in posh palette that represents new goal that can be DnD to scene.
 * @author Honza
 */
class AddGoalActionNode extends PoshPaletteNode {

    public AddGoalActionNode() {
        super(Children.LEAF);
        this.setName("(goal(fail))");
        this.setDisplayName("Goal");
    }

    /**
     * Ask user for goal sense. Sorry, only one.
     * @return
     */
    @Override
    protected Single createTransferable() {
        return new ExTransferable.Single(Goal.dataFlavor) {

            @Override
            protected Object getData() throws IOException, UnsupportedFlavorException {
                String id = PGSupport.getIdentifierFromDialog("Name sense that has to be satisfied");
                if (id == null) {
                    return null;
                }

                return new Goal(new Sense(id));
            }
        };
    }
}
