/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.palette;

import cz.cuni.amis.pogamut.sposh.PoshTreeEvent;
import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.CompetencePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.DrivePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.pogamut.posh.palette.ActionNode;
import cz.cuni.pogamut.posh.palette.ExternalActionNode;
import cz.cuni.pogamut.posh.palette.OldActionNode;
import cz.cuni.pogamut.posh.palette.external.BehaviourInterfaceBuilder;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class ActionsChildren
extends Children.SortedMap<TriggeredAction>
implements PoshElementListener {
    private List<TriggeredAction> externalActions = new ArrayList<TriggeredAction>();
    private List<String> undefinedActions = new ArrayList<String>();
    private List<String> oldActions = new ArrayList<String>();
    private Lookup lookup;

    ActionsChildren(Lookup lookup) {
        this.lookup = lookup;
    }

    public void nodeChanged(PoshTreeEvent event, PoshElement child) {
        this.refresh(child.getRootNode());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh(((PoshElement)evt.getSource()).getRootNode());
    }

    public synchronized void refresh(PoshPlan plan) {
        List<TriggeredAction> actions = this.getAllActions(plan);
        ArrayList<String> actionNames = new ArrayList<String>();
        for (TriggeredAction action : actions) {
            String actionName = action.getActionName();
            if (actionNames.contains(actionName) || !plan.isUniqueAPorComp(actionName)) continue;
            actionNames.add(actionName);
        }
        this.removeDuplicateActions(actionNames, this.externalActions);
        this.oldActions.addAll(this.undefinedActions);
        this.oldActions.removeAll(actionNames);
        this.removeDuplicateActions(this.oldActions, this.externalActions);
        Collections.sort(actionNames);
        for (TriggeredAction ta : this.nodes.keySet().toArray(new TriggeredAction[0])) {
            this.remove(ta);
        }
        this.undefinedActions.clear();
        for (String actionName : actionNames) {
            TriggeredAction ta = new TriggeredAction(actionName);
            this.put(ta, (Node)new ActionNode(ta));
            this.refreshKey(ta);
            this.undefinedActions.add(actionName);
        }
        for (String oldActionName : this.oldActions) {
            TriggeredAction oa = new TriggeredAction(oldActionName);
            this.put(oa, (Node)new OldActionNode(oa));
        }
        for (TriggeredAction ta : this.externalActions) {
            this.put(ta, (Node)new ExternalActionNode(ta));
        }
        this.refresh();
        new Thread(new BehaviourInterfaceBuilder(this.lookup)).start();
    }

    private List<TriggeredAction> getAllActions(PoshPlan plan) {
        LinkedList<TriggeredAction> actions = new LinkedList<TriggeredAction>();
        List aps = plan.getActionPatterns();
        List competences = plan.getCompetences();
        for (ActionPattern ap : aps) {
            for (TriggeredAction action : ap.getTriggeredActions()) {
                actions.add(action);
            }
        }
        for (Competence competence : competences) {
            for (CompetencePriorityElement cpe : competence.getPriorityElements()) {
                for (CompetenceElement ce : cpe.getElements()) {
                    actions.add(ce.getAction());
                }
            }
        }
        DriveCollection dc = plan.getDriveCollection();
        for (DrivePriorityElement dpe : dc.getPriorityElements()) {
            for (DriveElement de : dpe.getDriveElements()) {
                actions.add(de.getTriggeredAction());
            }
        }
        return actions;
    }

    public synchronized List<String> getUndefinedActions() {
        return Collections.unmodifiableList(this.undefinedActions);
    }

    public synchronized void setExternalActions(List<Method> externalMethods) {
        this.removeActions(this.externalActions);
        this.externalActions.clear();
        for (Method m : externalMethods) {
            TriggeredAction ta = new TriggeredAction(m.getName());
            this.externalActions.add(ta);
            this.put(ta, (Node)new ExternalActionNode(ta));
        }
    }

    private void removeActions(List<TriggeredAction> list) {
        for (TriggeredAction action : list) {
            this.remove(action);
        }
    }

    private void removeDuplicateActions(List<String> actionNames, List<TriggeredAction> tobeRemoved) {
        for (String actionName : actionNames.toArray(new String[0])) {
            for (TriggeredAction ta : tobeRemoved) {
                if (!ta.getActionName().equals(actionName)) continue;
                actionNames.remove(ta.getActionName());
            }
        }
    }

    void removeOldAction(TriggeredAction oldAction) {
        this.oldActions.remove(oldAction.getActionName());
        this.remove(oldAction);
    }
}

