package cz.cuni.pogamut.posh.widget.accept;

import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Triggers;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

/**
 * When sense is dropped to the triggers widget, add it as last Sense
 * to the associted Triggers element.
 *
 * @author Honza
 */
public class AcceptSense2Triggers extends AbstractAcceptAction<Triggers> {

    public AcceptSense2Triggers(Triggers dataNode) {
        super(Sense.dataFlavor, dataNode);
    }

    @Override
    protected void performAction(Transferable tr) throws UnsupportedFlavorException, IOException {
        Sense sense = (Sense) tr.getTransferData(dataFlavor);
        if (sense == null) {
            return;
        }
        this.dataNode.addUserTrigger(sense);
    }
}

