/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.vip.bot;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.UT2004AgentInfo;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerJoinsGame;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerLeft;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Spawn;
import cz.cuni.amis.pogamut.ut2004.vip.bot.VIPEvents;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.CSBotRole;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.CSBotState;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.CSBotTeam;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.CSMessagesTranslator;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.VIPGameConfig;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.VIPGameResult;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.VIPGameState;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSAssignVIP;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSBotStateChanged;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSCounterTerroristsWin;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSRoundEnd;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSRoundStart;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSRoundState;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSSetVIPSafeArea;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSTeamScoreChanged;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSTerroristsWin;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSVIPKilled;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSVIPSafe;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.VIPGameEnd;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.VIPGameStart;
import cz.cuni.amis.pogamut.ut2004.vip.server.CSBotRecord;
import cz.cuni.amis.pogamut.ut2004.vip.server.UT2004VIPServer;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.maps.LazyMap;
import java.util.Map;

public class VIPBotModule
extends SensorModule<UT2004Bot> {
    private AgentInfo info;
    private Players players;
    private CSMessagesTranslator csTranslator;
    private VIPEvents vipEvents;
    private IWorldEventListener<BeginMessage> beginMessageListener = new IWorldEventListener<BeginMessage>(){

        public void notify(BeginMessage event) {
            VIPBotModule.this.beginMessage(event);
        }
    };
    private IWorldEventListener<PlayerKilled> playerKilledMessageListener = new IWorldEventListener<PlayerKilled>(){

        public void notify(PlayerKilled event) {
            VIPBotModule.this.playerKilled(event);
        }
    };
    private IWorldEventListener<BotKilled> botKilledMessageListener = new IWorldEventListener<BotKilled>(){

        public void notify(BotKilled event) {
            VIPBotModule.this.botKilled(event);
        }
    };
    private IWorldEventListener<Spawn> spawnMessageListener = new IWorldEventListener<Spawn>(){

        public void notify(Spawn event) {
            VIPBotModule.this.spawn(event);
        }
    };
    private IWorldEventListener<PlayerJoinsGame> myPlayerJoinsGameMessageListener = new IWorldEventListener<PlayerJoinsGame>(){

        public void notify(PlayerJoinsGame event) {
            VIPBotModule.this.playerJoinsGame(event);
        }
    };
    private IWorldEventListener<PlayerLeft> myPlayerLeftMessageListener = new IWorldEventListener<PlayerLeft>(){

        public void notify(PlayerLeft event) {
            VIPBotModule.this.playerLeft(event);
        }
    };
    private IWorldObjectListener<PlayerMessage> myPlayerListener = new IWorldObjectListener<PlayerMessage>(){

        public void notify(IWorldObjectEvent<PlayerMessage> event) {
            VIPBotModule.this.playerUpdate(event);
        }
    };
    private VIPGameConfig gameConfig;
    private Flag<Boolean> gameRunning = new Flag((Object)false);
    private Flag<Boolean> roundRunning = new Flag((Object)false);
    private Flag<VIPGameState> gameState = new Flag((Object)VIPGameState.NOT_RUNNING);
    private Map<UnrealId, CSBotRecord<Player>> records = new LazyMap<UnrealId, CSBotRecord<Player>>(){

        protected CSBotRecord<Player> create(UnrealId key) {
            return new CSBotRecord<Player>(key, VIPBotModule.this.gameConfig);
        }
    };
    private CSBotRecord<Player> vip;
    private Location vipSafeArea;
    private CSRoundState roundState;
    private long simTimeCurrent;
    private boolean alive = false;

    public VIPBotModule(UT2004Bot agent, AgentInfo info, Players players) {
        super((IObservingAgent)agent);
        this.info = info;
        if (info == null) {
            info = new UT2004AgentInfo(agent);
        }
        this.players = players;
        if (this.players == null) {
            this.players = new Players(agent);
        }
        this.csTranslator = new CSMessagesTranslator((IWorldView)agent.getWorldView(), false);
        this.vipEvents = new VIPEvents((IWorldView)agent.getWorldView()){

            @Override
            protected void csAssignVIP(CSAssignVIP event) {
                VIPBotModule.this.csAssignVIP(event);
            }

            @Override
            protected void csBotStateChanged(CSBotStateChanged event) {
                VIPBotModule.this.csBotStateChanged(event);
            }

            @Override
            protected void csCounterTerroristsWin(CSCounterTerroristsWin event) {
                VIPBotModule.this.csCounterTerroristsWin(event);
            }

            @Override
            protected void csRoundEnd(CSRoundEnd event) {
                VIPBotModule.this.csRoundEnd(event);
            }

            @Override
            protected void csRoundStart(CSRoundStart event) {
                VIPBotModule.this.csRoundStart(event);
            }

            @Override
            protected void csRoundState(CSRoundState event) {
                VIPBotModule.this.csRoundState(event);
            }

            @Override
            protected void csSetVIPSafeArea(CSSetVIPSafeArea event) {
                VIPBotModule.this.csSetVIPSafeArea(event);
            }

            @Override
            protected void csTeamScoreChangedListener(CSTeamScoreChanged event) {
                VIPBotModule.this.csTeamScoreChangedListener(event);
            }

            @Override
            protected void csTerroristsWin(CSTerroristsWin event) {
                VIPBotModule.this.csTerroristsWin(event);
            }

            @Override
            protected void csVIPKilled(CSVIPKilled event) {
                VIPBotModule.this.csVIPKilled(event);
            }

            @Override
            protected void csVIPSafe(CSVIPSafe event) {
                VIPBotModule.this.csVIPSafe(event);
            }

            @Override
            protected void csVIPGameEnd(VIPGameEnd event) {
                VIPBotModule.this.csVIPGameEnd(event);
            }

            @Override
            protected void csVIPGameStart(VIPGameStart event) {
                VIPBotModule.this.csVIPGameStart(event);
            }
        };
    }

    public UnrealId getId() {
        return this.info.getId();
    }

    public boolean isGameRunning() {
        return (Boolean)this.gameRunning.getFlag();
    }

    public ImmutableFlag<Boolean> getGameRunningFlag() {
        return this.gameRunning.getImmutable();
    }

    public boolean isRoundRunning() {
        return (Boolean)this.gameRunning.getFlag() != false && (Boolean)this.roundRunning.getFlag() != false;
    }

    public ImmutableFlag<Boolean> getRoundRunningFlag() {
        return this.roundRunning.getImmutable();
    }

    public VIPGameState getGameState() {
        return (VIPGameState)((Object)this.gameState.getFlag());
    }

    public ImmutableFlag<VIPGameState> getGameStateFlag() {
        return this.gameState.getImmutable();
    }

    public boolean isMeAlive() {
        return this.isRoundRunning() && this.alive;
    }

    public boolean isMeCounterTerrorist() {
        return this.isCounterTerrorist(this.getId());
    }

    public boolean isMeTerrorist() {
        return this.isTerrorist(this.getId());
    }

    public boolean isMeVIP() {
        return this.isVIP(this.getId());
    }

    public CSBotState getMyState() {
        return this.getBotState(this.getId());
    }

    public CSBotState getBotState(UnrealId id) {
        if (this.records.containsKey(id)) {
            return this.ensureRecord(id).getBotState();
        }
        return null;
    }

    public int getTeamScore() {
        return this.ensureRecord(this.getId()).getMyTeamScore();
    }

    public int getTeamRoundWinCount() {
        return this.ensureRecord(this.getId()).getMyTeamWins();
    }

    public VIPGameResult getWinningTeam() {
        return this.ensureRecord(this.getId()).getGameResult();
    }

    public boolean isCounterTerrorist(UnrealId botId) {
        if (!this.isRoundRunning()) {
            return false;
        }
        CSBotRecord<Player> record = this.ensureRecord(botId);
        if (record.getBotState() != null) {
            return record.getBotState().role.team == CSBotTeam.COUNTER_TERRORIST;
        }
        if (record.getBotId() == this.info.getId()) {
            return this.info.getTeam() == CSBotTeam.COUNTER_TERRORIST.ut2004Team;
        }
        if (record.getPlayer() != null) {
            return record.getPlayer().getTeam() == CSBotTeam.COUNTER_TERRORIST.ut2004Team;
        }
        return false;
    }

    public boolean isTerrorist(UnrealId botId) {
        if (!this.isRoundRunning()) {
            return false;
        }
        CSBotRecord<Player> record = this.ensureRecord(botId);
        if (record.getBotState() != null) {
            return record.getBotState().role.team == CSBotTeam.TERRORIST;
        }
        if (record.getBotId() == this.info.getId()) {
            return this.info.getTeam() == CSBotTeam.TERRORIST.ut2004Team;
        }
        if (record.getPlayer() != null) {
            return record.getPlayer().getTeam() == CSBotTeam.TERRORIST.ut2004Team;
        }
        return false;
    }

    public boolean isVIP(UnrealId botId) {
        if (!this.isRoundRunning()) {
            return false;
        }
        if (this.vip != null && this.vip.getBotId() == botId) {
            return true;
        }
        CSBotRecord<Player> record = this.ensureRecord(botId);
        if (record.getBotState() != null) {
            return record.getBotState().role == CSBotRole.VIP;
        }
        return false;
    }

    public double getRemainingRoundTime() {
        return this.isRoundRunning() ? this.roundState.getRoundTimeLeftUT() : Double.POSITIVE_INFINITY;
    }

    public UnrealId getVIPId() {
        return this.vip == null ? null : this.vip.getBotId();
    }

    public VIPGameConfig getGameConfig() {
        return this.gameConfig;
    }

    public Location getVIPSafeArea() {
        return this.vipSafeArea;
    }

    public NavPoint getVIPSafeAreaNavPoint() {
        if (this.vipSafeArea == null) {
            return null;
        }
        return (NavPoint)DistanceUtils.getNearest(this.worldView.getAll(NavPoint.class).values(), (ILocated)this.getVIPSafeArea());
    }

    public Double getVIPSafeAreaDistance(ILocated located) {
        if (located == null) {
            return Double.POSITIVE_INFINITY;
        }
        Location safeArea = this.getVIPSafeArea();
        if (safeArea == null) {
            return Double.POSITIVE_INFINITY;
        }
        Location location = located.getLocation();
        if (location == null) {
            return Double.POSITIVE_INFINITY;
        }
        return safeArea.getDistance(location) - (double)this.gameConfig.getVipSafeAreaRadius();
    }

    public Double getMySafeAreaDistance() {
        return this.getVIPSafeAreaDistance((ILocated)this.info.getLocation());
    }

    public Boolean isInVIPSafeArea(ILocated located) {
        Double distance = this.getVIPSafeAreaDistance(located);
        if (distance == null) {
            return null;
        }
        return distance <= 0.0;
    }

    protected void beginMessage(BeginMessage event) {
        this.simTimeCurrent = event.getSimTime();
    }

    protected void playerUpdate(IWorldObjectEvent<PlayerMessage> event) {
        if (((PlayerMessage)event.getObject()).isSpectator().booleanValue()) {
            return;
        }
        CSBotRecord<Player> record = this.ensureRecord(((PlayerMessage)event.getObject()).getId());
        if (record != null) {
            record.setPlayer((Player)event.getObject());
        }
    }

    protected void playerLeft(PlayerLeft event) {
        CSBotRecord<Player> record = this.ensureRecord(event.getId());
        if (record != null) {
            record.setInGame(false);
        }
    }

    protected void playerJoinsGame(PlayerJoinsGame event) {
        this.ensureRecord(event.getId());
    }

    protected void playerKilled(PlayerKilled event) {
        CSBotRecord<Player> record = this.ensureRecord(event.getId());
        record.botDied(event.getId());
    }

    protected void botKilled(BotKilled event) {
        this.alive = false;
    }

    protected void spawn(Spawn event) {
        this.alive = true;
    }

    protected void csAssignVIP(CSAssignVIP event) {
        this.vip = this.ensureRecord(event.getBotId());
        this.vip.setVIPForThisRound();
        if (this.vip.getBotId() == this.getId()) {
            this.updateBotNameTag();
        }
    }

    protected void csBotStateChanged(CSBotStateChanged event) {
        this.ensureRecord(event.getBotId()).setBotState(event.getNewStateEnum());
    }

    protected void csCounterTerroristsWin(CSCounterTerroristsWin event) {
        for (CSBotRecord<Player> record : this.records.values()) {
            record.counterTerroristsWin();
        }
    }

    protected void csRoundEnd(CSRoundEnd event) {
        this.roundRunning.setFlag((Object)false);
        this.gameState.setFlag((Object)VIPGameState.ROUND_ENDED);
    }

    protected void csRoundStart(CSRoundStart event) {
        this.vip = null;
        this.vipSafeArea = null;
        for (CSBotRecord<Player> record : this.records.values()) {
            int ut2004Team;
            if (!record.isInGame()) continue;
            if (record.getBotId() == this.info.getId()) {
                ut2004Team = this.info.getTeam();
            } else {
                if (record.getPlayer() == null) continue;
                ut2004Team = record.getPlayer().getTeam();
            }
            switch (ut2004Team) {
                case 0: {
                    record.setBotState(CSBotState.TERRORIST);
                    break;
                }
                case 1: {
                    record.setBotState(CSBotState.COUNTER_TERRORIST);
                }
            }
        }
    }

    protected void csRoundState(CSRoundState event) {
        switch (event.getGameStateEnum()) {
            case ROUND_RUNNING: {
                for (CSBotRecord<Player> record : this.records.values()) {
                    record.setSpawned(true);
                }
                this.updateBotNameTag();
                this.roundRunning.setFlag((Object)true);
            }
        }
        this.roundState = event;
        this.gameState.setFlag((Object)event.getGameStateEnum());
    }

    protected void csSetVIPSafeArea(CSSetVIPSafeArea event) {
        this.vipSafeArea = event.getSafeArea();
    }

    protected void csTeamScoreChangedListener(CSTeamScoreChanged event) {
        for (CSBotRecord<Player> record : this.records.values()) {
            record.teamScoreChanged(event);
        }
        if (event.getUt2004Team() == this.info.getTeam()) {
            this.updateBotNameTag();
        }
    }

    protected void csTerroristsWin(CSTerroristsWin event) {
        for (CSBotRecord<Player> record : this.records.values()) {
            record.terroristsWin();
        }
    }

    protected void csVIPKilled(CSVIPKilled event) {
        if (this.vip != null) {
            this.vip.botDied(event.getKillerId());
        }
    }

    protected void csVIPSafe(CSVIPSafe event) {
        for (CSBotRecord<Player> record : this.records.values()) {
            record.vipSafe(event.getVipId());
        }
    }

    protected void csVIPGameEnd(VIPGameEnd event) {
        this.roundRunning.setFlag((Object)false);
        this.gameState.setFlag((Object)VIPGameState.NOT_RUNNING);
        this.gameRunning.setFlag((Object)false);
        this.removeBotNameTag();
    }

    protected void csVIPGameStart(VIPGameStart event) {
        this.gameConfig = new VIPGameConfig(event);
        this.resetCSGameData();
        this.gameRunning.setFlag((Object)true);
    }

    private CSBotRecord<Player> ensureRecord(UnrealId botId) {
        if (botId == null || botId == UT2004VIPServer.SERVER_UNREAL_ID) {
            return null;
        }
        if (!((Boolean)this.gameRunning.getFlag()).booleanValue()) {
            return null;
        }
        CSBotRecord<Player> record = this.records.get(botId);
        record.setInGame(true);
        Player player = this.players.getPlayer(botId);
        if (player != null) {
            record.setPlayer(player);
        }
        return record;
    }

    private void deleteRecord(UnrealId botId) {
        this.records.remove(botId);
    }

    private void resetCSGameData() {
        this.records.clear();
        this.removeBotNameTag();
    }

    private void removeBotNameTag() {
        this.info.getBotName().deleteInfo("CS");
    }

    private void updateBotNameTag() {
        CSBotState myState = this.records.get(this.getId()).getBotState();
        if (myState != null) {
            this.info.getBotName().setInfo("CS", myState.name() + " | " + this.records.get(this.getId()).getMyTeamWins());
        }
    }

    protected void start(boolean startToPaused) {
        super.start(startToPaused);
        this.csTranslator.enable();
        this.vipEvents.enableCSEvents();
        ((UT2004Bot)this.agent).getWorldView().addEventListener(BeginMessage.class, this.beginMessageListener);
        ((UT2004Bot)this.agent).getWorldView().addEventListener(BotKilled.class, this.botKilledMessageListener);
        ((UT2004Bot)this.agent).getWorldView().addEventListener(Spawn.class, this.spawnMessageListener);
        ((UT2004Bot)this.agent).getWorldView().addEventListener(PlayerJoinsGame.class, this.myPlayerJoinsGameMessageListener);
        ((UT2004Bot)this.agent).getWorldView().addEventListener(PlayerLeft.class, this.myPlayerLeftMessageListener);
        ((UT2004Bot)this.agent).getWorldView().addObjectListener(Player.class, WorldObjectUpdatedEvent.class, this.myPlayerListener);
    }

    protected void cleanUp() {
        super.cleanUp();
        this.csTranslator.disable();
        this.vipEvents.disableTagEvents();
        ((UT2004Bot)this.agent).getWorldView().removeEventListener(BeginMessage.class, this.beginMessageListener);
        ((UT2004Bot)this.agent).getWorldView().removeEventListener(BotKilled.class, this.botKilledMessageListener);
        ((UT2004Bot)this.agent).getWorldView().removeEventListener(Spawn.class, this.spawnMessageListener);
        ((UT2004Bot)this.agent).getWorldView().removeEventListener(PlayerJoinsGame.class, this.myPlayerJoinsGameMessageListener);
        ((UT2004Bot)this.agent).getWorldView().removeEventListener(PlayerLeft.class, this.myPlayerLeftMessageListener);
        ((UT2004Bot)this.agent).getWorldView().removeObjectListener(Player.class, WorldObjectUpdatedEvent.class, this.myPlayerListener);
    }
}

