/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.ut2004testfw;

import cz.cuni.amis.pogamut.ut2004.ut2004testfw.MatchesExecutor;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.config.BotTemplate;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.config.MatchConfig;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.measure.IMeasure;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.utils.CsvReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.IntervalXYDataset;

public class PerformanceReport
extends AbstractMavenReport {
    private ArrayList<BotTemplate> bots;
    private ArrayList<MatchConfig> matchSets;
    private ArrayList<IMeasure> measures;
    private String utPath;
    private String outputDirectory;
    private MavenProject project;
    private Renderer siteRenderer;
    private static HashMap<String, String> tooltips = new HashMap();

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    private File generateGraph(String id, String measure, String name, ArrayList<Double> series) throws IOException {
        HistogramDataset dataset = new HistogramDataset();
        dataset.setType(HistogramType.RELATIVE_FREQUENCY);
        double[] serie = new double[series.size()];
        for (int i = 0; i < serie.length; ++i) {
            serie[i] = series.get(i);
        }
        dataset.addSeries((Comparable)((Object)"test"), serie, serie.length > 20 ? 20 : serie.length);
        JFreeChart chart = ChartFactory.createHistogram((String)name, (String)measure, (String)"occurence", (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        File saveDir = new File(this.getOutputDirectory() + File.separator + "matches" + File.separator + "graphs" + File.separator);
        saveDir.mkdirs();
        File saveFile = new File(saveDir, id + ".png");
        ChartUtilities.saveChartAsPNG((File)saveFile, (JFreeChart)chart, (int)600, (int)400);
        return saveFile;
    }

    private HashMap<String, HashMap<String, List<CsvReader.CsvRow>>> readResults() throws FileNotFoundException, IOException {
        HashMap<String, HashMap<String, List<CsvReader.CsvRow>>> data = new HashMap<String, HashMap<String, List<CsvReader.CsvRow>>>();
        CsvReader reader = new CsvReader(this.getOutputDirectory() + File.separator + "matches" + File.separator + "results", ";");
        CsvReader.CsvRow row = null;
        while ((row = reader.readRow()) != null) {
            HashMap<String, List<CsvReader.CsvRow>> matchData;
            String measureName = row.getString("measureName");
            String matchId = row.getString("matchId");
            if (!data.containsKey(measureName)) {
                data.put(measureName, new HashMap());
            }
            if (!(matchData = data.get(measureName)).containsKey(matchId)) {
                matchData.put(matchId, new ArrayList());
            }
            matchData.get(matchId).add(row);
        }
        return data;
    }

    private HashMap<String, File> generateGraphs(HashMap<String, HashMap<String, List<CsvReader.CsvRow>>> data) throws IOException {
        HashMap<String, File> graphs = new HashMap<String, File>();
        for (String measureName : data.keySet()) {
            HashMap<String, List<CsvReader.CsvRow>> measureResults = data.get(measureName);
            ArrayList<Double> measureData = new ArrayList<Double>();
            for (String matchId : measureResults.keySet()) {
                ArrayList<Double> matchData = new ArrayList<Double>();
                for (CsvReader.CsvRow row : measureResults.get(matchId)) {
                    Double result = row.getDouble("measureResult");
                    matchData.add(result);
                    measureData.add(result);
                }
                String id = PerformanceReport.getId(measureName, matchId);
                File graph = this.generateGraph(id, measureName, matchId, matchData);
                if (graphs.containsKey(id)) {
                    Logger.getLogger(PerformanceReport.class.getName()).log(Level.WARNING, "Conflicts in measureName, matchName pairing. {0}.png overwritten.", id);
                }
                graphs.put(id, graph);
            }
            String id = PerformanceReport.getId(measureName, "all");
            File graph = this.generateGraph(id, measureName, "All matches", measureData);
            if (graphs.containsKey(id)) {
                Logger.getLogger(PerformanceReport.class.getName()).log(Level.WARNING, "Conflicts in measureName, matchName pairing. {0}.png overwritten.", id);
            }
            graphs.put(id, graph);
        }
        return graphs;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        ArrayList<String> names = new ArrayList<String>();
        int size = this.measures.size();
        int i = 0;
        while (i < size) {
            IMeasure m = this.measures.get(i);
            if (m.getName() == null || m.getName().equals("")) {
                Logger.getLogger(PerformanceReport.class.getName()).log(Level.WARNING, "Measure {0} doesnt have its name set, ommiting", m.getClass().getName());
                this.measures.remove(i);
                --size;
                continue;
            }
            if (names.contains(m.getName())) {
                Logger.getLogger(PerformanceReport.class.getName()).log(Level.WARNING, "Duplicate measure name {0}", m.getName());
                this.measures.remove(i);
                --size;
                continue;
            }
            ++i;
            names.add(m.getName());
        }
        File outputDir = new File(this.getOutputDirectory() + File.separator + "matches" + File.separator);
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        String run = System.getProperty("uttest.runtests");
        boolean runtests = true;
        if (run != null && run.equals("false")) {
            runtests = false;
        }
        if (runtests) {
            MatchesExecutor executor = new MatchesExecutor(this.matchSets, this.bots, this.measures, this.utPath, this.getOutputDirectory() + File.separator + "matches");
            executor.executeMatches();
        }
        try {
            this.writeReport();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(PerformanceReport.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(PerformanceReport.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void writeReport() throws FileNotFoundException, IOException {
        File res = new File(this.getOutputDirectory() + File.separator + "matches" + File.separator + "res" + File.separator);
        if (!res.exists()) {
            if (!res.mkdirs()) {
                throw new IOException("The resource folder '" + res.getAbsolutePath() + "' could not be created");
            }
            this.copyResourceTo("/results.css", res);
            this.copyResourceTo("/display.js", res);
        }
        HashMap<String, HashMap<String, List<CsvReader.CsvRow>>> data = this.readResults();
        HashMap<String, File> graphs = this.generateGraphs(data);
        Sink sink = this.getSink();
        sink.head();
        sink.title();
        sink.text("Bot Performance");
        sink.title_();
        sink.head_();
        sink.body();
        sink.rawText("<link rel=\"stylesheet\" href=\"./matches/res/results.css\" type=\"text/css\" />");
        sink.rawText("<script type=\"text/javascript\" src=\"./matches/res/display.js\"></script>");
        sink.section1();
        sink.sectionTitle1();
        sink.text("Bot Performance");
        sink.sectionTitle1_();
        boolean first = true;
        sink.rawText("<div id=\"menu\">");
        for (IMeasure measure : this.measures) {
            sink.rawText("<span class=\"menuMain\">");
            String id = PerformanceReport.getId(measure.getName(), "all");
            sink.rawText("<a class=\"picker" + (first ? " selected" : "") + "\" id=\"" + measure.getName() + "Picker\" href=\"javascript:;\" onclick=\"displayGroup('" + id + "')\" onmouseover=\"display('" + measure.getName() + "Pick')\" onmouseout=\"hide('" + measure.getName() + "Pick')\">" + measure.getName() + "</a>");
            sink.rawText("<div class=\"menuPick\" id=\"" + measure.getName() + "Pick\" onmouseover=\"interruptHide()\" onmouseout=\"hide('" + measure.getName() + "Pick')\">");
            boolean odd = false;
            for (MatchConfig config : this.matchSets) {
                id = PerformanceReport.getId(measure.getName(), config.getId());
                sink.rawText("<div class=\"menuItem" + (odd ? " odd" : "") + "\"><a href=\"javascript:;\" onclick=\"displayGroup('" + id + "')\">" + config.getId() + "</a></div>");
                odd = !odd;
            }
            sink.rawText("</div>");
            sink.rawText("</span>");
            first = false;
        }
        sink.rawText("</div>");
        sink.rawText("<div id=\"graphBox\">");
        this.generateMain();
        for (IMeasure measure : this.measures) {
            ArrayList<CsvReader.CsvRow> all = new ArrayList<CsvReader.CsvRow>();
            for (MatchConfig match : this.matchSets) {
                String id = PerformanceReport.getId(measure.getName(), match.getId());
                File g = graphs.get(id);
                HashMap<String, List<CsvReader.CsvRow>> get = data.get(measure.getName());
                List<Object> d = get != null ? get.get(match.getId()) : new ArrayList();
                this.generateMeasure(measure, match, id, g, false, d);
                all.addAll(d);
            }
            String id = PerformanceReport.getId(measure.getName(), "all");
            File g = graphs.get(id);
            this.generateMeasure(measure, null, id, g, false, all);
        }
        sink.rawText("</div>");
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void generateMain() {
        Sink sink = this.getSink();
        sink.rawText("<div class=\"group\" id=\"default\">");
        sink.rawText("<h3>Available reports</h3>");
        sink.list();
        for (IMeasure measure : this.measures) {
            sink.listItem();
            String id = PerformanceReport.getId(measure.getName(), "all");
            sink.rawText("<a href=\"javascript:;\" onclick=\"displayGroup('" + id + "')\"\">" + measure.getName() + ": </a>");
            sink.text(measure.getDescription());
            sink.listItem_();
        }
        sink.list_();
        sink.rawText("</div>");
    }

    private void generateMeasure(IMeasure measure, MatchConfig match, String id, File chart, boolean visible, List<CsvReader.CsvRow> data) {
        Sink sink = this.getSink();
        sink.rawText("<div class=\"group\" id=\"" + id + "\" style=\"visibility:" + (visible ? "visible" : "hidden;display:none") + ";\">");
        sink.rawText("<h3>" + measure.getName() + (match == null ? "" : "-" + match.getId()) + "</h3>");
        if (chart == null) {
            sink.rawText("No chart yet.");
        } else {
            sink.rawText("<img src=\"matches" + File.separator + "graphs" + File.separator + chart.getName() + "\" />");
        }
        ArrayList<CsvReader.CsvRow> results = new ArrayList<CsvReader.CsvRow>();
        ArrayList<CsvReader.CsvRow> lastResults = new ArrayList<CsvReader.CsvRow>();
        int max = 0;
        for (CsvReader.CsvRow row : data) {
            int testId = row.getInt("testId");
            if (testId > max) {
                lastResults.clear();
                max = testId;
            }
            if (testId == max) {
                lastResults.add(row);
            }
            results.add(row);
        }
        sink.rawText("<h3>Last test results</h3>");
        sink.table();
        if (match == null) {
            PerformanceReport.printHeader(sink, "match id", "measure result", "percentile", "replay");
        } else {
            PerformanceReport.printHeader(sink, "measure result", "percentile", "replay");
        }
        DecimalFormat format = new DecimalFormat("#.#'%'");
        for (CsvReader.CsvRow result : lastResults) {
            double percentile = this.calculatePercentile(result, results);
            String replay = result.getString("matchId") + "-" + result.getString("runId") + "-replay.demo4";
            if (match == null) {
                PerformanceReport.printRow(sink, result.getString("matchId"), result.getDouble("measureResult"), format.format(percentile), "<a href=\"matches/" + replay + "\">Download replay</a>");
                continue;
            }
            PerformanceReport.printRow(sink, result.getDouble("measureResult"), format.format(percentile), "<a href=\"matches/" + replay + "\">Download replay</a>");
        }
        sink.table_();
        sink.rawText("<h3>Testing history</h3>");
        sink.table();
        if (match == null) {
            PerformanceReport.printHeader(sink, "match id", "test id", "run id", "measure result");
        } else {
            PerformanceReport.printHeader(sink, "test id", "run id", "measure result");
        }
        Collections.sort(results, new Comparator<CsvReader.CsvRow>(){

            @Override
            public int compare(CsvReader.CsvRow o1, CsvReader.CsvRow o2) {
                Integer i1 = o1.getInt("testId");
                Integer r1 = o1.getInt("runId");
                String n1 = o1.getString("matchId");
                Integer i2 = o2.getInt("testId");
                Integer r2 = o2.getInt("runId");
                String n2 = o2.getString("matchId");
                int compare = i1.compareTo(i2);
                if (compare != 0) {
                    return compare;
                }
                compare = n1.compareTo(n2);
                if (compare != 0) {
                    return compare;
                }
                return r1.compareTo(r2);
            }
        });
        for (CsvReader.CsvRow row : results) {
            if (match == null) {
                PerformanceReport.printRow(sink, row.getString("matchId"), row.getString("testId"), row.getString("runId"), row.getString("measureResult"));
                continue;
            }
            PerformanceReport.printRow(sink, row.getString("testId"), row.getString("runId"), row.getString("measureResult"));
        }
        sink.table_();
        sink.rawText("</div>");
    }

    private static void printRow(Sink sink, Object ... cells) {
        sink.tableRow();
        for (Object cell : cells) {
            sink.tableCell();
            sink.rawText(cell.toString());
            sink.tableCell_();
        }
        sink.tableRow_();
    }

    private static void printHeader(Sink sink, Object ... cells) {
        sink.tableRow();
        for (Object cell : cells) {
            String tooltip = null;
            if (tooltips.containsKey(cell.toString())) {
                tooltip = tooltips.get(cell.toString());
            }
            if (tooltip != null) {
                sink.rawText("<th onmouseout=\"tooltip.hide()\" onmouseover=\"tooltip.show('" + tooltip.replaceAll("'", "\\'") + "', 300)\">");
            } else {
                sink.tableHeaderCell();
            }
            sink.rawText(cell.toString());
            sink.tableHeaderCell_();
        }
        sink.tableRow_();
    }

    public String getOutputName() {
        return "performance-report";
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.performance-report.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.performance-report.description");
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("performance-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void copyResourceTo(String resource, File dir) throws FileNotFoundException, IOException {
        PerformanceReport.class.getResourceAsStream(resource);
        InputStream fis = PerformanceReport.class.getResourceAsStream(resource);
        FileOutputStream fos = new FileOutputStream(new File(dir, resource));
        try {
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static String getId(String measureName, String matchId) {
        return measureName.replaceAll(" ", "") + '-' + matchId.replaceAll(" ", "");
    }

    private double calculatePercentile(CsvReader.CsvRow row, List<CsvReader.CsvRow> data) {
        double count = 0.0;
        double result = row.getDouble("measureResult");
        for (CsvReader.CsvRow r : data) {
            if (!(r.getDouble("measureResult") <= result)) continue;
            count += 1.0;
        }
        return count / (double)data.size() * 100.0;
    }

    static {
        tooltips.put("match id", "A match id specifies the match set of the result. A match set is several matches that occur on the same map in the same conditions.");
        tooltips.put("test id", "A test runs all the match sets, a test id is an incrementing identification number of the test.");
        tooltips.put("run id", "A match set can contain several matches or runs. The run id distinguishes these matches.");
        tooltips.put("measure result", "A measure result is an aggregated result from one match, from all the observed bots. This could be for example an average frag count, or maximum deaths.");
        tooltips.put("percentile", "How much of the results in this dataset are smaller than this result.");
        tooltips.put("replay", "A replay of the match. You can use rk DemoWatcher to play these.");
    }
}

