/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.ut2004testfw.config;

import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.tournament.capturetheflag.UT2004CaptureTheFlag;
import cz.cuni.amis.pogamut.ut2004.tournament.capturetheflag.UT2004CaptureTheFlagConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatch;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004Match;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004MatchConfig;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.config.BotTemplate;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.config.ParticipantConfig;
import java.io.File;
import java.util.Map;

public class MatchConfig {
    private int fragLimit;
    private String gameType;
    private String id;
    private String map;
    private int runs;
    private ParticipantConfig[] participants;

    public String getMap() {
        return this.map;
    }

    public int getFragLimit() {
        return this.fragLimit;
    }

    public int getRuns() {
        return this.runs;
    }

    public String getHash() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public UT2004Match createMatch(String utPath, Map<String, BotTemplate> bots, int id) {
        if (this.gameType.equals("deathmatch")) {
            return this.createDeathMatch(utPath, bots, id);
        }
        if (this.gameType.equals("ctf")) {
            return this.createCTFMatch(utPath, bots, id);
        }
        throw new IllegalArgumentException("Game type is not valid");
    }

    private UT2004Match createDeathMatch(String utPath, Map<String, BotTemplate> bots, int id) {
        UT2004DeathMatchConfig matchConfig = new UT2004DeathMatchConfig();
        matchConfig.setMatchId("TestingMatch");
        matchConfig.setOutputDirectory(new File("target" + File.separator + "matches" + File.separator + "match" + id));
        matchConfig.setFragLimit(this.fragLimit);
        matchConfig.setTimeLimit(this.fragLimit + 1);
        matchConfig.getUccConf().setStartOnUnusedPort(true);
        matchConfig.getUccConf().setUnrealHome(utPath);
        matchConfig.getUccConf().setGameType("BotDeathMatch");
        matchConfig.getUccConf().setMapName(this.map);
        for (ParticipantConfig participant : this.participants) {
            participant.addParticipants((UT2004MatchConfig)matchConfig, bots);
        }
        return new UT2004DeathMatch(matchConfig, new LogCategory("DM"));
    }

    private UT2004Match createCTFMatch(String utPath, Map<String, BotTemplate> bots, int id) {
        UT2004CaptureTheFlagConfig matchConfig = new UT2004CaptureTheFlagConfig();
        matchConfig.setMatchId("TestingMatch");
        matchConfig.setOutputDirectory(new File("target" + File.separator + "matches" + File.separator + "match" + id));
        matchConfig.setScoreLimit(this.fragLimit);
        matchConfig.setTimeLimit(this.fragLimit + 1);
        matchConfig.getUccConf().setStartOnUnusedPort(true);
        matchConfig.getUccConf().setUnrealHome(utPath);
        matchConfig.getUccConf().setMapName(this.map);
        for (ParticipantConfig participant : this.participants) {
            participant.addParticipants((UT2004MatchConfig)matchConfig, bots);
        }
        return new UT2004CaptureTheFlag(matchConfig, new LogCategory("CTFMatch"));
    }
}

