/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.hideandseek.tournament;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateRunning;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.analyzer.IUT2004AnalyzerObserver;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004Analyzer;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004AnalyzerFullObserver;
import cz.cuni.amis.pogamut.ut2004.analyzer.stats.UT2004AnalyzerObsStats;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StartPlayers;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.hideandseek.server.HSBotRecord;
import cz.cuni.amis.pogamut.ut2004.hideandseek.server.UT2004HSServer;
import cz.cuni.amis.pogamut.ut2004.hideandseek.server.UT2004HSServerModule;
import cz.cuni.amis.pogamut.ut2004.hideandseek.tournament.UT2004HideAndSeekConfig;
import cz.cuni.amis.pogamut.ut2004.hideandseek.tournament.UT2004HideAndSeekResult;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.tournament.botexecution.UT2004BotExecution;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004Match;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004MatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.result.UT2004MatchResult;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.FilePath;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutIOException;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004HideAndSeek
extends UT2004Match<UT2004HideAndSeekConfig, UT2004HideAndSeekResult> {
    private String origFixedSeekerName = null;

    public UT2004HideAndSeek(UT2004HideAndSeekConfig config, LogCategory log) {
        super(false, (UT2004MatchConfig)config, log);
    }

    protected void changeBotTeam(UT2004Server server, UnrealId botId, int desiredTeam) {
    }

    protected UT2004MatchResult waitMatchFinish(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots, long timeoutInMillis) {
        UT2004HideAndSeekResult uT2004HideAndSeekResult;
        FlagListener<IAgentState> serverObs;
        HashMap<IToken, 1> customBotObservers;
        block37: {
            long minTimeoutMillis;
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": Waiting for the match to finish...");
            }
            if ((minTimeoutMillis = Math.round((double)((UT2004HideAndSeekConfig)this.config).getHsConfig().getRoundCount() * ((UT2004HideAndSeekConfig)this.config).getHsConfig().getRoundTimeUT() * 1000.0 + (double)(((UT2004HideAndSeekConfig)this.config).getHsConfig().getRoundCount() * 60 * 1000) + 300000.0)) > timeoutInMillis) {
                timeoutInMillis = minTimeoutMillis;
                this.log.warning(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": match global timeout set to " + minTimeoutMillis / 1000L + " seconds");
            }
            customBotObservers = new HashMap<IToken, 1>(((UT2004HideAndSeekConfig)this.config).getBots().size());
            serverObs = null;
            FlagListener<Boolean> uccObs = null;
            FlagListener<Boolean> hsGameRunning = null;
            final CountDownLatch waitLatch = new CountDownLatch(1);
            final AdaptableProvider oneOfBotsDiedOut = new AdaptableProvider((Object)false);
            final AdaptableProvider serverDiedOut = new AdaptableProvider((Object)false);
            boolean exception = false;
            try {
                HSBotRecord botRecord;
                for (UT2004BotConfig botConfig : ((UT2004HideAndSeekConfig)this.config).getBots().values()) {
                    FlagListener<Boolean> obs = new FlagListener<Boolean>(){

                        public void flagChanged(Boolean changedValue) {
                            if (!changedValue.booleanValue()) {
                                oneOfBotsDiedOut.set((Object)true);
                                waitLatch.countDown();
                            }
                        }
                    };
                    ((UT2004BotExecution)bots.bots.get(botConfig.getBotId())).getRunning().addListener((FlagListener)obs);
                    customBotObservers.put(botConfig.getBotId(), obs);
                    if (((Boolean)((UT2004BotExecution)bots.bots.get(botConfig.getBotId())).getRunning().getFlag()).booleanValue()) continue;
                    oneOfBotsDiedOut.set((Object)true);
                    waitLatch.countDown();
                    throw new PogamutException("One of custom bots died out from the start, failure!", (Logger)this.log, (Object)this);
                }
                serverObs = new FlagListener<IAgentState>(){

                    public void flagChanged(IAgentState changedValue) {
                        if (changedValue instanceof IAgentStateDown) {
                            serverDiedOut.set((Object)true);
                            waitLatch.countDown();
                        }
                    }
                };
                server.getState().addListener((FlagListener)serverObs);
                if (server.notInState(new Class[]{IAgentStateUp.class})) {
                    serverDiedOut.set((Object)true);
                    waitLatch.countDown();
                    throw new PogamutException("Server is dead from the start, failure!", (Logger)this.log, (Object)this);
                }
                if (!((Boolean)((UT2004HSServer)server).isGameRunning().getFlag()).booleanValue()) {
                    serverDiedOut.set((Object)true);
                    waitLatch.countDown();
                    throw new PogamutException("Hide&Seek game is not running at the beginning, invalid!", (Logger)this.log, (Object)this);
                }
                hsGameRunning = new FlagListener<Boolean>(){

                    public void flagChanged(Boolean changedValue) {
                        if (!changedValue.booleanValue()) {
                            waitLatch.countDown();
                        }
                    }
                };
                ((UT2004HSServer)server).isGameRunning().addListener((FlagListener)hsGameRunning);
                uccObs = new FlagListener<Boolean>(){

                    public void flagChanged(Boolean changedValue) {
                        if (changedValue.booleanValue()) {
                            serverDiedOut.set((Object)true);
                            waitLatch.countDown();
                        }
                    }
                };
                ucc.getGameEnding().addListener((FlagListener)uccObs);
                waitLatch.await(timeoutInMillis, TimeUnit.MILLISECONDS);
                if (waitLatch.getCount() > 0L) {
                    throw new PogamutException("TIMEOUT! The match did not end in " + timeoutInMillis / 1000L + " secs.", (Logger)this.log, (Object)this);
                }
                bots.matchEnd = System.currentTimeMillis();
                if (((Boolean)oneOfBotsDiedOut.get()).booleanValue()) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        throw new PogamutInterruptedException("Interrupted while giving GB2004 time to tear down its connection.", (Logger)this.log, (Object)this);
                    }
                    try {
                        server.getAct().act((CommandMessage)new StartPlayers());
                    }
                    catch (Exception e) {
                        serverDiedOut.set((Object)true);
                    }
                    if (!((Boolean)serverDiedOut.get()).booleanValue()) {
                        this.log.warning("ONE OF BOTS HAS DIED OUT, BUT SERVER IS STILL RUNNING ... POSSIBLE MATCH FAILURE!");
                    }
                }
                if (((Boolean)((UT2004HSServer)server).getGameFailed().getFlag()).booleanValue()) {
                    throw new PogamutException("UT2004HSServer reported failure!", (Logger)this.log, (Object)this);
                }
                if (!((Boolean)serverDiedOut.get()).booleanValue() && server.inState(new Class[]{IAgentStateUp.class})) {
                    server.kill();
                }
                if (ucc != null) {
                    try {
                        if (this.log != null && this.log.isLoggable(Level.INFO)) {
                            this.log.info(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": Killing UCC...");
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        ucc.stop();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                UT2004HSServer hsServer = (UT2004HSServer)server;
                HashMap<IToken, HSBotRecord<PlayerMessage>> botRecordMap = new HashMap<IToken, HSBotRecord<PlayerMessage>>();
                ArrayList<HSBotRecord<PlayerMessage>> botRecords = new ArrayList<HSBotRecord<PlayerMessage>>();
                for (Map.Entry<UnrealId, HSBotRecord<PlayerMessage>> entryRecord : hsServer.getBotRecords().entrySet()) {
                    if (entryRecord.getValue().getPlayer() == null || entryRecord.getValue().getPlayer().getJmx() == null) continue;
                    IToken botId = (IToken)bots.unrealId2BotId.get(entryRecord.getKey());
                    botRecordMap.put(botId, entryRecord.getValue());
                    botRecords.add(entryRecord.getValue());
                }
                if (botRecords.size() == 0) {
                    throw new PogamutException("There are not bots results, it seems like the match has not been even played ???", (Logger)this.log, (Object)this);
                }
                Collections.sort(botRecords, new Comparator<HSBotRecord<PlayerMessage>>(){

                    @Override
                    public int compare(HSBotRecord<PlayerMessage> o1, HSBotRecord<PlayerMessage> o2) {
                        return o2.getScore() - o1.getScore();
                    }
                });
                ArrayList<IToken> winners = new ArrayList<IToken>(1);
                int maxScore = ((HSBotRecord)botRecords.get(0)).getScore();
                Iterator i$ = botRecords.iterator();
                while (i$.hasNext() && maxScore == (botRecord = (HSBotRecord)i$.next()).getScore()) {
                    IToken botId = (IToken)bots.unrealId2BotId.get(botRecord.getBotId());
                    winners.add(botId);
                }
                if (winners.size() == 0) {
                    throw new PogamutException("There is no WINNER, impossible! **puzzled**", (Logger)this.log, (Object)this);
                }
                if (winners.size() > 1) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("There is more than one winner with highest score == " + maxScore + ": ");
                    boolean first = true;
                    for (IToken id : winners) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(", ");
                        }
                        sb.append("Bot[botId=" + id + ", unrealId=" + bots.botId2UnrealId.get(id) + ", score=" + ((HSBotRecord)botRecordMap.get(id)).getScore() + "]");
                    }
                    sb.append(".");
                    if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                        this.log.warning(sb.toString());
                    }
                }
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": MATCH FINISHED!");
                }
                uT2004HideAndSeekResult = this.processResults(ucc, server, analyzer, bots, winners, botRecordMap);
                if (hsGameRunning == null) break block37;
            }
            catch (Exception e) {
                try {
                    exception = true;
                    throw new PogamutException("Failed to perform the match!", (Throwable)e, (Logger)this.log, (Object)this);
                }
                catch (Throwable throwable) {
                    if (hsGameRunning != null) {
                        ((UT2004HSServer)server).isGameRunning().removeListener(hsGameRunning);
                        hsGameRunning = null;
                    }
                    for (Map.Entry entry : customBotObservers.entrySet()) {
                        ((UT2004BotExecution)bots.bots.get(entry.getKey())).getRunning().removeListener((FlagListener)entry.getValue());
                    }
                    server.getState().removeListener(serverObs);
                    throw throwable;
                }
            }
            ((UT2004HSServer)server).isGameRunning().removeListener((FlagListener)hsGameRunning);
            hsGameRunning = null;
        }
        for (Map.Entry entry : customBotObservers.entrySet()) {
            ((UT2004BotExecution)bots.bots.get(entry.getKey())).getRunning().removeListener((FlagListener)entry.getValue());
        }
        server.getState().removeListener((FlagListener)serverObs);
        return uT2004HideAndSeekResult;
    }

    protected UT2004HideAndSeekResult processResults(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots, List<IToken> winners, Map<IToken, HSBotRecord<PlayerMessage>> botRecords) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": Processing results...");
        }
        ((UT2004HideAndSeekConfig)this.config).getHsConfig().setFixedSeekerName(this.origFixedSeekerName);
        UT2004HideAndSeekResult result = new UT2004HideAndSeekResult();
        result.setBots(MyCollections.asList(bots.botId2UnrealId.keySet()));
        result.setBotIds(bots.botId2UnrealId);
        for (Map.Entry entry : bots.botObservers.entrySet()) {
            if (!(entry.getValue() instanceof UT2004AnalyzerObsStats)) {
                throw new PogamutException("There is an observer of wrong class, expecting UT2004AnalyzerObsStats, got " + ((IUT2004AnalyzerObserver)entry.getValue()).getClass().getSimpleName() + "!", (Logger)this.log, (Object)this);
            }
            result.getBotObservers().put((IToken)entry.getKey(), (UT2004AnalyzerObsStats)entry.getValue());
        }
        result.setWinners(winners);
        result.setMatchTime(((double)bots.matchEnd - (double)bots.matchStart) / 1000.0);
        result.setScoreDetails(botRecords);
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": Results processed, #Winners = " + result.getWinners().size() + ", Winners score = " + result.getWinnerScore());
        }
        return result;
    }

    protected void outputResults_step1(UT2004HideAndSeekResult result, File outputDirectory) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": Outputting match result into CSV file...");
        }
        File file = new File(outputDirectory.getAbsolutePath() + File.separator + "match-" + ((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + "-result.csv");
        FilePath.makeDirsToFile((File)file);
        try {
            Formatter writer = new Formatter(file);
            writer.format("MatchId;WinnerScore;MatchTimeSecs;" + ((UT2004HideAndSeekConfig)this.config).getHsConfig().getCSVHeader() + "", new Object[0]);
            for (int i = 0; i < result.getWinners().size(); ++i) {
                writer.format(";Winner" + (i + 1), new Object[0]);
            }
            writer.format("\n", new Object[0]);
            writer.format("%s;%d;%.3f;", ((UT2004HideAndSeekConfig)this.config).getMatchId().getToken(), result.getWinnerScore(), result.getMatchTime());
            ((UT2004HideAndSeekConfig)this.config).getHsConfig().formatCSVLine(writer);
            for (IToken winner : result.getWinners()) {
                writer.format(";%s", winner.getToken());
            }
            try {
                writer.close();
            }
            catch (Exception e) {}
        }
        catch (IOException e) {
            throw new PogamutIOException("Failed to write results!", (Throwable)e, (Logger)this.log, (Object)this);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": Match result output into " + file.getAbsolutePath() + ".");
        }
    }

    protected void outputResults_step2(UT2004HideAndSeekResult result, File outputDirectory) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": Outputting match scores into CSV file...");
        }
        File file = new File(outputDirectory.getAbsolutePath() + File.separator + "match-" + ((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + "-bot-scores.csv");
        FilePath.makeDirsToFile((File)file);
        try {
            Formatter writer = new Formatter(file);
            ArrayList<IToken> bots = new ArrayList<IToken>(result.getBots());
            Collections.sort(bots, new Comparator<IToken>(){

                @Override
                public int compare(IToken o1, IToken o2) {
                    return o1.getToken().compareTo(o2.getToken());
                }
            });
            writer.format("BotId;SeekerCount;RunnerCount;Score", new Object[0]);
            writer.format(";RunnerCapturedBySeekerScore;RunnerSpottedBySeekerScore;RunnerSafeScore;RunnerSurvivedScore;RunnerFoulScore", new Object[0]);
            writer.format(";SeekerCapturedRunnerScore;SeekerSpottedRunnerScore;SeekerLetRunnerSurviveScore;SeekerLetRunnerEscapeScore", new Object[0]);
            for (IToken token : bots) {
                writer.format(";ThisRunnerCapturedBySeeker_" + token.getToken() + "_Count", new Object[0]);
                writer.format(";ThisRunnerSpottedBySeeker_" + token.getToken() + "_Count", new Object[0]);
                writer.format(";ThisRunnerSafeCountWhileSeeker_" + token.getToken() + "_Count", new Object[0]);
                writer.format(";ThisRunnerSurvivedWhileSeeker_" + token.getToken() + "_Count", new Object[0]);
                writer.format(";ThisRunnerFoulWhileSeeker_" + token.getToken() + "_Count", new Object[0]);
                writer.format(";ThisSeekerCapturedRunner_" + token.getToken() + "_Count", new Object[0]);
                writer.format(";ThisSeekerSpottedRunner_" + token.getToken() + "_Count", new Object[0]);
                writer.format(";ThisSeekerLetRunner_" + token.getToken() + "_SurviveCount", new Object[0]);
                writer.format(";ThisSeekerLetRunner_" + token.getToken() + "_EscapeCount", new Object[0]);
            }
            for (IToken token1 : bots) {
                writer.format("\n", new Object[0]);
                writer.format(token1.getToken(), new Object[0]);
                HSBotRecord<PlayerMessage> record = result.getScoreDetails().get(token1);
                writer.format(";%d", record.getSeekerCount());
                writer.format(";%d", record.getRunnerCount());
                writer.format(";%d", record.getScore());
                writer.format(";%d", record.getRunnerCapturedBySeekerScore());
                writer.format(";%d", record.getRunnerSpottedBySeekerScore());
                writer.format(";%d", record.getRunnerSafeScore());
                writer.format(";%d", record.getRunnerSurvivedScore());
                writer.format(";%d", record.getRunnerFoulScore());
                writer.format(";%d", record.getSeekerCapturedRunnerScore());
                writer.format(";%d", record.getSeekerSpottedRunnerScore());
                writer.format(";%d", record.getSeekerLetRunnerSurviveScore());
                writer.format(";%d", record.getSeekerLetRunnerEscapeScore());
                for (IToken token2 : bots) {
                    UnrealId bot2Id = result.getBotIds().get(token2);
                    writer.format(";%d", record.getRunnerCapturedBySeekerCount().get(bot2Id));
                    writer.format(";%d", record.getRunnerSpottedBySeekerCount().get(bot2Id));
                    writer.format(";%d", record.getRunnerSafeCount().get(bot2Id));
                    writer.format(";%d", record.getRunnerSurvivedCount().get(bot2Id));
                    writer.format(";%d", record.getRunnerFoulCount().get(bot2Id));
                    writer.format(";%d", record.getSeekerCapturedRunnerCount().get(bot2Id));
                    writer.format(";%d", record.getSeekerSpottedRunnerCount().get(bot2Id));
                    writer.format(";%d", record.getSeekerLetRunnerSurviveCount().get(bot2Id));
                    writer.format(";%d", record.getSeekerLetRunnerEscapeCount().get(bot2Id));
                }
            }
            try {
                writer.close();
            }
            catch (Exception e) {}
        }
        catch (IOException e) {
            throw new PogamutIOException("Failed to write results!", (Throwable)e, (Logger)this.log, (Object)this);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": Match scores output into " + file.getAbsolutePath() + ".");
        }
    }

    protected void outputResults(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots, UT2004MatchResult result, File outputDirectory) {
        if (!(result instanceof UT2004HideAndSeekResult)) {
            throw new PogamutException("Can't out results! Expected results of class UT2004HideAndSeekResult and got " + result.getClass().getSimpleName() + "!", (Logger)this.log, (Object)this);
        }
        this.outputResults_step1((UT2004HideAndSeekResult)result, outputDirectory);
        this.outputResults_step2((UT2004HideAndSeekResult)result, outputDirectory);
    }

    protected UT2004Server startControlServer(UCCWrapper ucc) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": Starting UT2004Server...");
        }
        NullCheck.check((Object)ucc, (String)"ucc");
        UT2004HSServerModule module = new UT2004HSServerModule();
        UT2004ServerFactory factory = new UT2004ServerFactory((UT2004ServerModule)module);
        UT2004Server server = (UT2004Server)factory.newAgent((IAgentParameters)new UT2004AgentParameters().setAgentId((IAgentId)new AgentId(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + "-UT2004Server")).setWorldAddress((IWorldConnectionAddress)ucc.getServerAddress()));
        server.start();
        if (!server.inState(new Class[]{IAgentStateRunning.class})) {
            throw new PogamutException("Failed to start UT2004HSServer!", (Logger)this.log, (Object)this);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": UT2004Server started.");
        }
        return server;
    }

    protected void matchIsAboutToBegin(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots) {
        super.matchIsAboutToBegin(ucc, server, analyzer, bots);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            throw new PogamutInterruptedException((Throwable)e, (Object)this);
        }
        if (((UT2004HideAndSeekConfig)this.config).getHsConfig().isFixedSeeker()) {
            String fixedSeekerString = ((UT2004HideAndSeekConfig)this.config).getHsConfig().getFixedSeekerName();
            Token fixedSeekerToken = Tokens.get((String)fixedSeekerString);
            if (!bots.botObservers.containsKey(fixedSeekerToken)) {
                throw new RuntimeException("Failed to find '" + fixedSeekerString + "' as token " + fixedSeekerToken + " within observer tokens, cannot ensure FIXED SEEKER settings.");
            }
            UT2004AnalyzerFullObserver observer = (UT2004AnalyzerFullObserver)bots.botObservers.get(fixedSeekerToken);
            if (observer == null) {
                throw new PogamutException("Failed to find '" + fixedSeekerString + "' as token " + fixedSeekerToken + " within observer map, cannot ensure FIXED SEEKER settings.", (Logger)this.log, (Object)this);
            }
            Self fixedSeekerSelf = observer.getBotSelf();
            if (fixedSeekerSelf == null) {
                throw new PogamutException("Failed to obtain fixed seeker '" + fixedSeekerString + "' SELF from the observer, cannot ensure FIXED SEEKER settings.", (Logger)this.log, (Object)this);
            }
            String fixedSeekerTrueName = fixedSeekerSelf.getName();
            if (fixedSeekerTrueName == null) {
                throw new PogamutException("Failed to obtain true name of the fixed seeker '" + fixedSeekerString + "' SELF.getName() is null, cannot ensure FIXED SEEKER settings.", (Logger)this.log, (Object)this);
            }
            if (fixedSeekerTrueName.contains("[")) {
                fixedSeekerTrueName = fixedSeekerTrueName.substring(0, fixedSeekerTrueName.indexOf("[")).trim();
            }
            if (fixedSeekerTrueName.isEmpty()) {
                throw new PogamutException("Failed to obtain true name of the fixed seeker '" + fixedSeekerString + "', true name cannot be enclosed by [] brackets!", (Logger)this.log, (Object)this);
            }
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Fixed seeker '" + fixedSeekerString + "' true bot name is '" + fixedSeekerTrueName + "', configuring fixed seeker for this name.");
            }
            this.origFixedSeekerName = ((UT2004HideAndSeekConfig)this.config).getHsConfig().getFixedSeekerName();
            ((UT2004HideAndSeekConfig)this.config).getHsConfig().setFixedSeekerName(fixedSeekerTrueName);
            int fixedSeekerTrueNameCount = 0;
            for (UT2004AnalyzerFullObserver obs : bots.botObservers.values()) {
                Self self = obs.getBotSelf();
                if (self == null) {
                    throw new PogamutException("One bot observer does not contain SELF, cannot ensure FIXED SEEKER settings.", (Logger)this.log, (Object)this);
                }
                if (self.getName() == null) {
                    throw new PogamutException("One bot observer has SELF.getName() == NULL, cannot ensure FIXED SEEKER settings.", (Logger)this.log, (Object)this);
                }
                if (!self.getName().startsWith(fixedSeekerTrueName)) continue;
                ++fixedSeekerTrueNameCount;
            }
            if (fixedSeekerTrueNameCount != 1) {
                throw new PogamutException("There are INVALID number of bots that has name prefixed with seeker name '" + fixedSeekerTrueName + ": " + fixedSeekerTrueNameCount + ". Cannot ensure FIXED SEEKER settings.", (Logger)this.log, (Object)this);
            }
        }
        ((UT2004HideAndSeekConfig)this.config).getHsConfig().setObserverPort(ucc.getObserverPort());
        UT2004HSServer hsServer = (UT2004HSServer)server;
        hsServer.startGame(((UT2004HideAndSeekConfig)this.config).getHsConfig());
    }

    public UT2004HideAndSeekResult execute() {
        try {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": Executing!");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        UCCWrapper ucc = null;
        UT2004Server server = null;
        UT2004Match.Bots bots = null;
        UT2004Analyzer analyzer = null;
        String recordFileName = ((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + "-replay-" + UT2004Match.getCurrentDate();
        boolean exception = false;
        try {
            this.setupLogger();
            this.validate();
            this.createUT2004Ini();
            this.createGB2004Ini();
            ucc = this.startUCC();
            server = this.startControlServer(ucc);
            bots = this.startBots(ucc, server);
            analyzer = this.startAnalyzer(ucc, bots, this.getOutputPath("bots"), ((UT2004HideAndSeekConfig)this.config).isHumanLikeLogEnabled());
            this.restartMatch(server, bots);
            this.recordReplay(server, recordFileName);
            this.matchIsAboutToBegin(ucc, server, analyzer, bots);
            UT2004HideAndSeekResult result = (UT2004HideAndSeekResult)this.waitMatchFinish(ucc, server, analyzer, bots, 0L);
            this.copyReplay(ucc, recordFileName, this.getOutputPath());
            this.outputResults(ucc, server, analyzer, bots, result, this.getOutputPath());
            this.shutdownAll(ucc, server, analyzer, bots);
            ucc = null;
            server = null;
            analyzer = null;
            bots = null;
            UT2004HideAndSeekResult uT2004HideAndSeekResult = result;
            return uT2004HideAndSeekResult;
        }
        catch (Exception e) {
            if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(ExceptionToString.process((String)(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": EXCEPTION!"), (Throwable)e));
            }
            exception = true;
            if (e instanceof PogamutException) {
                throw (PogamutException)e;
            }
            throw new PogamutException((Throwable)e, (Logger)this.log, (Object)this);
        }
        finally {
            try {
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": Cleaning up...");
                }
            }
            catch (Exception e) {}
            if (ucc != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": Killing UCC...");
                    }
                }
                catch (Exception e) {}
                try {
                    ucc.stop();
                }
                catch (Exception e) {}
            }
            if (server != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": Killing UT2004Server...");
                    }
                }
                catch (Exception e) {}
                try {
                    server.kill();
                }
                catch (Exception e) {}
            }
            if (bots != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": Killing Custom bots...");
                    }
                }
                catch (Exception e) {}
                for (UT2004BotExecution exec : bots.bots.values()) {
                    try {
                        exec.stop();
                    }
                    catch (Exception e) {}
                }
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": Killing Custom bot observers...");
                    }
                }
                catch (Exception e) {}
                for (IUT2004AnalyzerObserver obs : bots.botObservers.values()) {
                    try {
                        obs.kill();
                    }
                    catch (Exception e) {}
                }
                if (analyzer != null) {
                    // empty if block
                }
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": Killing UT2004Analyzer...");
                    }
                }
                catch (Exception e) {}
                try {
                    analyzer.kill();
                }
                catch (Exception e) {}
            }
            try {
                this.restoreUT2004IniBackup();
            }
            catch (Exception e) {}
            try {
                this.restoreGB2004IniBackup();
            }
            catch (Exception e) {}
            try {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    if (exception) {
                        this.log.warning(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": Cleaned up, MATCH FAILED!");
                    } else {
                        this.log.warning(((UT2004HideAndSeekConfig)this.config).getMatchId().getToken() + ": Cleaned up, match finished successfully.");
                    }
                }
            }
            catch (Exception e) {}
            try {
                this.closeLogger();
            }
            catch (Exception e) {}
        }
    }
}

