package cz.cuni.amis.pogamut.ut3.agent.module.sensor;

import java.util.logging.Logger;

import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Items;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.*;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;

public class UT3Items extends Items {	
	
	public UT3Items(UT2004Bot bot, AgentInfo agentInfo, Game game,
			Weaponry weaponry, Logger log) {
		super(bot, agentInfo, game, weaponry, log);
	}

	public boolean isPickable(Item item) {
    	// health
        ItemType itemType = item.getType();
            
    	if ( itemType == UT3ItemType.MEDIUM_HEALTH && agentInfo.isHealthy() ) {
    		return false;
    	}
    	if ( itemType == UT3ItemType.SUPER_HEALTH_PACK && agentInfo.isSuperHealthy() ) {
    		return false;
    	}
    	if ( itemType == UT3ItemType.HEALTH_VIAL && agentInfo.isSuperHealthy() ) {
    		return false;
    	}
    	
    	//TODO - armor!
    	/*if ( itemType == UT3ItemType.ARMOR_HELMET && agentInfo.hasHighArmor() ) {
    		return false;
    	}*/

    	
    	// weapons
    	if ( itemType.getCategory() == UT3ItemType.Category.WEAPON ) {
    		if ( game.getGameInfo().isWeaponStay() ) {
    			return !weaponry.hasWeapon(itemType);
    		} else {
                    
    			/*return weaponry.getPrimaryWeaponAmmo( itemType ) < weaponry.getWeaponDescriptor( itemType ).getPriMaxAmount()
    				   ||
    				   weaponry.getSecondaryWeaponAmmo( itemType ) < weaponry.getWeaponDescriptor( item.getType() ).getSecMaxAmount();*/
    		}
    	}
    	
    	//TODO - ammo
    	/*if ( itemType.getCategory() == UT3ItemType.Category.AMMO && weaponry.getAmmo(itemType) >= weaponry.getMaxAmmo(itemType) ) {
    		return false;
    	}*/
    	
    	
    	// ultra damage
    	if ( itemType == UT3ItemType.U_DAMAGE_PACK && agentInfo.hasUDamage() ) {
    		return false;
    	}

    	return true;
	}
	/**
	 * Returns how fast are the items respawning based on their item type (in real seconds according to {@link System#currentTimeMillis()}.
	 * @param UT3ItemType
	 * @return
	 */
	public double getItemRespawnTime(ItemType ut3ItemType) {
		if (ut3ItemType.equals(UT3ItemType.U_DAMAGE_PACK) || ut3ItemType.equals(UT3ItemType.REDEEMER)) {
			return 3 * 28.5;
		} else
		if (ut3ItemType.equals(UT3ItemType.SUPER_HEALTH_PACK) || ut3ItemType.equals(UT3ItemType.ARMOR_SHIELD_BELT)) {
			return 2 * 28.5;
		} else {
			return 28.5;
		}
	}
	
	

	
}