/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut3.communication.messages.gbinfomessages;

import cz.cuni.amis.pogamut.multi.communication.worldview.object.ICompositeWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;
import cz.cuni.amis.pogamut.ut3.communication.messages.gbinfomessages.AliveMessage;
import cz.cuni.amis.pogamut.ut3.communication.messages.gbinfomessages.AliveMessageCompositeImpl;
import cz.cuni.amis.pogamut.ut3.communication.messages.gbinfomessages.AliveMessageLocal;
import cz.cuni.amis.pogamut.ut3.communication.messages.gbinfomessages.AliveMessageLocalImpl;
import cz.cuni.amis.pogamut.ut3.communication.messages.gbinfomessages.AliveMessageSharedImpl;
import cz.cuni.amis.pogamut.ut3.communication.messages.gbinfomessages.AliveMessageStatic;
import cz.cuni.amis.pogamut.ut3.communication.messages.gbinfomessages.AliveMessageStaticImpl;
import cz.cuni.amis.pogamut.ut3.communication.messages.gbinfomessages.Empty;
import cz.cuni.amis.pogamut.ut3.communication.messages.gbinfomessages.EmptyCompositeImpl;
import cz.cuni.amis.pogamut.ut3.communication.messages.gbinfomessages.EmptyLocal;
import cz.cuni.amis.pogamut.ut3.communication.messages.gbinfomessages.EmptyLocalImpl;
import cz.cuni.amis.pogamut.ut3.communication.messages.gbinfomessages.EmptySharedImpl;
import cz.cuni.amis.pogamut.ut3.communication.messages.gbinfomessages.EmptyStatic;
import cz.cuni.amis.pogamut.ut3.communication.messages.gbinfomessages.EmptyStaticImpl;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.HashMap;
import java.util.Map;

public class UT2004CompositeObjectCreator {
    private static Map<Class, ICompositeWorldObjectCreator> creators = new HashMap<Class, ICompositeWorldObjectCreator>();

    public static ICompositeWorldObject createObject(ILocalWorldObject localPart, ISharedWorldObject sharedPart, IStaticWorldObject staticPart) {
        NullCheck.check((Object)localPart, (String)"localPart");
        NullCheck.check((Object)sharedPart, (String)"sharedPart");
        NullCheck.check((Object)staticPart, (String)"staticPart");
        NullCheck.check((Object)localPart.getCompositeClass(), (String)"localPart.getCompositeClass()");
        NullCheck.check((Object)sharedPart.getCompositeClass(), (String)"sharedPart.getCompositeClass()");
        NullCheck.check((Object)staticPart.getCompositeClass(), (String)"staticPart.getCompositeClass()");
        if (localPart.getCompositeClass() != sharedPart.getCompositeClass() || sharedPart.getCompositeClass() != staticPart.getCompositeClass()) {
            throw new PogamutException("CompositeObject cannot be created, because the objectParts belong to different compositeObject classes : " + localPart.getCompositeClass() + "," + sharedPart.getCompositeClass() + "," + staticPart.getCompositeClass(), (Object)localPart);
        }
        ICompositeWorldObjectCreator creator = creators.get(localPart.getCompositeClass());
        if (creator == null) {
            throw new PogamutException("There is no ICompositeWorldObjectCreator registered for class " + localPart.getCompositeClass(), UT2004CompositeObjectCreator.class);
        }
        return creator.create(localPart, sharedPart, staticPart);
    }

    static {
        creators.put(Empty.class, new EmptyCreator());
        creators.put(AliveMessage.class, new AliveMessageCreator());
    }

    public static class AliveMessageCreator
    implements ICompositeWorldObjectCreator<AliveMessage> {
        @Override
        public AliveMessage create(ILocalWorldObject localPart, ISharedWorldObject sharedPart, IStaticWorldObject staticPart) {
            return new AliveMessageCompositeImpl(new AliveMessageLocalImpl((AliveMessageLocal)localPart), new AliveMessageSharedImpl(sharedPart.getId(), sharedPart.getProperties().values()), new AliveMessageStaticImpl((AliveMessageStatic)staticPart));
        }
    }

    public static class EmptyCreator
    implements ICompositeWorldObjectCreator<Empty> {
        @Override
        public Empty create(ILocalWorldObject localPart, ISharedWorldObject sharedPart, IStaticWorldObject staticPart) {
            return new EmptyCompositeImpl(new EmptyLocalImpl((EmptyLocal)localPart), new EmptySharedImpl(sharedPart.getId(), sharedPart.getProperties().values()), new EmptyStaticImpl((EmptyStatic)staticPart));
        }
    }

    public static interface ICompositeWorldObjectCreator<T extends ICompositeWorldObject> {
        public T create(ILocalWorldObject var1, ISharedWorldObject var2, IStaticWorldObject var3);
    }
}

