/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.messages.custom;

import cz.cuni.amis.pogamut.ut2004.communication.messages.custom.ControlMessageMapper;
import cz.cuni.amis.pogamut.ut2004.communication.messages.custom.ControlMessageType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.custom.ICustomControlMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.custom.SendControlMessageMapper;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendControlMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ControlMessage;
import java.util.HashMap;
import java.util.Map;

public class ControlMessages {
    protected Map<String, ControlMessageMapper> deserializers = new HashMap<String, ControlMessageMapper>();
    protected Map<String, SendControlMessageMapper> serializers = new HashMap<String, SendControlMessageMapper>();

    protected void register(Class<? extends ICustomControlMessage> ... customControlMessageClasses) {
        Class<? extends ICustomControlMessage>[] classArray = customControlMessageClasses;
        int n = customControlMessageClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends ICustomControlMessage> customControlMessageClass = classArray[n2];
            ControlMessageMapper<? extends ICustomControlMessage> deserializer = new ControlMessageMapper<ICustomControlMessage>(customControlMessageClass);
            if (this.deserializers.containsKey(deserializer.getType())) {
                throw new RuntimeException("Cannot register same message type '" + deserializer.getType() + " twice. Following two classes have the same @ControlMessageType value: " + customControlMessageClass + ", " + this.deserializers.get(deserializer.getType()).getDescriptor());
            }
            this.deserializers.put(deserializer.getType(), deserializer);
            SendControlMessageMapper serializer = new SendControlMessageMapper(customControlMessageClass);
            if (this.serializers.containsKey(serializer.getType())) {
                throw new RuntimeException("Cannot register same message type '" + deserializer.getType() + " twice. Following two classes have the same @ControlMessageType value: " + customControlMessageClass + ", " + this.serializers.get(serializer.getType()).getDescriptor());
            }
            this.serializers.put(serializer.getType(), serializer);
            ++n2;
        }
    }

    public ICustomControlMessage read(ControlMessage message) {
        ControlMessageMapper deserializer = this.deserializers.get(message.getType());
        if (deserializer == null) {
            throw new RuntimeException("Cannot deserialize " + (Object)((Object)message) + ", no deserializer registered for the message type '" + message.getType() + "'.");
        }
        return deserializer.deserialize(message);
    }

    public SendControlMessage write(ICustomControlMessage message) {
        if (!message.getClass().isAnnotationPresent(ControlMessageType.class)) {
            throw new RuntimeException("Cannot map object of class " + message.getClass() + " onto SendControlMessage as there is no @ControlMessageType annotation present.");
        }
        String type = message.getClass().getAnnotation(ControlMessageType.class).type();
        SendControlMessageMapper serializer = this.serializers.get(type);
        if (serializer == null) {
            throw new RuntimeException("Cannot serialize " + message + ", no serializer registered for the message type '" + type + "'.");
        }
        SendControlMessage command = serializer.serialize(message);
        return command;
    }
}

