/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathfollowing;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavPoints;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.AbstractUT2004PathNavigator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathRunner;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Mover;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NavMeshNavigator<PATH_ELEMENT extends ILocated>
extends AbstractUT2004PathNavigator<PATH_ELEMENT> {
    private Location navigDestination = null;
    private Stage navigStage = Stage.COMPLETED;
    private ILocated focus = null;
    private SelfListener selfListener;
    public static final int CLOSE_ENOUGH = 40;
    private Iterator<PATH_ELEMENT> navigIterator = null;
    private int navigNextLocationOffset = 0;
    private Location navigLastLocation = null;
    private NavPoint navigLastNode = null;
    private Location navigCurrentLocation = null;
    private NavPoint navigCurrentNode = null;
    private NavPointNeighbourLink navigCurrentLink = null;
    private Location navigNextLocation = null;
    private NavPoint navigNextNode = null;
    private int navigMoverRideUpCount;
    private int navigMoverRideDownCount;
    private Boolean navigMoverIsRidingUp;
    private Boolean navigMoverIsRidingDown;
    private Boolean navigMoverGettingBackRunnerReset;
    private Boolean navigMoverGettingToLiftCenterRunnerReset;
    private IUT2004PathRunner runner;
    protected UT2004Bot main;
    protected AgentInfo memory;
    protected AdvancedLocomotion body;
    protected Logger log;

    @Override
    protected void navigate(ILocated focus, int pathElementIndex) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Navigator.navigate(): Current stage {0}", (Object)this.navigStage);
        }
        this.focus = focus;
        this.navigStage = this.keepNavigating();
        switch (this.navigStage) {
            case AWAITING_MOVER: 
            case RIDING_MOVER: {
                this.setBotWaiting(true);
                break;
            }
            case REACHING: 
            case NAVIGATING: 
            case TELEPORT: {
                this.setBotWaiting(false);
                break;
            }
            case CANCELED: 
            case TIMEOUT: 
            case CRASHED: {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.log(Level.WARNING, "Navigation {0}", (Object)this.navigStage);
                }
                this.executor.stuck();
                return;
            }
            case COMPLETED: {
                this.executor.targetReached();
            }
        }
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Navigator.navigate(): Next stage {0}", (Object)this.navigStage);
        }
    }

    @Override
    public void reset() {
        this.navigCurrentLocation = null;
        this.navigCurrentNode = null;
        this.navigCurrentLink = null;
        this.navigDestination = null;
        this.navigIterator = null;
        this.navigLastLocation = null;
        this.navigLastNode = null;
        this.navigNextLocation = null;
        this.navigNextNode = null;
        this.navigNextLocationOffset = 0;
        this.navigStage = Stage.COMPLETED;
        this.setBotWaiting(false);
        this.resetNavigMoverVariables();
    }

    @Override
    public void newPath(List<PATH_ELEMENT> path, ILocated focus) {
        this.reset();
        Location dest = ((ILocated)path.get(path.size() - 1)).getLocation();
        this.initPathNavigation(dest, path, focus);
        this.navigate(focus);
    }

    @Override
    public void pathExtended(List<PATH_ELEMENT> path, int currentPathIndex) {
        if (path == null || path.isEmpty()) {
            throw new RuntimeException("path is null or 0-sized!");
        }
        this.navigDestination = ((ILocated)path.get(path.size() - 1)).getLocation();
        this.navigIterator = path.iterator();
        int newOffset = -currentPathIndex;
        int i = 0;
        while (i < path.size() && i < currentPathIndex + this.navigNextLocationOffset && this.navigIterator.hasNext()) {
            ++newOffset;
            this.navigIterator.next();
            ++i;
        }
        this.log.fine("PATH EXTEND ... curr index " + currentPathIndex + ", old offset " + this.navigNextLocationOffset + ", new offset " + newOffset + ", path size " + path.size());
        this.navigNextLocationOffset = newOffset;
    }

    @Override
    public NavPointNeighbourLink getCurrentLink() {
        return this.navigCurrentLink;
    }

    protected void initDirectNavigation(Location dest) {
        int distance = (int)this.memory.getLocation().getDistance(dest);
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Navigator.initDirectNavigation(): initializing direct navigation, distance {0}", distance);
        }
        this.initDirectly(dest);
    }

    protected void initPathNavigation(Location dest, List<PATH_ELEMENT> path, ILocated focus) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Navigator.initPathNavigation(): initializing path navigation, nodes {0}", path.size());
        }
        if (!this.initAlongPath(dest, path)) {
            this.initDirectNavigation(dest);
        }
    }

    protected Stage keepNavigating() {
        if (this.navigStage.terminated) {
            return this.navigStage;
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            if (this.navigLastNode != null) {
                this.log.fine("Navigator.keepNavigating(): From " + NavPoints.describe(this.navigLastNode));
            } else if (this.navigLastLocation != null) {
                this.log.fine("Navigator.keepNavigating(): From " + this.navigLastLocation);
            }
            if (this.navigCurrentNode != null) {
                this.log.fine("Navigator.keepNavigating(): To   " + NavPoints.describe(this.navigCurrentNode));
            } else if (this.navigCurrentLocation != null) {
                this.log.fine("Navigator.keepNavigating(): To   " + this.navigCurrentLocation);
            }
        }
        switch (this.navigStage) {
            case REACHING: {
                this.navigStage = this.navigDirectly();
                break;
            }
            default: {
                this.navigStage = this.navigAlongPath();
            }
        }
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Navigator.keepNavigating(): In stage " + (Object)((Object)this.navigStage));
        }
        return this.navigStage;
    }

    private Stage initDirectly(Location dest) {
        this.navigDestination = dest;
        this.runner.reset();
        this.navigStage = Stage.REACHING;
        return this.navigStage;
    }

    private Stage navigDirectly() {
        int distance = (int)this.memory.getLocation().getDistance(this.navigDestination);
        if (distance <= 40) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Navigator.navigDirectly(): destination close enough: " + distance);
            }
            return Stage.COMPLETED;
        }
        if (!this.runner.runToLocation(this.navigLastLocation, this.navigDestination, null, (ILocated)(this.focus == null ? this.navigDestination : this.focus), null, true, false)) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Navigator.navigDirectly(): direct navigation failed");
            }
            return Stage.CRASHED;
        }
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.finer("Navigator.navigDirectly(): traveling directly, distance = " + distance);
        }
        return this.navigStage;
    }

    private boolean initAlongPath(Location dest, List<PATH_ELEMENT> path) {
        this.navigDestination = dest;
        this.navigIterator = path.iterator();
        this.navigCurrentLocation = this.bot.getLocation();
        this.navigCurrentNode = (NavPoint)DistanceUtils.getNearest(this.bot.getWorldView().getAll(NavPoint.class).values(), (ILocated)this.bot.getLocation(), (double)40.0);
        this.prepareNextNode();
        this.navigStage = Stage.NAVIGATING;
        return this.switchToNextNode();
    }

    private Stage navigAlongPath() {
        int totalDistance = (int)this.memory.getLocation().getDistance(this.navigDestination);
        if (totalDistance <= 40) {
            this.log.log(Level.FINEST, "Navigator.navigAlongPath(): destination close enough: {0}", totalDistance);
            return Stage.COMPLETED;
        }
        if (this.navigStage.mover) {
            this.log.fine("Navigator.navigAlongPath(): MOVER");
            return this.navigMover();
        }
        if (this.navigStage.teleport) {
            this.log.fine("Navigator.navigAlongPath(): TELEPORT");
            return this.navigThroughTeleport();
        }
        this.log.fine("Navigator.navigAlongPath(): STANDARD");
        return this.navigToCurrentNode(true, false);
    }

    private void prepareNextNode() {
        if (this.navigCurrentNode != null && this.navigCurrentNode.isTeleporter()) {
            this.prepareNextNodeTeleporter();
            return;
        }
        ILocated located = null;
        this.navigNextLocation = null;
        this.navigNextNode = null;
        this.navigNextLocationOffset = 0;
        while (located == null && this.navigIterator.hasNext()) {
            located = (ILocated)this.navigIterator.next();
            ++this.navigNextLocationOffset;
        }
        if (located == null) {
            this.navigNextLocationOffset = 0;
            return;
        }
        if (this.executor.getPathElementIndex() + this.navigNextLocationOffset >= this.executor.getPath().size()) {
            this.navigNextLocationOffset = 0;
        }
        this.navigNextLocation = located.getLocation();
        this.navigNextNode = this.getNavPoint(located);
    }

    private void prepareNextNodeTeleporter() {
        ILocated located = null;
        this.navigNextLocation = null;
        this.navigNextLocationOffset = 0;
        boolean nextTeleporterFound = false;
        while (located == null && this.navigIterator.hasNext()) {
            located = (ILocated)this.navigIterator.next();
            ++this.navigNextLocationOffset;
            if (located == null) continue;
            this.navigNextNode = this.getNavPoint(located);
            if (this.navigNextNode == null || !this.navigNextNode.isTeleporter()) break;
            if (!nextTeleporterFound) {
                located = null;
            }
            nextTeleporterFound = true;
        }
        if (located == null) {
            this.navigNextLocationOffset = 0;
            return;
        }
        if (this.executor.getPathElementIndex() + this.navigNextLocationOffset >= this.executor.getPath().size()) {
            this.navigNextLocationOffset = 0;
        }
        this.navigNextLocation = located.getLocation();
        this.navigNextNode = this.getNavPoint(located);
    }

    private boolean switchToNextNode() {
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("Navigator.switchToNextNode(): switching!");
        }
        this.navigLastLocation = this.navigCurrentLocation;
        this.navigLastNode = this.navigCurrentNode;
        this.navigCurrentLocation = this.navigNextLocation;
        if (this.navigCurrentLocation == null) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("Navigator.switchToNextNode(): no nodes left");
            }
            this.navigCurrentNode = null;
            return false;
        }
        this.navigCurrentNode = this.navigNextNode;
        this.navigCurrentLink = this.getNavPointsLink(this.navigLastNode, this.navigCurrentNode);
        if (this.navigCurrentLink == null) {
            this.getNavPointsLink(this.navigLastNode, this.navigCurrentNode);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("No link information...");
            }
        }
        if (this.navigLastLocation == null) {
            this.navigLastLocation = this.bot.getLocation();
            this.navigLastNode = this.navigCurrentNode;
        }
        int localDistance = (int)this.memory.getLocation().getDistance(this.navigCurrentLocation.getLocation());
        if (this.navigCurrentNode != null && this.navigCurrentNode.isTeleporter()) {
            this.navigStage = Stage.TeleporterStage();
        } else if (this.navigCurrentNode != null && this.navigCurrentNode.isLiftCenter()) {
            this.navigStage = Stage.FirstMoverStage();
            this.resetNavigMoverVariables();
        } else if (this.navigStage.mover) {
            this.navigStage = this.navigStage.next();
            this.runner.reset();
        } else if (this.navigStage.teleport) {
            this.navigStage = this.navigStage.next();
            this.runner.reset();
        } else {
            this.runner.reset();
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            if (this.navigCurrentNode != null) {
                this.log.fine("Navigator.switchToNextNode(): switch to next node " + this.navigCurrentNode.getId().getStringId() + ", distance " + localDistance + ", reachable true" + ", mover " + this.navigStage.mover);
            } else {
                this.log.log(Level.FINE, "Navigator.switchToNextNode(): switch to next location {0}, distance {1}, mover {2}", new Object[]{this.navigCurrentLocation, localDistance, this.navigStage.mover});
            }
        }
        if (this.executor.getPathElementIndex() < 0) {
            this.executor.switchToAnotherPathElement(0);
        } else if (this.navigNextLocationOffset > 0) {
            this.executor.switchToAnotherPathElement(this.executor.getPathElementIndex() + this.navigNextLocationOffset);
        } else {
            this.executor.switchToAnotherPathElement(this.executor.getPathElementIndex());
        }
        this.navigNextLocationOffset = 0;
        this.prepareNextNode();
        if (localDistance < 20) {
            this.log.log(Level.FINER, "Navigator.switchToNextNode(): next location too near, switching again!");
            return this.switchToNextNode();
        }
        return true;
    }

    private void resetNavigMoverVariables() {
        this.navigMoverIsRidingUp = null;
        this.navigMoverIsRidingDown = null;
        this.navigMoverRideUpCount = 0;
        this.navigMoverRideDownCount = 0;
        this.navigMoverGettingBackRunnerReset = false;
        this.navigMoverGettingToLiftCenterRunnerReset = false;
    }

    private void checkMoverMovement(Mover mover) {
        if (mover.getVelocity().z > 0.0) {
            if (this.navigMoverIsRidingUp == null) {
                this.navigMoverIsRidingUp = true;
                this.navigMoverIsRidingDown = false;
                this.navigMoverRideUpCount = 1;
                this.navigMoverRideDownCount = 0;
                this.log.fine("Navigator.checkMoverMovement(): MOVER RIDING UP (1)");
            } else if (this.navigMoverIsRidingDown.booleanValue()) {
                this.navigMoverIsRidingUp = true;
                this.navigMoverIsRidingDown = false;
                ++this.navigMoverRideUpCount;
                this.log.fine("Navigator.checkMoverMovement(): MOVER RIDING UP (" + this.navigMoverRideUpCount + ")");
            }
        } else if (mover.getVelocity().z < 0.0) {
            if (this.navigMoverIsRidingDown == null) {
                this.navigMoverIsRidingUp = false;
                this.navigMoverIsRidingDown = true;
                this.navigMoverRideUpCount = 0;
                this.navigMoverRideDownCount = 1;
                this.log.fine("Navigator.checkMoverMovement(): MOVER RIDING DOWN (1)");
            } else if (this.navigMoverIsRidingUp.booleanValue()) {
                this.navigMoverIsRidingUp = false;
                this.navigMoverIsRidingDown = true;
                ++this.navigMoverRideDownCount;
                this.log.fine("Navigator.checkMoverMovement(): MOVER RIDING DOWN (" + this.navigMoverRideDownCount + ")");
            }
        }
    }

    private Stage navigMover() {
        Stage stage = this.navigStage;
        if (this.navigCurrentNode == null) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Navigator.navigMover(" + (Object)((Object)stage) + "): can't navigate through the mover without the navpoint instance (navigCurrentNode == null)");
            }
            return Stage.CRASHED;
        }
        Mover mover = (Mover)this.bot.getWorldView().get((WorldObjectId)this.navigCurrentNode.getMover());
        if (mover == null) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Navigator.navigMover(" + (Object)((Object)stage) + "): can't navigate through the mover as current node does not represent a mover (moverId == null): " + this.navigCurrentNode);
            }
            return Stage.CRASHED;
        }
        this.checkMoverMovement(mover);
        this.navigCurrentLocation = this.navigCurrentNode.getLocation();
        if (this.navigNextNode != null) {
            this.navigNextLocation = this.navigNextNode.getLocation();
        }
        this.log.fine("Navigator.navigMover(" + (Object)((Object)stage) + "): SELF " + this.memory.getLocation());
        this.log.fine("Navigator.navigMover(" + (Object)((Object)stage) + "): CURR " + NavPoints.describe(this.navigCurrentNode));
        this.log.fine("Navigator.navigMover(" + (Object)((Object)stage) + "): NEXT " + NavPoints.describe(this.navigNextNode));
        this.log.fine("Navigator.navigMover(" + (Object)((Object)stage) + "):      " + NavPoints.describe(mover));
        int hDistance = (int)this.memory.getLocation().getDistance2D(this.navigCurrentLocation.getLocation());
        int zDistance = (int)this.navigCurrentLocation.getLocation().getDistanceZ(this.memory.getLocation());
        boolean moverRidingUp = mover.getVelocity().z > 0.0;
        boolean moverRidingDown = mover.getVelocity().z < 0.0;
        boolean moverStandingStill = Math.abs(mover.getVelocity().z) < 1.0E-9;
        int moverHDistance = (int)this.memory.getLocation().getDistance2D(mover.getLocation());
        int moverZDistance = (int)mover.getLocation().getDistanceZ(this.memory.getLocation());
        this.log.finer("Navigator.navigMover(" + (Object)((Object)stage) + "): CURR  hDist:" + hDistance + ", zDist:" + zDistance);
        this.log.finer("Navigator.navigMover(" + (Object)((Object)stage) + "): MOVER hDist:" + moverHDistance + ", zDist:" + moverZDistance + ", " + (moverRidingUp ? "riding UP" : (moverRidingDown ? "riding DOWN" : (moverStandingStill ? "standing STILL" : " movement unknown"))));
        if (this.navigStage == Stage.AWAITING_MOVER) {
            boolean waitForTheMover = false;
            if (moverHDistance < 50 && moverZDistance > 100 && moverRidingUp) {
                this.log.fine("Navigator.navigMover(" + (Object)((Object)stage) + "): we are UNDER the mover and it is RIDING UP ... assuming waiting position");
                waitForTheMover = true;
            } else if (moverZDistance > 10) {
                this.log.fine("Navigator.navigMover(" + (Object)((Object)stage) + "): mover is not in correct position ... assuming waiting position");
                waitForTheMover = true;
            } else if (zDistance > 20 && moverRidingUp) {
                this.log.fine("Navigator.navigMover(" + (Object)((Object)stage) + "): mover is riding up, we won't make it to the center ... assuming waiting position");
                waitForTheMover = true;
            }
            if (waitForTheMover) {
                if (this.memory.atLocation((ILocated)this.navigLastLocation, 50.0)) {
                    if (this.navigMoverGettingBackRunnerReset.booleanValue()) {
                        this.navigMoverGettingBackRunnerReset = false;
                        this.runner.reset();
                    }
                    this.body.turnTo((ILocated)this.navigCurrentLocation);
                    return this.navigStage;
                }
                if (!this.navigMoverGettingBackRunnerReset.booleanValue()) {
                    this.runner.reset();
                    this.navigMoverGettingBackRunnerReset = true;
                }
                if (this.run(null, (ILocated)this.navigLastLocation, null, null, (ILocated)this.navigCurrentLocation, true) == NavigateResult.CRASHED) {
                    if (this.log != null && this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Navigator.navigMover(" + (Object)((Object)stage) + "): navigation to wait-for-mover node failed");
                    }
                    return Stage.CRASHED;
                }
                return this.navigStage;
            }
            if (this.navigMoverGettingBackRunnerReset.booleanValue()) {
                this.navigMoverGettingBackRunnerReset = false;
                this.runner.reset();
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("Navigator.navigMover(" + (Object)((Object)stage) + "): mover arrived");
            }
            return this.navigToCurrentNode(false, true);
        }
        if (this.navigMoverGettingBackRunnerReset.booleanValue()) {
            this.navigMoverGettingBackRunnerReset = false;
            this.runner.reset();
        }
        if (this.navigStage == Stage.RIDING_MOVER) {
            if (this.navigMoverRideDownCount > 2 || this.navigMoverRideUpCount > 2) {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): navigation to mover exit node failed, we've rided twice up & down and there was no place suitable to exit the mover in order to get to get to " + this.navigCurrentNode);
                }
                return Stage.CRASHED;
            }
            if (hDistance > 600) {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): navigation to mover exit node failed, the node is too far, hDistance " + hDistance + " > 600, unsupported (weird navigation graph link)");
                }
                return Stage.CRASHED;
            }
            if (Math.abs(zDistance) > 50) {
                this.log.finer("Navigator.navigMover(" + (Object)((Object)stage) + "): riding the mover");
                if (moverHDistance < 35) {
                    this.log.finer("Navigator.navigMover(" + (Object)((Object)stage) + "): at lift-center, looking towards exit");
                    if (this.navigMoverGettingToLiftCenterRunnerReset.booleanValue()) {
                        this.navigMoverGettingToLiftCenterRunnerReset = false;
                        this.runner.reset();
                    }
                    this.body.turnTo((ILocated)this.navigCurrentLocation);
                } else {
                    this.log.finer("Navigator.navigMover(" + (Object)((Object)stage) + "): reaching lift-center, looking towards exit");
                    if (!this.navigMoverGettingToLiftCenterRunnerReset.booleanValue()) {
                        this.navigMoverGettingToLiftCenterRunnerReset = true;
                        this.runner.reset();
                    }
                    if (this.run(null, (ILocated)mover.getLocation(), null, null, (ILocated)this.navigCurrentLocation, true) == NavigateResult.CRASHED) {
                        this.log.fine("Navigator.navigMover(" + (Object)((Object)stage) + "): navigation to last node failed");
                        return Stage.CRASHED;
                    }
                }
                return this.navigStage;
            }
            if (this.navigMoverGettingToLiftCenterRunnerReset.booleanValue()) {
                this.navigMoverGettingToLiftCenterRunnerReset = false;
                this.runner.reset();
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("Navigator.navigMover(" + (Object)((Object)stage) + "): exiting the mover");
            }
            return this.navigToCurrentNode(false, false);
        }
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): invalid stage, neither AWAITING_MOVER nor RIDING MOVER");
        }
        return Stage.CRASHED;
    }

    private Stage navigThroughTeleport() {
        if (this.navigCurrentNode != null) {
            this.navigCurrentLocation = this.navigCurrentNode.getLocation();
        }
        if (this.navigNextNode != null) {
            this.navigNextLocation = this.navigNextNode.getLocation();
        }
        int localDistance2_1 = Integer.MAX_VALUE;
        int localDistance2_2 = Integer.MAX_VALUE;
        for (NavPointNeighbourLink link : this.navigCurrentNode.getOutgoingEdges().values()) {
            if (!link.getToNavPoint().isTeleporter()) continue;
            localDistance2_1 = (int)this.memory.getLocation().getDistance(link.getToNavPoint().getLocation());
            localDistance2_2 = (int)this.memory.getLocation().getDistance(Location.add((Location)link.getToNavPoint().getLocation(), (Location)new Location(0.0, 0.0, 100.0)));
            if (localDistance2_1 >= 200 && localDistance2_2 >= 200) continue;
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Navigator.navigThroughTeleport(): at the other end of teleport, switching...");
            }
            if (!this.switchToNextNode()) {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Navigator.navigThroughTeleport(): switch to direct navigation");
                }
                this.initDirectly(this.navigDestination);
            }
            return this.keepNavigating();
        }
        return this.navigToCurrentNode(true, false);
    }

    private Stage navigToCurrentNode(boolean useFocus, boolean forceNoJump) {
        NavigateResult result = this.run((ILocated)this.navigLastLocation, (ILocated)this.navigCurrentLocation, this.navigCurrentLink, (ILocated)this.navigNextLocation, (ILocated)(useFocus ? this.focus : this.navigCurrentLocation), forceNoJump);
        switch (result) {
            case RUNNING: {
                return this.navigStage;
            }
            case CRASHED: {
                return Stage.CRASHED;
            }
            case REACHED: {
                if (!this.switchToNextNode()) {
                    this.initDirectly(this.navigDestination);
                }
                return this.keepNavigating();
            }
        }
        throw new PogamutException("Unhandled NavigateResult." + (Object)((Object)result), (Object)this);
    }

    private NavigateResult run(ILocated ilocPrevious, ILocated ilocFirst, NavPointNeighbourLink linkFirst, ILocated ilocSecond, ILocated ilocFocus, boolean forceNoJump) {
        Location locSecond;
        NavPoint npFirst = this.getNavPoint(ilocFirst);
        NavPoint npSecond = this.getNavPoint(ilocSecond);
        Location locPrevious = ilocPrevious == null ? null : ilocPrevious.getLocation();
        Location locCurrent = this.memory.getLocation();
        Location locFirst = ilocFirst.getLocation();
        Location location = locSecond = ilocSecond == null ? null : ilocSecond.getLocation();
        if (npFirst != null && (npFirst.isLiftCenter() || npFirst.isTeleporter())) {
            locSecond = null;
            if (npFirst.isLiftCenter()) {
                this.log.fine("Navigator.run(): Reaching LIFT-CENTER");
            }
            if (npFirst.isTeleporter()) {
                this.log.fine("Navigator.run(): Reaching TELEPORTER");
            }
        }
        if (npSecond != null) {
            if (npSecond.isLiftCenter()) {
                locSecond = null;
                this.log.fine("Navigator.run(): Will NOT continue to LIFT-CENTER");
            }
            if (npFirst != null && npFirst.isLiftExit() && npSecond.isLiftExit()) {
                locSecond = null;
                this.log.fine("Navigator.run(): Will NOT continue to LIFT-EXIT");
            }
        }
        int distToFirst = (int)locCurrent.getDistance(locFirst);
        int dist2DToFirst = (int)locCurrent.getDistance2D(locFirst);
        int distZToFirst = (int)Math.abs(locCurrent.getDistanceZ(locFirst));
        double distTest = 50.0;
        double distTestZ = 115.0;
        if (npFirst != null) {
            if (npFirst.isJumpPad()) {
                distTest = 70.0;
                distZToFirst = 0;
                this.log.fine("Navigator.run(): Reaching JUMP-PAD");
            } else if (npFirst.isLiftCenter()) {
                distTest = 30.0;
            }
        }
        if ((double)distToFirst < distTest) {
            this.log.fine("Navigator.run(): REACHED " + locFirst + ", dist == " + distToFirst + " < " + distTest + " == test-precision");
            return NavigateResult.REACHED;
        }
        if ((double)distZToFirst < distTestZ && (double)dist2DToFirst < distTest) {
            this.log.fine("Navigator.run(): REACHED " + locFirst + ", distZ == " + distZToFirst + " < " + distTestZ + " == test-z-precision, dist2D == " + dist2DToFirst + " < " + distTest + " == test-precision");
            return NavigateResult.REACHED;
        }
        if (locPrevious != null && locSecond != null) {
            Location navigDirection = locFirst.sub(locPrevious).getNormalized();
            Location altDirection = locSecond.sub(locCurrent).getNormalized();
            double angle = Math.acos(navigDirection.dot(altDirection));
            double correction = 50.0;
            double zMin = Math.min(locFirst.z, locSecond.z) - correction;
            double zMax = Math.max(locFirst.z, locSecond.z) + correction;
            boolean isZok = zMin < locCurrent.z && locCurrent.z < zMax;
            double distToSecond = locCurrent.getDistance2D(locSecond);
            if (angle < 1.0471975511965976 && isZok && distToSecond < distTest) {
                this.log.log(Level.FINE, "Navigator.run(): REACHED next " + locSecond + " reached, dist == " + distToSecond + " < " + distTest + " == test-precision");
                return NavigateResult.REACHED;
            }
        }
        if (!this.runner.runToLocation(this.memory.getLocation(), locFirst, locSecond, ilocFocus, linkFirst, true, forceNoJump)) {
            this.log.log(Level.INFO, "Navigator.run(): Runner CRASHED!");
            return NavigateResult.CRASHED;
        }
        return NavigateResult.RUNNING;
    }

    protected NavPoint getNavPoint(ILocated location) {
        if (location == null) {
            return null;
        }
        if (location instanceof NavPoint) {
            return (NavPoint)location;
        }
        NavPoint np = (NavPoint)DistanceUtils.getNearest(this.main.getWorldView().getAll(NavPoint.class).values(), (ILocated)location);
        if (np.getLocation().getDistance(location.getLocation()) < 40.0) {
            return np;
        }
        return null;
    }

    private NavPointNeighbourLink getNavPointsLink(NavPoint start, NavPoint end) {
        if (start == null) {
            NavPoint tmp = this.getNavPoint((ILocated)this.memory.getLocation());
            if (tmp != null) {
                start = tmp;
            } else {
                return null;
            }
        }
        if (end == null) {
            return null;
        }
        if (end.getIncomingEdges().containsKey(start.getId())) {
            return end.getIncomingEdges().get(start.getId());
        }
        return null;
    }

    public NavMeshNavigator(UT2004Bot bot, AgentInfo info, AdvancedLocomotion move, IUT2004PathRunner runner, Logger log) {
        this.main = bot;
        this.memory = info;
        this.body = move;
        this.log = log;
        this.selfListener = new SelfListener((IWorldView)bot.getWorldView());
        this.runner = runner;
        NullCheck.check((Object)this.runner, (String)"runner");
    }

    @Override
    public Logger getLog() {
        return this.log;
    }

    private static enum MoverStageType {
        WAITING,
        RIDING;

    }

    private static enum NavigateResult {
        REACHED,
        RUNNING,
        CRASHED;

    }

    private class SelfListener
    implements IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> {
        private IWorldView worldView;

        public SelfListener(IWorldView worldView) {
            this.worldView = worldView;
            worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }

        public void notify(WorldObjectUpdatedEvent<Self> event) {
            NavMeshNavigator.this.self = (Self)event.getObject();
        }
    }

    public static enum Stage {
        REACHING{

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        NAVIGATING{

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        AWAITING_MOVER(MoverStageType.WAITING){

            @Override
            protected Stage next() {
                return RIDING_MOVER;
            }
        }
        ,
        RIDING_MOVER(MoverStageType.RIDING){

            @Override
            protected Stage next() {
                return NAVIGATING;
            }
        }
        ,
        CANCELED(TerminatingStageType.FAILURE){

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        TIMEOUT(TerminatingStageType.FAILURE){

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        CRASHED(TerminatingStageType.FAILURE){

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        COMPLETED(TerminatingStageType.SUCCESS){

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        TELEPORT(TeleportStageType.GOING_THROUGH){

            @Override
            protected Stage next() {
                return NAVIGATING;
            }
        };

        private boolean mover;
        public boolean terminated;
        public boolean failure;
        public boolean teleport;

        private Stage() {
            this.mover = false;
            this.teleport = false;
            this.terminated = false;
            this.failure = false;
        }

        private Stage(TeleportStageType type) {
            this.mover = false;
            this.teleport = true;
            this.failure = false;
            this.terminated = false;
        }

        private Stage(MoverStageType type) {
            this.mover = true;
            this.teleport = false;
            this.terminated = false;
            this.failure = false;
        }

        private Stage(TerminatingStageType type) {
            this.mover = false;
            this.teleport = false;
            this.terminated = true;
            this.failure = type.failure;
        }

        protected abstract Stage next();

        protected static Stage FirstMoverStage() {
            return AWAITING_MOVER;
        }

        protected static Stage TeleporterStage() {
            return TELEPORT;
        }
    }

    private static enum TeleportStageType {
        GOING_THROUGH;

    }

    private static enum TerminatingStageType {
        SUCCESS(false),
        FAILURE(true);

        public boolean failure;

        private TerminatingStageType(boolean failure) {
            this.failure = failure;
        }
    }
}

