/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathTracer;

import com.google.common.collect.Lists;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RayPath<TPolygon, TEdge> {
    protected TPolygon start;
    protected List<PathStep> steps = Lists.newArrayList();

    public RayPath(TPolygon start) {
        this.start = start;
    }

    public List<PathStep> getSteps() {
        return Collections.unmodifiableList(this.steps);
    }

    public List<TPolygon> asPolygons() {
        ArrayList retval = Lists.newArrayList();
        retval.add(this.start);
        for (PathStep step : this.steps) {
            retval.add(step.polygon);
        }
        return retval;
    }

    protected void addStep(Location intersection, TEdge edge, TPolygon polygon) {
        this.steps.add(new PathStep(intersection, edge, polygon));
    }

    public class PathStep {
        protected Location intersection;
        protected TEdge edge;
        protected TPolygon polygon;

        public PathStep(Location intersection, TEdge edge, TPolygon polygon) {
            this.intersection = intersection;
            this.edge = edge;
            this.polygon = polygon;
        }

        public Location getIntersection() {
            return this.intersection;
        }

        public TEdge getEdge() {
            return this.edge;
        }

        public TPolygon getPolygon() {
            return this.polygon;
        }
    }
}

