/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.RayCastResult;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.Triangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import math.bsp.IConstBspTree;
import math.bsp.algorithm.raycast.BspRayCaster;
import math.geom2d.Point2D;
import math.geom2d.polygon.SimplePolygon2D;
import math.geom3d.Point3D;
import math.geom3d.line.StraightLine3D;
import math.geom3d.plane.AxisAlignedPlane3D;
import math.geom3d.plane.Plane3D;
import math.geom3d.polygon.SimplePlanarPolygon3D;

public class RayCaster
extends BspRayCaster<ArrayList<Triangle>, AxisAlignedPlane3D, StraightLine3D, RayCastResult>
implements Serializable {
    private static final long serialVersionUID = 2L;
    protected static final Comparator<RayCastResult> hitDistanceComparator = new Comparator<RayCastResult>(){

        @Override
        public int compare(RayCastResult lhs, RayCastResult rhs) {
            return Double.compare(lhs.hitDistance, rhs.hitDistance);
        }
    };

    public RayCaster(IConstBspTree<ArrayList<Triangle>, AxisAlignedPlane3D> tree) {
        super(tree, false);
    }

    public double computeSideSignedDistanceSquare(AxisAlignedPlane3D boundary, StraightLine3D ray) {
        double intersectionParametric = boundary.getLineIntersectionParametric(ray);
        if (Double.isNaN(intersectionParametric)) {
            return boundary.getSignedDistance(ray.getOrigin()) * Double.POSITIVE_INFINITY;
        }
        double sign = Math.signum(boundary.getSignedDistance(ray.getOrigin()));
        if (Double.isInfinite(intersectionParametric) || intersectionParametric < 0.0 || intersectionParametric > 1.0) {
            return sign * Double.POSITIVE_INFINITY;
        }
        return sign * ray.getOrigin().getDistanceSquare(ray.getPoint(intersectionParametric));
    }

    public List<RayCastResult> getCollisions(StraightLine3D ray, double minDistanceSquare, double maxDistanceSquare, ArrayList<Triangle> data) {
        LinkedList<RayCastResult> retval = new LinkedList<RayCastResult>();
        for (Triangle triangle : data) {
            SimplePlanarPolygon3D trianglePolygon = triangle.planarPolygon;
            Plane3D trianglePlane = trianglePolygon.getPlane();
            Double intersectionParameter = ray.getPlaneIntersectionParametric(trianglePlane);
            if (Double.isInfinite(intersectionParameter) || intersectionParameter < 0.0 || intersectionParameter > 1.0) continue;
            Point3D intersection = ray.getPoint(intersectionParameter.doubleValue());
            double intersectionDistanceSquare = ray.getOrigin().getDistanceSquare(intersection);
            if (intersectionDistanceSquare < minDistanceSquare || maxDistanceSquare < intersectionDistanceSquare) continue;
            Point2D intersection2D = trianglePlane.getCoordinateSubsystem().project(intersection);
            SimplePolygon2D polygon2D = trianglePolygon.getPolygonIn2d();
            if (!polygon2D.contains(intersection2D, triangle.signedAreaIn2dProjection)) continue;
            Location intersectionLocation = new Location(intersection);
            retval.push(new RayCastResult(ray, intersectionLocation, trianglePlane.getNormalVector(), Math.sqrt(intersectionDistanceSquare), triangle));
        }
        Collections.sort(retval, hitDistanceComparator);
        return retval;
    }
}

