/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectAppearedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectDisappearedEvent;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.IVisibilityAdapter;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.UT2004Draw;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Mover;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Spawn;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.StopWatch;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public class NavPointVisibility
extends SensorModule<UT2004Bot> {
    private static final double ALL_VISIBLE_DISTANCE = 70.0;
    private boolean useFieldOfView = true;
    private double fovAngleDeg = 120.0;
    private double fovAngleDegItems = 90.0;
    private boolean enabled = true;
    private double navPointVisionDistance = 2000.0;
    private Boolean navpointsOff = null;
    private Set<NavPoint> visibleNavPoints;
    private Set<NavPoint> nextVisibleNavPoints;
    private SelfListener selfListener;
    ItemPickedUpListener itemPickedUpListener;
    ItemAppearedListener itemAppearedListener;
    ItemDisappearedListener itemDisappearedListener;
    MoverUpdatedListener moverUpdatedListener;
    BotKilledListener botKilledListener;
    ConfigChangeListener configChangeListener;
    private SpawnListener spawnListener;
    private boolean beginMessage = false;
    private BeginMessageListener beginMessageListener;
    private AgentInfo info;
    private IVisibilityAdapter visibilityAdapter;

    public void drawNavPointVisibility(UT2004Draw draw) {
        for (NavPoint navPoint : this.worldView.getAll(NavPoint.class).values()) {
            Color color = this.isNavPointVisible(navPoint) ? Color.green : Color.red;
            draw.drawCube(color, navPoint.getLocation(), 15.0);
        }
    }

    public void drawNavPointVisibilityWorldView(UT2004Draw draw) {
        for (NavPoint navPoint : this.worldView.getAll(NavPoint.class).values()) {
            Color color = navPoint.isVisible() ? Color.green : Color.red;
            draw.drawCube(color, navPoint.getLocation(), 15.0);
        }
    }

    public boolean isUseFOV() {
        return this.useFieldOfView;
    }

    public double getFOVAngleDeg() {
        return this.fovAngleDeg;
    }

    public boolean isInFOV(ILocated location, double fovAngleDeg) {
        if (location == null) {
            return false;
        }
        Location loc = location.getLocation();
        if (loc == null) {
            return false;
        }
        if (this.info.getLocation().getDistance(loc) < 70.0) {
            return true;
        }
        Location dir = loc.add(this.info.getLocation().invert()).getNormalized();
        Location heading = this.info.getRotation().toLocation().getNormalized();
        double angleDeg = Math.acos(heading.dot(dir)) / Math.PI * 180.0;
        if (angleDeg < -180.0) {
            angleDeg += 360.0;
        }
        if (angleDeg > 180.0) {
            angleDeg -= 360.0;
        }
        if (angleDeg < -fovAngleDeg / 2.0) {
            return false;
        }
        return !(angleDeg > fovAngleDeg / 2.0);
    }

    public boolean isUpdateWorldView() {
        return this.enabled;
    }

    public void setUpdateWorldView(boolean updateWorldView) {
        this.enabled = updateWorldView;
    }

    public boolean isInitialized() {
        return this.visibilityAdapter != null && this.visibilityAdapter.isInitialized();
    }

    public double getNavPointVisionDistance() {
        return this.navPointVisionDistance;
    }

    public void setNavPointVisionDistance(double navPointVisionDistance) {
        this.navPointVisionDistance = navPointVisionDistance;
    }

    protected void refreshNavPointVisibility() {
        if (this.visibilityAdapter == null || !this.visibilityAdapter.isInitialized()) {
            return;
        }
        if (this.enabled && (this.navpointsOff == null || !this.navpointsOff.booleanValue())) {
            ((UT2004Bot)this.agent).getAct().act((CommandMessage)new Configuration().setSyncNavPointsOff(true));
            this.navpointsOff = true;
        } else if (!this.enabled && this.navpointsOff != null && this.navpointsOff.booleanValue()) {
            ((UT2004Bot)this.agent).getAct().act((CommandMessage)new Configuration().setSyncNavPointsOff(false));
            this.navpointsOff = false;
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Self update => checking navpoint visibility...");
        }
        StopWatch watch = new StopWatch();
        Location myLocation = this.info.getLocation();
        int visibilityQueryCount = 0;
        for (NavPoint navPoint : this.worldView.getAll(NavPoint.class).values()) {
            double navPointDistance = this.info.getDistance(navPoint);
            if (navPointDistance > this.navPointVisionDistance) continue;
            ++visibilityQueryCount;
            if (!this.doVisibilityQueryNavPoint(navPoint)) continue;
            this.nextVisibleNavPoints.add(navPoint);
        }
        int navPointsDisappeared = 0;
        for (NavPoint navPoint : this.visibleNavPoints) {
            if (this.nextVisibleNavPoints.contains(navPoint)) continue;
            ++navPointsDisappeared;
            this.updateNavPointVisibilityInWorldView(navPoint, false);
        }
        int navPointsAppeared = 0;
        for (NavPoint navPoint : this.nextVisibleNavPoints) {
            if (this.visibleNavPoints.contains(navPoint)) continue;
            ++navPointsAppeared;
            this.updateNavPointVisibilityInWorldView(navPoint, true);
        }
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("#Navpoint querries = " + visibilityQueryCount + ", #Appeared = " + navPointsAppeared + ", #Disappeared = " + navPointsDisappeared + ", #TotalVisible = " + this.nextVisibleNavPoints.size());
            this.log.finer("Total time: " + watch.stopStr());
        }
        Set<NavPoint> temp = this.visibleNavPoints;
        this.visibleNavPoints = this.nextVisibleNavPoints;
        this.nextVisibleNavPoints = temp;
        this.nextVisibleNavPoints.clear();
    }

    private boolean doVisibilityQueryNavPoint(ILocated navPoint) {
        if (this.useFieldOfView && !this.isInFOV(navPoint, this.fovAngleDeg)) {
            return false;
        }
        return this.visibilityAdapter.isVisible((ILocated)this.info.getLocation(), navPoint);
    }

    private boolean doVisibilityQueryItem(ILocated item) {
        if (this.useFieldOfView && !this.isInFOV(item, this.fovAngleDegItems)) {
            return false;
        }
        return this.visibilityAdapter.isVisible((ILocated)this.info.getLocation(), item);
    }

    private void updateNavPointItemSpawnedInWorldView(NavPoint navPoint, boolean itemSpawned) {
        if (!this.enabled) {
            return;
        }
        NavPointMessage update = new NavPointMessage(navPoint.getId(), navPoint.getLocation(), navPoint.getVelocity(), itemSpawned ? true : navPoint.isVisible(), navPoint.getItem(), navPoint.getItemClass(), itemSpawned, navPoint.isDoorOpened(), navPoint.getMover(), navPoint.getLiftOffset(), navPoint.isLiftJumpExit(), navPoint.isNoDoubleJump(), navPoint.isInvSpot(), navPoint.isPlayerStart(), navPoint.getTeamNumber(), navPoint.isDomPoint(), navPoint.getDomPointController(), navPoint.isDoor(), navPoint.isLiftCenter(), navPoint.isLiftExit(), navPoint.isAIMarker(), navPoint.isJumpSpot(), navPoint.isJumpPad(), navPoint.isJumpDest(), navPoint.isTeleporter(), navPoint.getRotation(), navPoint.isRoamingSpot(), navPoint.isSnipingSpot(), navPoint.getItemInstance(), navPoint.getOutgoingEdges(), navPoint.getIncomingEdges(), navPoint.getPreferedWeapon());
        this.worldView.notifyImmediately((IWorldChangeEvent)update);
    }

    private void updateNavPointVisibilityInWorldView(NavPoint navPoint, boolean navPointVisible) {
        Item item;
        if (!this.enabled) {
            return;
        }
        boolean itemSpawned = navPoint.isItemSpawned();
        Item item2 = item = navPoint.getItem() == null ? null : (Item)this.worldView.get((WorldObjectId)navPoint.getItem(), Item.class);
        if (item != null) {
            if (item.isVisible()) {
                itemSpawned = true;
                navPointVisible = true;
            } else if (this.info.getLocation().getDistance(navPoint.getLocation()) > 70.0 && this.doVisibilityQueryItem(navPoint) && this.doVisibilityQueryItem((ILocated)item.getLocation())) {
                itemSpawned = false;
            }
        }
        this.updateNavPointVisibilityInWorldView(navPoint, navPointVisible, itemSpawned);
    }

    private void updateNavPointLocationInWorldView(NavPoint navPoint, Location newLocation) {
        if (!this.enabled) {
            return;
        }
        NavPointMessage update = new NavPointMessage(navPoint.getId(), newLocation, navPoint.getVelocity(), navPoint.isVisible(), navPoint.getItem(), navPoint.getItemClass(), navPoint.isItemSpawned(), navPoint.isDoorOpened(), navPoint.getMover(), navPoint.getLiftOffset(), navPoint.isLiftJumpExit(), navPoint.isNoDoubleJump(), navPoint.isInvSpot(), navPoint.isPlayerStart(), navPoint.getTeamNumber(), navPoint.isDomPoint(), navPoint.getDomPointController(), navPoint.isDoor(), navPoint.isLiftCenter(), navPoint.isLiftExit(), navPoint.isAIMarker(), navPoint.isJumpSpot(), navPoint.isJumpPad(), navPoint.isJumpDest(), navPoint.isTeleporter(), navPoint.getRotation(), navPoint.isRoamingSpot(), navPoint.isSnipingSpot(), navPoint.getItemInstance(), navPoint.getOutgoingEdges(), navPoint.getIncomingEdges(), navPoint.getPreferedWeapon());
        this.worldView.notifyImmediately((IWorldChangeEvent)update);
    }

    private void updateNavPointVisibilityInWorldView(NavPoint navPoint, boolean navPointVisible, boolean itemSpawned) {
        if (!this.enabled) {
            return;
        }
        if (navPoint.isVisible() != navPointVisible || navPoint.isItemSpawned() != itemSpawned) {
            if (this.log.isLoggable(Level.FINE)) {
                if (navPoint.isVisible() == navPointVisible) {
                    this.log.fine(navPoint.getId() + "[visible == " + navPointVisible + (navPoint.isInvSpot() ? ", itemSpawned -> " + itemSpawned : "") + "]");
                } else if (navPoint.isItemSpawned() == itemSpawned) {
                    this.log.fine(navPoint.getId() + "[visible -> " + navPointVisible + (navPoint.isInvSpot() ? ", itemSpawned == " + itemSpawned : "") + "]");
                } else {
                    this.log.fine(navPoint.getId() + "[visible -> " + navPointVisible + (navPoint.isInvSpot() ? ", itemSpawned -> " + itemSpawned : "") + "]");
                }
            }
        } else {
            return;
        }
        NavPointMessage update = new NavPointMessage(navPoint.getId(), navPoint.getLocation(), navPoint.getVelocity(), navPointVisible, navPoint.getItem(), navPoint.getItemClass(), itemSpawned, navPoint.isDoorOpened(), navPoint.getMover(), navPoint.getLiftOffset(), navPoint.isLiftJumpExit(), navPoint.isNoDoubleJump(), navPoint.isInvSpot(), navPoint.isPlayerStart(), navPoint.getTeamNumber(), navPoint.isDomPoint(), navPoint.getDomPointController(), navPoint.isDoor(), navPoint.isLiftCenter(), navPoint.isLiftExit(), navPoint.isAIMarker(), navPoint.isJumpSpot(), navPoint.isJumpPad(), navPoint.isJumpDest(), navPoint.isTeleporter(), navPoint.getRotation(), navPoint.isRoamingSpot(), navPoint.isSnipingSpot(), navPoint.getItemInstance(), navPoint.getOutgoingEdges(), navPoint.getIncomingEdges(), navPoint.getPreferedWeapon());
        this.worldView.notifyImmediately((IWorldChangeEvent)update);
    }

    private void dropNavPointVisibilityFlags() {
        for (NavPoint navPoint : this.visibleNavPoints) {
            this.updateNavPointVisibilityInWorldView(navPoint, false, navPoint.isItemSpawned());
        }
        this.visibleNavPoints.clear();
    }

    public boolean isNavPointVisible(NavPoint navPoint) {
        return this.visibleNavPoints.contains(navPoint);
    }

    public NavPointVisibility(UT2004Bot bot, AgentInfo info, IVisibilityAdapter visibilityAdapter) {
        super((IObservingAgent)bot);
        this.info = info;
        this.visibilityAdapter = visibilityAdapter;
        NullCheck.check((Object)((Object)info), (String)"info");
        NullCheck.check((Object)visibilityAdapter, (String)"visibilityAdapter");
        this.selfListener = new SelfListener(this.worldView);
        this.botKilledListener = new BotKilledListener(this.worldView);
        this.spawnListener = new SpawnListener(this.worldView);
        this.beginMessageListener = new BeginMessageListener(this.worldView);
        this.configChangeListener = new ConfigChangeListener(this.worldView);
        this.itemPickedUpListener = new ItemPickedUpListener(this.worldView);
        this.itemAppearedListener = new ItemAppearedListener(this.worldView);
        this.itemDisappearedListener = new ItemDisappearedListener(this.worldView);
        this.moverUpdatedListener = new MoverUpdatedListener(this.worldView);
        this.visibleNavPoints = new HashSet<NavPoint>();
        this.nextVisibleNavPoints = new HashSet<NavPoint>();
    }

    protected void cleanUp() {
        super.cleanUp();
        this.navpointsOff = null;
        if (this.visibleNavPoints == null) {
            this.visibleNavPoints = new HashSet<NavPoint>();
        } else {
            this.visibleNavPoints.clear();
        }
        if (this.nextVisibleNavPoints == null) {
            this.nextVisibleNavPoints = new HashSet<NavPoint>();
        } else {
            this.nextVisibleNavPoints.clear();
        }
    }

    private class BeginMessageListener
    implements IWorldEventListener<BeginMessage> {
        private IWorldView worldView;

        public BeginMessageListener(IWorldView worldView) {
            worldView.addEventListener(BeginMessage.class, (IWorldEventListener)this);
            this.worldView = worldView;
        }

        public void notify(BeginMessage event) {
            NavPointVisibility.this.beginMessage = true;
        }
    }

    private class BotKilledListener
    implements IWorldEventListener<BotKilled> {
        public BotKilledListener(IWorldView worldView) {
            worldView.addEventListener(BotKilled.class, (IWorldEventListener)this);
        }

        public void notify(BotKilled event) {
            NavPointVisibility.this.dropNavPointVisibilityFlags();
        }
    }

    private class ConfigChangeListener
    implements IWorldEventListener<ConfigChange> {
        public ConfigChangeListener(IWorldView worldView) {
            worldView.addEventListener(ConfigChange.class, (IWorldEventListener)this);
        }

        public void notify(ConfigChange event) {
            NavPointVisibility.this.navpointsOff = event.isSyncNavpoints();
        }
    }

    private class ItemAppearedListener
    implements IWorldObjectEventListener<Item, WorldObjectAppearedEvent<Item>> {
        public ItemAppearedListener(IWorldView worldView) {
            worldView.addObjectListener(Item.class, WorldObjectAppearedEvent.class, (IWorldObjectEventListener)this);
        }

        public void notify(WorldObjectAppearedEvent<Item> event) {
            if (NavPointVisibility.this.visibilityAdapter == null || !NavPointVisibility.this.visibilityAdapter.isInitialized()) {
                return;
            }
            if (!NavPointVisibility.this.enabled) {
                return;
            }
            NavPoint np = ((Item)event.getObject()).getNavPoint();
            if (np != null) {
                NavPointVisibility.this.updateNavPointVisibilityInWorldView(np, true, true);
            }
        }
    }

    private class ItemDisappearedListener
    implements IWorldObjectEventListener<Item, WorldObjectDisappearedEvent<Item>> {
        public ItemDisappearedListener(IWorldView worldView) {
            worldView.addObjectListener(Item.class, WorldObjectDisappearedEvent.class, (IWorldObjectEventListener)this);
        }

        public void notify(WorldObjectDisappearedEvent<Item> event) {
            if (NavPointVisibility.this.visibilityAdapter == null || !NavPointVisibility.this.visibilityAdapter.isInitialized()) {
                return;
            }
            if (!NavPointVisibility.this.enabled) {
                return;
            }
            NavPoint navPoint = ((Item)event.getObject()).getNavPoint();
            if (navPoint != null) {
                if (NavPointVisibility.this.doVisibilityQueryItem(navPoint)) {
                    if (NavPointVisibility.this.doVisibilityQueryItem((ILocated)((Item)event.getObject()).getLocation())) {
                        NavPointVisibility.this.updateNavPointVisibilityInWorldView(navPoint, true, false);
                    }
                } else if (!NavPointVisibility.this.doVisibilityQueryNavPoint(navPoint)) {
                    NavPointVisibility.this.updateNavPointVisibilityInWorldView(navPoint, false, navPoint.isItemSpawned());
                }
            }
        }
    }

    private class ItemPickedUpListener
    implements IWorldEventListener<ItemPickedUp> {
        public ItemPickedUpListener(IWorldView worldView) {
            worldView.addEventListener(ItemPickedUp.class, (IWorldEventListener)this);
        }

        public void notify(ItemPickedUp event) {
            if (NavPointVisibility.this.visibilityAdapter == null || !NavPointVisibility.this.visibilityAdapter.isInitialized()) {
                return;
            }
            if (!NavPointVisibility.this.enabled) {
                return;
            }
            Item item = (Item)NavPointVisibility.this.worldView.get((WorldObjectId)event.getId(), Item.class);
            if (item == null) {
                return;
            }
            NavPoint np = item.getNavPoint();
            if (np == null) {
                return;
            }
            NavPointVisibility.this.updateNavPointVisibilityInWorldView(np, np.isVisible(), false);
        }
    }

    private class MoverUpdatedListener
    implements IWorldObjectEventListener<Mover, WorldObjectUpdatedEvent<Mover>> {
        public MoverUpdatedListener(IWorldView worldView) {
            worldView.addObjectListener(Mover.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }

        public void notify(WorldObjectUpdatedEvent<Mover> event) {
            if (NavPointVisibility.this.visibilityAdapter == null || !NavPointVisibility.this.visibilityAdapter.isInitialized()) {
                return;
            }
            if (!NavPointVisibility.this.enabled) {
                return;
            }
            NavPoint navPoint = (NavPoint)NavPointVisibility.this.worldView.get((WorldObjectId)((Mover)event.getObject()).getNavPointMarker(), NavPoint.class);
            if (navPoint != null) {
                NavPointVisibility.this.updateNavPointLocationInWorldView(navPoint, ((Mover)event.getObject()).getLocation());
            }
        }
    }

    private class SelfListener
    implements IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> {
        private IWorldView worldView;

        public SelfListener(IWorldView worldView) {
            this.worldView = worldView;
            worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }

        public void notify(WorldObjectUpdatedEvent<Self> event) {
            if (NavPointVisibility.this.beginMessage) {
                NavPointVisibility.this.refreshNavPointVisibility();
                NavPointVisibility.this.beginMessage = false;
            }
        }
    }

    private class SpawnListener
    implements IWorldEventListener<Spawn> {
        private IWorldView worldView;

        public SpawnListener(IWorldView worldView) {
            worldView.addEventListener(Spawn.class, (IWorldEventListener)this);
            this.worldView = worldView;
        }

        public void notify(Spawn event) {
            NavPointVisibility.this.dropNavPointVisibilityFlags();
        }
    }
}

