/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.IEmbodiedAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensomotoricModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.ManualControlWindow;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavPointVisibility;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.LevelGeometryModule;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.RayCastResult;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshClearanceComputer;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshModule;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.UT2004Draw;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshPolygon;
import cz.cuni.amis.pogamut.ut2004.bot.command.CompleteBotCommandsWrapper;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.StopWatch;
import java.awt.Color;
import java.util.logging.Level;
import math.geom2d.Vector2D;

public class ManualControl
extends SensomotoricModule<UT2004Bot> {
    private ManualControlWindow window;
    private ManualControlWindow.IManualControlCallback manualControlCallback = new ManualControlWindow.IManualControlCallback(){

        @Override
        public void raycast() {
            ManualControl.this.raycast();
        }

        @Override
        public void jump() {
            ManualControl.this.jump();
        }

        @Override
        public void drawLevelGeometry() {
            ManualControl.this.drawLevelGeometry();
        }

        @Override
        public void drawLevelGeometryBSP() {
            ManualControl.this.drawLevelGeometryBSP();
        }

        @Override
        public void drawClear() {
            ManualControl.this.drawClear();
        }

        @Override
        public void drawNavPointVisibility() {
            ManualControl.this.drawNavPointVisibility();
        }

        @Override
        public void drawItemsVisibility() {
            ManualControl.this.drawItemsVisibility();
        }

        @Override
        public void drawNavPointVisibilityWorldView() {
            ManualControl.this.drawNavPointVisibilityGB2004();
        }

        @Override
        public void drawNavMesh() {
            ManualControl.this.drawNavMesh();
        }

        @Override
        public void drawNavMeshWithLinks() {
            ManualControl.this.drawNavMeshWithLinks();
        }

        @Override
        public void sendGlobalMessage(String msg) {
            ManualControl.this.sendGlobalMessage(msg);
        }

        @Override
        public boolean isActive() {
            return ManualControl.this.isActive();
        }

        @Override
        public void toggleActive() {
            ManualControl.this.toggleActive();
        }

        @Override
        public void raycastNavMesh() {
            ManualControl.this.raycastNavMesh();
        }
    };
    private boolean active = true;
    private SelfMessageListener selfMessageListener;
    private EndMessageListener endMessageListener;
    private AgentInfo info;
    private CompleteBotCommandsWrapper body;
    private LevelGeometryModule levelGeometryModule;
    private UT2004Draw draw;
    private NavPointVisibility navPointVisibility;
    private NavMeshModule navMeshModule;

    public void showWindow() {
        if (this.window == null) {
            this.createWindow();
        }
        this.window.setVisible(true);
        this.window.setLocation(10, 10);
    }

    private void createWindow() {
        this.window = new ManualControlWindow();
        this.window.callback = this.manualControlCallback;
    }

    public void hideWindow() {
        if (this.window == null) {
            return;
        }
        this.window.setVisible(false);
    }

    protected void tick() {
        if (this.window == null) {
            return;
        }
        this.window.setTitle(((Self)this.worldView.getSingle(Self.class)).getName());
        if (!this.active) {
            this.log.setLevel(Level.OFF);
            return;
        }
        this.log.setLevel(Level.ALL);
        if (this.window.forward) {
            this.body.getLocomotion().moveContinuos();
        }
        if (this.window.backward) {
            this.body.getLocomotion().strafeTo((ILocated)this.info.getLocation().add(this.info.getRotation().toLocation().invert().scale(300.0)), (ILocated)this.info.getLocation().add(this.info.getRotation().toLocation().scale(300.0)));
        }
        if (this.window.left) {
            this.body.getLocomotion().turnHorizontal(-15);
        }
        if (this.window.right) {
            this.body.getLocomotion().turnHorizontal(15);
        }
        if (!(this.window.forward || this.window.left || this.window.right || this.window.backward)) {
            this.body.getLocomotion().stopMovement();
        }
    }

    public void toggleActive() {
        this.active = !this.active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void drawClear() {
        if (this.draw == null) {
            return;
        }
        this.draw.clearAll();
        this.say("ALL DRAWING CLEARED");
    }

    public void drawLevelGeometryBSP() {
        if (this.levelGeometryModule == null) {
            return;
        }
        if (!this.levelGeometryModule.isInitialized()) {
            this.say("Level geometry not initialized, cannot draw BSP.");
            return;
        }
        this.say("Drawing level geometry BSP...");
        this.levelGeometryModule.getDraw().drawBSP();
        this.say("LEVEL GEOMETRY BSP DRAWN");
    }

    public void drawLevelGeometry() {
        if (this.levelGeometryModule == null) {
            return;
        }
        if (!this.levelGeometryModule.isInitialized()) {
            this.say("Level geometry not initialized, cannot draw.");
            return;
        }
        this.say("Drawing level geometry... This will take a long time, like 10-20 minutes.");
        this.levelGeometryModule.getDraw().draw();
        this.say("LEVEL GEOMETRY DRAWN");
    }

    public void jump() {
        this.body.getLocomotion().jump();
    }

    public void raycast() {
        if (this.levelGeometryModule == null) {
            return;
        }
        if (!this.levelGeometryModule.isInitialized()) {
            this.say("Level geometry not initialized, cannot raycast.");
            return;
        }
        int raycastDistance = 1000;
        this.say("Let's do some raycasting from here (client-side of course) up to " + raycastDistance + " UT units distance. ");
        StopWatch watch = new StopWatch();
        watch.start();
        Location rayVector = this.info.getRotation().toLocation().getNormalized().scale((double)raycastDistance);
        RayCastResult raycast = this.levelGeometryModule.getLevelGeometry().rayCast(this.info.getLocation(), this.info.getLocation().add(rayVector));
        watch.stop();
        this.log.info("RAYCAST RESULT");
        this.log.info("    +-- RAY:  " + raycast.ray.getOrigin() + " -> " + raycast.ray.getExamplePoint2());
        this.log.info("    +-- VEC:  " + raycast.ray.getVector());
        this.log.info("    +-- HIT:  " + raycast.isHit());
        if (raycast.isHit()) {
            this.log.info("        +-- LOCATION: " + raycast.hitLocation);
            this.log.info("        +-- DISTANCE: " + raycast.hitDistance);
        }
        this.say("1 Raycast, performed in " + watch.timeStr() + ", result: " + (raycast.isHit() ? "HIT" : "NO-HIT"));
        this.levelGeometryModule.getDraw().drawRaycast(raycast);
    }

    protected void raycastNavMesh() {
        if (this.navMeshModule == null) {
            return;
        }
        if (!this.navMeshModule.isInitialized()) {
            this.say("NavMeshModule not initialized, cannot raycast.");
            return;
        }
        int raycastDistance = 1000;
        this.say("Let's do some NAVMESH raycasting from here (client-side of course) up to " + raycastDistance + " UT units distance. ");
        StopWatch watch = new StopWatch();
        watch.start();
        NavMeshPolygon nmPoly = this.navMeshModule.getDropGrounder().tryGround((ILocated)this.info.getLocation());
        if (nmPoly == null) {
            this.say("CANNOT FIND NAVMESH UNDER MY LOCATION: " + this.info.getLocation());
            return;
        }
        Location nmLoc = new Location(nmPoly.getShape().project(this.info.getLocation().asPoint3D()));
        Location rayVector = this.info.getRotation().toLocation().getNormalized();
        NavMeshClearanceComputer.ClearanceLimit result = this.navMeshModule.getClearanceComputer().findEdge(this.info.getLocation(), new Vector2D(rayVector.x, rayVector.y), raycastDistance, 1000.0);
        watch.stop();
        boolean hit = result != null;
        this.log.info("RAYCAST RESULT");
        this.log.info("    +-- RAY:  " + this.info.getLocation() + " -> " + this.info.getLocation().add(rayVector.scale(1000.0)));
        this.log.info("    +-- VEC:  " + rayVector);
        this.log.info("    +-- HIT:  " + hit);
        if (hit) {
            this.log.info("        +-- LOCATION: " + result.getLocation());
            this.log.info("        +-- DISTANCE: " + result.getLocation().sub(nmLoc).getLength());
        }
        this.say("1 NavMesh Raycast, performed in " + watch.timeStr() + ", result: " + (hit ? "HIT" : "NO-HIT"));
        if (hit) {
            this.draw.drawLine(Color.red, nmLoc, result.getLocation());
        } else {
            this.draw.drawLine(Color.blue, nmLoc, nmLoc.add(rayVector.scale(1000.0)));
        }
    }

    public void drawNavPointVisibility() {
        if (this.draw == null) {
            return;
        }
        if (this.navPointVisibility == null) {
            return;
        }
        if (!this.navPointVisibility.isInitialized()) {
            this.say("Visibility matrix not loaded, cannot draw.");
            return;
        }
        this.say("Drawing nav point visibility (according to NavPointVisibility)...");
        this.navPointVisibility.drawNavPointVisibility(this.draw);
        this.say("Drawing DONE!");
    }

    public void drawNavPointVisibilityGB2004() {
        if (this.draw == null) {
            return;
        }
        if (this.navPointVisibility == null) {
            return;
        }
        if (!this.navPointVisibility.isInitialized()) {
            this.say("Visibility matrix not loaded, cannot draw.");
            return;
        }
        this.say("Drawing nav point visibility (according to WorldView)...");
        this.navPointVisibility.drawNavPointVisibilityWorldView(this.draw);
        this.say("Drawing DONE!");
    }

    protected void drawItemsVisibility() {
        if (this.draw == null) {
            return;
        }
        this.say("Drawing items visibility (according to WorldView)...");
        for (Item item : this.worldView.getAll(Item.class).values()) {
            Color color = item.isVisible() ? Color.green : Color.red;
            this.draw.drawCube(color, item.getLocation(), 15.0);
        }
        this.say("Drawing DONE!");
    }

    private void say(String text) {
        this.body.getCommunication().sendGlobalTextMessage(text);
    }

    protected void sendGlobalMessage(String msg) {
        this.say(msg);
    }

    public void drawNavMeshWithLinks() {
        if (this.navMeshModule == null) {
            return;
        }
        if (!this.navMeshModule.isInitialized()) {
            this.say("NavMeshModule not initialized, cannot draw.");
            return;
        }
        this.navMeshModule.getNavMeshDraw().draw(true, true);
    }

    public void drawNavMesh() {
        if (this.navMeshModule == null) {
            return;
        }
        if (!this.navMeshModule.isInitialized()) {
            this.say("NavMeshModule not initialized, cannot draw.");
            return;
        }
        this.navMeshModule.getNavMeshDraw().draw(true, false);
    }

    public ManualControl(UT2004Bot bot, AgentInfo info, CompleteBotCommandsWrapper body, LevelGeometryModule levelGeometryModule, UT2004Draw draw, NavPointVisibility navPointVisibility, NavMeshModule navMeshModule) {
        super((IEmbodiedAgent)bot);
        this.info = info;
        this.body = body;
        this.levelGeometryModule = levelGeometryModule;
        this.draw = draw;
        this.navPointVisibility = navPointVisibility;
        this.navMeshModule = navMeshModule;
        this.endMessageListener = new EndMessageListener(this.worldView);
        this.selfMessageListener = new SelfMessageListener(this.worldView);
    }

    protected void start(boolean startToPaused) {
        super.start(startToPaused);
        this.showWindow();
    }

    protected void cleanUp() {
        super.cleanUp();
        this.hideWindow();
    }

    private class EndMessageListener
    implements IWorldEventListener<EndMessage> {
        private IWorldView worldView;

        public EndMessageListener(IWorldView worldView) {
            worldView.addEventListener(EndMessage.class, (IWorldEventListener)this);
            this.worldView = worldView;
        }

        public void notify(EndMessage event) {
            ManualControl.this.tick();
        }
    }

    private class SelfMessageListener
    implements IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> {
        private IWorldView worldView;

        public SelfMessageListener(IWorldView worldView) {
            worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
            this.worldView = worldView;
        }

        public void notify(WorldObjectUpdatedEvent<Self> event) {
            ManualControl.this.tick();
        }
    }
}

