/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.formation;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshClearanceComputer;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshConstants;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import math.geom2d.Vector2D;

public class Formation {
    public static final double FORCE_TO_TARGET = 1.0;
    public static final double STEP_SIZE = 75.0;
    public static final double OBSTACLE_MAX_FORCE = 1.5;
    public static final double OBSTACLE_MAX_DISTANCE = 100.0;
    UT2004BotModuleController bot;
    Player leader;
    Location leaderLastSeenLocation;
    double leaderLastSeenRotation = 0.0;
    long leaderLastTimeSeen = 0L;
    Vector2D direction;
    double distance;
    NavMeshClearanceComputer clearanceComputer;
    boolean relativeRotation = true;
    boolean turnToLeaderAtDestination = true;
    boolean watchLeader = true;
    boolean suicideMode = false;

    public Formation(UT2004BotModuleController bot) throws Exception {
        this.bot = bot;
        this.clearanceComputer = bot.getNavMeshModule().getClearanceComputer();
        if (this.clearanceComputer == null) {
            throw new Exception("Formation cannot be instatiated because there is no navmesh.");
        }
    }

    public void holdFormation() {
        Vector2D rightFrontDirection;
        Vector2D leftFrontDirection;
        double force;
        if (this.leader == null) {
            System.out.println("No leader - no formation");
            return;
        }
        this.updateLeaderInfo();
        if (null == this.bot.getPlayers().getVisiblePlayer(this.leader.getId()) && this.watchLeader) {
            System.out.println("I lost the leader from sight. I look where i last saw him.");
            this.bot.getMove().turnTo((ILocated)this.leaderLastSeenLocation);
            return;
        }
        if (this.leaderLastSeenLocation == null) {
            System.out.println("I dont know where my leader is...");
            return;
        }
        double yaw = NavMeshConstants.transform2DVectorToRotation(this.direction);
        if (this.relativeRotation) {
            yaw += this.leaderLastSeenRotation;
        }
        Vector2D actualDirection = NavMeshConstants.transformRotationTo2DVector(yaw).getNormalizedVector().times(this.distance);
        Location targetLocaton = new Location(this.leaderLastSeenLocation.x + actualDirection.getX(), this.leaderLastSeenLocation.y + actualDirection.getY(), this.leaderLastSeenLocation.z);
        if (this.bot.getInfo().atLocation((ILocated)targetLocaton, 37.5)) {
            System.out.println("I am at the right spot.");
            if (this.turnToLeaderAtDestination) {
                this.bot.getMove().turnTo((ILocated)this.leaderLastSeenLocation);
            }
            return;
        }
        Location currenLocation = this.bot.getInfo().getLocation();
        Vector2D mainForce = new Vector2D(targetLocaton.x - currenLocation.x, targetLocaton.y - currenLocation.y);
        mainForce = mainForce.getNormalizedVector().times(1.0);
        yaw = this.bot.getInfo().getRotation().getYaw();
        Vector2D frontDirection = NavMeshConstants.transformRotationTo2DVector(yaw);
        double distance = this.clearanceComputer.computeXyProjectionDistanceFromEdge(currenLocation, frontDirection, 100.0);
        if (0.0 < distance && distance < 100.0) {
            force = distance / 100.0 * 1.5;
            Vector2D frontForce = frontDirection.getNormalizedVector().times(-force);
            mainForce = mainForce.plus(frontForce);
        }
        if (0.0 < (distance = this.clearanceComputer.computeXyProjectionDistanceFromEdge(currenLocation, leftFrontDirection = NavMeshConstants.transformRotationTo2DVector(yaw - NavMeshConstants.UTQuarterAngle / 2.0), 100.0)) && distance < 100.0) {
            force = distance / 100.0 * 1.5;
            Vector2D leftFrontForce = leftFrontDirection.getNormalizedVector().times(-force);
            mainForce = mainForce.plus(leftFrontForce);
        }
        if (0.0 < (distance = this.clearanceComputer.computeXyProjectionDistanceFromEdge(currenLocation, rightFrontDirection = NavMeshConstants.transformRotationTo2DVector(yaw + NavMeshConstants.UTQuarterAngle / 2.0), 100.0)) && distance < 100.0) {
            force = distance / 100.0 * 1.5;
            Vector2D rightFrontForce = rightFrontDirection.getNormalizedVector().times(-force);
            mainForce = mainForce.plus(rightFrontForce);
        }
        mainForce = mainForce.getNormalizedVector().times(75.0);
        Location resultLocation = new Location(currenLocation.x + mainForce.getX(), currenLocation.y + mainForce.getY(), currenLocation.z);
        System.out.println("Moving to resultLocation " + resultLocation);
        this.bot.getMove().moveTo((ILocated)resultLocation);
    }

    public void updateLeaderInfo() {
        if (this.bot.getPlayers().getVisiblePlayer(this.leader.getId()) != null) {
            System.out.println("Updating leader's location...");
            this.leaderLastSeenLocation = this.leader.getLocation();
            this.leaderLastSeenRotation = this.leader.getRotation().getYaw();
            this.leaderLastTimeSeen = System.nanoTime();
        } else {
            System.out.println("I cannot see the leader.");
        }
    }

    public int howLongLeaderNotSeen() {
        double nano = System.nanoTime() - this.leaderLastTimeSeen;
        return (int)(nano / 1.0E9);
    }

    public void setLeader(Player leader) {
        this.leader = leader;
        this.updateLeaderInfo();
    }

    public void setDirection(Vector2D direction) {
        this.direction = direction;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public Player getLeader() {
        return this.leader;
    }

    public Vector2D getDirection() {
        return this.direction;
    }

    public double getDistance() {
        return this.distance;
    }

    public Location getLeaderLastSeenLocation() {
        return this.leaderLastSeenLocation;
    }

    public long getLeaderLastTimeSeen() {
        return this.leaderLastTimeSeen;
    }
}

