/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing;

import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateRunning;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.IUT2004ServerProvider;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ServerRunner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004ServerProvider
implements IUT2004ServerProvider {
    protected Logger log;
    protected UT2004Server server;

    public UT2004ServerProvider() {
        this(null);
    }

    public UT2004ServerProvider(Logger log) {
        this.log = log;
        if (this.log == null) {
            this.log = new LogCategory("UT2004ServerProvider");
        }
    }

    @Override
    public UT2004Server getServer() {
        if (this.server == null) {
            this.init();
        }
        return this.server;
    }

    protected UT2004AgentParameters getDefaultServerParams() {
        UT2004AgentParameters result = new UT2004AgentParameters();
        return result;
    }

    public boolean isInited() {
        return this.server != null && this.server.inState(new Class[]{IAgentStateRunning.class});
    }

    public void init() {
        if (this.server != null && this.server.inState(new Class[]{IAgentStateRunning.class})) {
            return;
        }
        this.init(this.getDefaultServerParams());
    }

    public void init(UT2004AgentParameters params) {
        if (this.server != null && this.server.inState(new Class[]{IAgentStateRunning.class})) {
            return;
        }
        this.initForced(params);
    }

    public void initForced() {
        this.initForced(this.getDefaultServerParams());
    }

    public void initForced(UT2004AgentParameters params) {
        this.log.warning("Initializing. Creating UT2004Server...");
        this.killServer();
        UT2004ServerModule module = new UT2004ServerModule();
        UT2004ServerFactory factory = new UT2004ServerFactory(module);
        UT2004ServerRunner runner = new UT2004ServerRunner(factory);
        runner.setLogLevel(Level.SEVERE);
        this.server = (UT2004Server)runner.startAgents(new UT2004AgentParameters[]{params}).get(0);
        this.log.warning("Initialized. New UT2004Server instance created.");
    }

    @Override
    public void killServer() {
        if (this.server == null) {
            return;
        }
        this.log.warning("Killing old UT2004Server instance...");
        try {
            this.server.kill();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server = null;
    }
}

