/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import java.io.Serializable;
import math.geom3d.Axis3D;
import math.geom3d.plane.AxisAlignedPlane3D;

public class NodeSpace
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Location max;
    public Location min;

    public NodeSpace(double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        this.min = new Location(minX, minY, minZ);
        this.max = new Location(maxX, maxY, maxZ);
    }

    public NodeSpace splitOffNegative(AxisAlignedPlane3D plane) {
        return new NodeSpace(this.min.x, plane.axis == Axis3D.X ? plane.origin : this.max.x, this.min.y, plane.axis == Axis3D.Y ? plane.origin : this.max.y, this.min.z, plane.axis == Axis3D.Z ? plane.origin : this.max.z);
    }

    public NodeSpace splitOffPositive(AxisAlignedPlane3D plane) {
        return new NodeSpace(plane.axis == Axis3D.X ? plane.origin : this.min.x, this.max.x, plane.axis == Axis3D.Y ? plane.origin : this.min.y, this.max.y, plane.axis == Axis3D.Z ? plane.origin : this.min.z, this.max.z);
    }

    public void expand(Location vertex) {
        this.min = new Location(Math.min(vertex.x - 1.0, this.min.x), Math.min(vertex.y - 1.0, this.min.y), Math.min(vertex.z - 1.0, this.min.z));
        this.max = new Location(Math.max(vertex.x + 1.0, this.max.x), Math.max(vertex.y + 1.0, this.max.y), Math.max(vertex.z + 1.0, this.max.z));
    }

    public boolean contains(Location location) {
        return this.min.x - 0.1 <= location.x && location.x <= this.max.x + 0.1 && this.min.y - 0.1 <= location.y && location.y <= this.max.y + 0.1 && this.min.z - 0.1 <= location.z && location.z <= this.max.z + 0.1;
    }

    public double getSurfaceArea() {
        return ((this.max.x - this.min.x) * (this.max.y - this.min.y) + (this.max.x - this.min.x) * (this.max.z - this.min.z) + (this.max.y - this.min.y) * (this.max.z - this.min.z)) * 2.0;
    }

    public String toString() {
        return "x( " + this.min.x + ", " + this.max.x + " ), " + "y( " + this.min.y + ", " + this.max.y + " ), " + "z( " + this.min.z + ", " + this.max.z + " )";
    }
}

