/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.LogFormatter;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.LevelGeometry;
import cz.cuni.amis.utils.ExceptionToString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Logger;

public class LevelGeometryCache {
    public static LogCategory log = new LogCategory("LevelGeometryCache");
    private static Map<String, SoftReference<LevelGeometry>> cache;

    public static LevelGeometry getLevelGeometry(String mapName) {
        LevelGeometry result = LevelGeometryCache.getLevelGeometryFromCache(mapName);
        if (result != null) {
            return result;
        }
        return LevelGeometryCache.loadLevelGeometry(mapName);
    }

    private static LevelGeometry getLevelGeometryFromCache(String mapName) {
        SoftReference<LevelGeometry> reference = cache.get(mapName);
        if (reference == null) {
            return null;
        }
        LevelGeometry result = reference.get();
        if (result != null) {
            return result;
        }
        cache.remove(mapName);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LevelGeometry loadLevelGeometry(String mapName) {
        LevelGeometry result = LevelGeometryCache.getLevelGeometryFromCache(mapName);
        if (result != null) {
            return result;
        }
        String levelGeometryFileName = LevelGeometry.processedLevelGeometryDir + "\\" + mapName + ".plg";
        File levelGeometryFile = new File(levelGeometryFileName);
        ObjectInputStream in = null;
        try {
            if (!levelGeometryFile.exists()) {
                log.warning("Processed LevelGeometry does not exist at: " + levelGeometryFile.getAbsolutePath());
            } else {
                log.info("Loading previously stored LevelGeometry from binary file: " + levelGeometryFile.getAbsolutePath());
                in = new ObjectInputStream(new FileInputStream(levelGeometryFile));
                result = (LevelGeometry)in.readObject();
                result.setLog((Logger)log);
                log.info("LevelGeometry LOADED SUCCESSFULLY.");
            }
        }
        catch (InvalidClassException e) {
            log.warning("Preprocessed level geometry file was generated by a different version of software and must be regenerated.");
        }
        catch (ClassNotFoundException e) {
            log.warning("Preprocessed level geometry file was generated by a different version of software and must be regenerated.");
        }
        catch (IOException e) {
            log.severe(ExceptionToString.process((String)"Previously saved level geometry file could not have been restored, looking for original files.", (Throwable)e));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        if (result != null) {
            cache.put(mapName, new SoftReference<LevelGeometry>(result));
            return result;
        }
        try {
            result = new LevelGeometry((Logger)log);
            result.load(mapName);
            cache.put(mapName, new SoftReference<LevelGeometry>(result));
            log.info("LevelGeometry LOADED SUCCESSFULLY.");
            ObjectOutputStream out = null;
            try {
                log.warning("Writing level geometry to a file at: " + levelGeometryFile.getAbsolutePath());
                levelGeometryFile.getParentFile().mkdirs();
                out = new ObjectOutputStream(new FileOutputStream(levelGeometryFile));
                out.writeObject(result);
                log.info("Level geometry written ok.");
            }
            catch (Exception e) {
                log.severe(ExceptionToString.process((String)"Exception during writing level geom to a file.", (Throwable)e));
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
            return result;
        }
        catch (Exception e) {
            log.severe(ExceptionToString.process((String)"Unable to load level geometry files.", (Throwable)e));
            return null;
        }
    }

    static {
        LogPublisher.ConsolePublisher publisher = new LogPublisher.ConsolePublisher();
        publisher.setFormatter((Formatter)new LogFormatter((IAgentId)new AgentId("Platform")));
        log.addHandler((ILogPublisher)publisher);
        cache = Collections.synchronizedMap(new HashMap());
    }
}

