/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry;

import com.google.inject.internal.Lists;
import com.google.inject.internal.Maps;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.BSPRayInfoContainer;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.RawLevelGeometryFile;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.RayCastBspStrategy;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.RayCastResult;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.RayCaster;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.Triangle;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRayMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.UnrealUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import math.bsp.BspTree;
import math.bsp.IBspStrategy;
import math.bsp.IConstBspTree;
import math.bsp.node.BspInternalNode;
import math.bsp.node.BspLeafNode;
import math.bsp.node.IBspNode;
import math.bsp.node.IConstBspInternalNode;
import math.bsp.node.IConstBspNode;
import math.geom3d.Axis3D;
import math.geom3d.Point3D;
import math.geom3d.Vector3D;
import math.geom3d.line.StraightLine3D;
import math.geom3d.plane.AxisAlignedPlane3D;
import math.geom3d.transform.AffineTransform3D;

public class LevelGeometry
implements Serializable {
    public static String pureLevelGeometryReadDir = "map";
    public static String processedLevelGeometryDir = "map";
    private static final long serialVersionUID = 4L;
    protected transient Logger log;
    protected boolean loaded = false;
    protected ArrayList<Triangle> triangles = new ArrayList();
    protected BspTree<ArrayList<Triangle>, AxisAlignedPlane3D> bspTree = BspTree.make((IBspStrategy)new RayCastBspStrategy(this, new Random(250760834L)));
    protected RayCaster rayCaster = new RayCaster((IConstBspTree<ArrayList<Triangle>, AxisAlignedPlane3D>)this.bspTree);
    static final boolean dumpRayCastRequest = false;
    static final ObjectOutputStream rayCastRequestDumper = LevelGeometry.makeRaycastRequestDumper();

    public LevelGeometry(Logger log) {
        this.log = log;
        if (this.log == null) {
            this.log = new LogCategory("LevelGeometry");
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void clear() {
        this.loaded = false;
        this.triangles = new ArrayList();
        this.bspTree.clear();
    }

    public void setLog(Logger value) {
        this.log = value;
    }

    public void load(String mapName) {
        if (this.loaded) {
            this.clear();
        }
        try {
            String coreFilename = pureLevelGeometryReadDir + "\\" + mapName;
            RawLevelGeometryFile rawLevelGeometry = new RawLevelGeometryFile(coreFilename, this.log);
            for (RawLevelGeometryFile.RawTriangle rawTriangle : rawLevelGeometry.triangles) {
                this.triangles.add(new Triangle(rawTriangle));
            }
        }
        catch (IOException e) {
            this.log.warning("Could not load level geometry.");
            throw new RuntimeException("Could not load raw level geometry", e);
        }
        this.log.info("Creating BSP tree...");
        this.bspTree.setRoot((IBspNode)this.bspTree.makeLeafNode());
        this.bspTree.getRoot().asLeaf().setData(this.triangles);
        this.bspTree.optimize(this.bspTree.getRoot().asLeaf());
        this.log.info("BSP tree is done building.");
        this.leafReport();
        this.loaded = true;
    }

    public void leafReport() {
        int size;
        ArrayList leaves = Lists.newArrayList();
        ArrayList unprocessedNodes = Lists.newArrayList();
        unprocessedNodes.add(this.bspTree.getRoot());
        while (unprocessedNodes.size() > 0) {
            IBspNode node = (IBspNode)unprocessedNodes.remove(unprocessedNodes.size() - 1);
            if (node.isLeaf()) {
                leaves.add(node.asLeaf());
                continue;
            }
            unprocessedNodes.add(node.asInternal().getNegativeChild());
            unprocessedNodes.add(node.asInternal().getPositiveChild());
        }
        HashMap sizeToCount = Maps.newHashMap();
        for (BspLeafNode node : leaves) {
            size = ((ArrayList)node.getData()).size();
            int count = 0;
            if (sizeToCount.containsKey(size)) {
                count = (Integer)sizeToCount.get(size);
            }
            sizeToCount.put(size, count + 1);
        }
        ArrayList sizesAscending = Lists.newArrayList(sizeToCount.keySet());
        Collections.sort(sizesAscending);
        this.log.info("BSP tree leaf counts by size:");
        Iterator i$ = sizesAscending.iterator();
        while (i$.hasNext()) {
            size = (Integer)i$.next();
            this.log.info(sizeToCount.get(size) + " leaves with " + size + " triangles");
        }
    }

    public void drawTriangles(UT2004Server server, Location color) {
        for (Triangle triangle : this.triangles) {
            triangle.draw(server, color);
        }
    }

    public AutoTraceRay getAutoTraceRayMessage(Self self, BSPRayInfoContainer rayInfo) {
        Vector3D relativeDirection = new Vector3D(rayInfo.direction).getNormalizedVector();
        AffineTransform3D agentViewTranformation = AffineTransform3D.createRotationOz((double)UnrealUtils.unrealDegreeToRad(self.getRotation().getYaw()));
        Vector3D absoluteDirection = agentViewTranformation.transformVector(relativeDirection);
        Vector3D rayVector = absoluteDirection.times((double)rayInfo.length);
        Location from = self.getLocation();
        Location to = from.add(new Velocity(rayVector));
        RayCastResult raycastResult = this.rayCast(from, to);
        return new AutoTraceRayMessage(rayInfo.unrealId, from, to, false, rayInfo.floorCorrection, raycastResult.isHit(), raycastResult.isHit() ? raycastResult.hitNormal.asVector3d() : null, raycastResult.isHit() ? raycastResult.hitLocation : null, false, null);
    }

    public RayCastResult rayCast(Location from, Location to) {
        StraightLine3D line = new StraightLine3D(from.asPoint3D(), to.asPoint3D());
        RayCastResult retval = (RayCastResult)this.rayCaster.getCollision(line);
        if (retval == null) {
            retval = new RayCastResult(line, null, null, Double.NaN, null);
        }
        return retval;
    }

    public Triangle getTriangle(int index) {
        return this.triangles.get(index);
    }

    public List<Triangle> getTriangles() {
        return Collections.unmodifiableList(this.triangles);
    }

    public IConstBspNode<ArrayList<Triangle>, AxisAlignedPlane3D> getBspTreeRoot() {
        return this.bspTree.getRoot().asConst();
    }

    static ObjectOutputStream makeRaycastRequestDumper() {
        return null;
    }

    protected void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.loaded);
        HashMap vertexToIndexMap = Maps.newHashMap();
        ArrayList vertices = Lists.newArrayList();
        for (Triangle triangle : this.triangles) {
            for (Point3D vertex : triangle.vertices) {
                if (vertexToIndexMap.containsKey(vertex)) continue;
                vertexToIndexMap.put(vertex, vertices.size());
                vertices.add(vertex);
            }
        }
        out.writeInt(vertices.size());
        for (Point3D vertex : vertices) {
            out.writeDouble(vertex.getX());
            out.writeDouble(vertex.getY());
            out.writeDouble(vertex.getZ());
        }
        HashMap triangleToIndexMap = Maps.newHashMap();
        out.writeInt(this.triangles.size());
        for (int triangleIndex = 0; triangleIndex < this.triangles.size(); ++triangleIndex) {
            Triangle triangle = this.triangles.get(triangleIndex);
            triangleToIndexMap.put(triangle, triangleIndex);
            for (Point3D vertex : triangle.vertices) {
                out.writeInt((Integer)vertexToIndexMap.get(vertex));
            }
        }
        this.writeNode(out, (IConstBspNode<ArrayList<Triangle>, AxisAlignedPlane3D>)this.bspTree.getRoot(), triangleToIndexMap);
    }

    protected void readObject(ObjectInputStream in) throws IOException {
        this.loaded = in.readBoolean();
        ArrayList allVertices = Lists.newArrayList();
        int vertexCount = in.readInt();
        while (allVertices.size() < vertexCount) {
            double x = in.readDouble();
            double y = in.readDouble();
            double z = in.readDouble();
            allVertices.add(new Point3D(x, y, z));
        }
        this.triangles = Lists.newArrayList();
        int triangleCount = in.readInt();
        while (this.triangles.size() < triangleCount) {
            Point3D[] triangleVertices = new Point3D[3];
            for (int i = 0; i < 3; ++i) {
                triangleVertices[i] = (Point3D)allVertices.get(in.readInt());
            }
            this.triangles.add(new Triangle(triangleVertices[0], triangleVertices[1], triangleVertices[2]));
        }
        this.bspTree = BspTree.make((IBspStrategy)new RayCastBspStrategy(this, new Random(250760834L)));
        this.rayCaster = new RayCaster((IConstBspTree<ArrayList<Triangle>, AxisAlignedPlane3D>)this.bspTree);
        this.bspTree.setRoot(this.readNode(in));
    }

    protected void writeNode(ObjectOutputStream out, IConstBspNode<ArrayList<Triangle>, AxisAlignedPlane3D> node, HashMap<Triangle, Integer> triangleToIndexMap) throws IOException {
        out.writeBoolean(node.isInternal());
        if (node.isInternal()) {
            IConstBspInternalNode internalNode = node.asInternal();
            out.writeInt(((AxisAlignedPlane3D)internalNode.getBoundary()).axis.ordinal());
            out.writeDouble(((AxisAlignedPlane3D)internalNode.getBoundary()).origin);
            this.writeNode(out, (IConstBspNode<ArrayList<Triangle>, AxisAlignedPlane3D>)internalNode.getNegativeChild(), triangleToIndexMap);
            this.writeNode(out, (IConstBspNode<ArrayList<Triangle>, AxisAlignedPlane3D>)internalNode.getPositiveChild(), triangleToIndexMap);
        } else {
            ArrayList triangles = (ArrayList)node.asLeaf().getData();
            out.writeInt(triangles.size());
            for (Triangle triangle : triangles) {
                out.writeInt(triangleToIndexMap.get(triangle));
            }
        }
    }

    protected IBspNode<ArrayList<Triangle>, AxisAlignedPlane3D> readNode(ObjectInputStream in) throws IOException {
        boolean isInternal = in.readBoolean();
        if (isInternal) {
            BspInternalNode internalNode = this.bspTree.makeInternalNode();
            Axis3D axis = Axis3D.values()[in.readInt()];
            double origin = in.readDouble();
            internalNode.setBoundary((Object)new AxisAlignedPlane3D(axis, origin));
            internalNode.setNegativeChild(this.readNode(in));
            internalNode.setPositiveChild(this.readNode(in));
            return internalNode;
        }
        BspLeafNode leafNode = this.bspTree.makeLeafNode();
        int triangleCount = in.readInt();
        ArrayList data = Lists.newArrayList();
        while (data.size() < triangleCount) {
            data.add(this.triangles.get(in.readInt()));
        }
        leafNode.setData((Object)data);
        return leafNode;
    }
}

