/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.utils;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.utils.IFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TabooSet<T>
implements IFilter<T>,
Collection<T> {
    private Map<T, Double> taboo = new HashMap<T, Double>();
    private double time;
    BeginMessageListener beginMessageListener;

    public double getTabooTime(T item) {
        Double tabooTime = this.taboo.get(item);
        if (tabooTime == null) {
            return 0.0;
        }
        if (tabooTime < 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (tabooTime < this.time) {
            this.taboo.remove(item);
            return 0.0;
        }
        return tabooTime - this.time;
    }

    public boolean isTaboo(T item) {
        if (this.taboo.containsKey(item)) {
            double tabooTime = this.taboo.get(item);
            if (tabooTime < 0.0) {
                return true;
            }
            if (tabooTime < this.time) {
                this.taboo.remove(item);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean willBeTaboo(T item, double afterTime) {
        if (!this.isTaboo(item)) {
            return false;
        }
        if (this.taboo.containsKey(item)) {
            double tabooTime = this.taboo.get(item);
            return tabooTime > this.time + afterTime;
        }
        return false;
    }

    public boolean isTaboo(T item, IRelaxedTaboo estimator) {
        if (!this.isTaboo(item)) {
            return false;
        }
        return estimator.isTaboo(item, this.getTabooTime(item));
    }

    public boolean isAccepted(T item) {
        return !this.isTaboo(item);
    }

    public Set<T> filter(Collection<T> collection) {
        HashSet<T> set = new HashSet<T>();
        for (T t : collection) {
            if (this.isTaboo(t)) continue;
            set.add(t);
        }
        return set;
    }

    public Set<T> filter(Collection<T> collection, IRelaxedTaboo estimator) {
        HashSet<T> set = new HashSet<T>();
        for (T t : collection) {
            if (!this.isTaboo(t)) {
                set.add(t);
                continue;
            }
            if (estimator.isTaboo(t, this.getTabooTime(t))) continue;
            set.add(t);
        }
        return set;
    }

    public double getTime() {
        return this.time;
    }

    public TabooSet(UT2004Bot bot) {
        this.beginMessageListener = new BeginMessageListener((IWorldView)bot.getWorldView());
    }

    @Override
    public boolean add(T item) {
        boolean newItem = this.taboo.containsKey(item);
        this.taboo.put(item, -1.0);
        return newItem;
    }

    public void add(T item, double timeout) {
        this.taboo.put(item, this.time + timeout);
    }

    @Override
    public boolean remove(Object item) {
        return this.taboo.remove(item) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.taboo.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.taboo.containsKey(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.taboo.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.taboo.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.taboo.keySet().toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.taboo.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = false;
        for (T value : c) {
            result = result || this.add(value);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object value : c) {
            result = result || this.remove(value);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = false;
        Iterator<T> iterator = this.taboo.keySet().iterator();
        while (iterator.hasNext()) {
            T value = iterator.next();
            if (c.contains(value)) continue;
            iterator.remove();
            result = true;
        }
        return result;
    }

    @Override
    public int size() {
        return this.taboo.size();
    }

    @Override
    public void clear() {
        this.taboo.clear();
    }

    private class BeginMessageListener
    implements IWorldEventListener<BeginMessage> {
        public BeginMessageListener(IWorldView worldView) {
            worldView.addEventListener(BeginMessage.class, (IWorldEventListener)this);
        }

        public void notify(BeginMessage event) {
            TabooSet.this.time = event.getTime();
        }
    }

    public static interface IRelaxedTaboo<T> {
        public boolean isTaboo(T var1, double var2);
    }
}

