/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh;

import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.INavMeshAtom;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.OffMeshPoint;
import java.util.ArrayList;
import java.util.List;

public class NavMeshPolygon
implements INavMeshAtom {
    private int pId;

    public NavMeshPolygon(int pId) {
        assert (pId >= 0);
        this.pId = pId;
    }

    public int getPolygonId() {
        return this.pId;
    }

    @Override
    public List<INavMeshAtom> getNeighbours(NavMesh mesh) {
        ArrayList<INavMeshAtom> neighbours = new ArrayList<INavMeshAtom>();
        ArrayList<Integer> pn = mesh.getNeighbourIdsToPolygon(this.pId);
        for (Integer i : pn) {
            neighbours.add(new NavMeshPolygon(i));
        }
        List<OffMeshPoint> ops = mesh.getOffMeshPointsOnPolygon(this.pId);
        for (OffMeshPoint op : ops) {
            neighbours.add(op);
        }
        return neighbours;
    }

    @Override
    public boolean equals(INavMeshAtom atom) {
        return this.equals((Object)atom);
    }

    public boolean equals(Object other) {
        if (other instanceof NavMeshPolygon) {
            NavMeshPolygon p = (NavMeshPolygon)other;
            return p.getPolygonId() == this.pId;
        }
        return false;
    }

    public int hashCode() {
        return this.pId;
    }
}

