/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.OffMeshEdge;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.LinkFlag;
import javax.vecmath.Vector2d;

public class NavMeshConstants {
    public static String pureMeshReadDir = "navmesh";
    public static String processedMeshDir = "navmesh";
    public static String pureLevelGeometryReadDir = "map";
    public static String processedLevelGeometryDir = "map";
    public static int stopSplittingNumberOfPolygons = 1;
    public static int maxNumberOfPolygonsToTry = 10;
    public static double maxAllowedSplitFactor = 1.0;
    public static int stopSplittingNumberOfTriangles = 20;
    public static double stopSplittingSizeOfOneBlock = 40.0;
    public static double maxAllowedCrossFactor = 0.6;
    public static double UTFullAngle = 65536.0;
    public static double UTHalfAngle = UTFullAngle / 2.0;
    public static double UTQuarterAngle = UTHalfAngle / 2.0;
    public static double ForceToTarget = 1.0;
    public static double StepSize = 75.0;
    public static double obstacleMaxForce = 1.5;
    public static double obstacleMaxDistance = 100.0;
    public static double maxDistanceBotPolygon = 90.0;
    public static double liftPolygonLocation = 40.0;
    public static double agentRadius = 0.0;

    public static Location getColorForOffMeshConnection(OffMeshEdge oe, UT2004Server server) {
        NavPoint from = (NavPoint)((UT2004WorldView)((Object)server.getWorldView())).get((WorldObjectId)oe.getFrom().getNavPointId(), NavPoint.class);
        NavPoint to = (NavPoint)((UT2004WorldView)((Object)server.getWorldView())).get((WorldObjectId)oe.getTo().getNavPointId(), NavPoint.class);
        if (from == null) {
            return new Location(255.0, 255.0, 100.0);
        }
        if (to == null) {
            return new Location(255.0, 255.0, 100.0);
        }
        if (from.isLiftCenter() || to.isLiftCenter()) {
            return new Location(0.0, 0.0, 255.0);
        }
        if (from.isTeleporter() && to.isTeleporter()) {
            return new Location(150.0, 0.0, 255.0);
        }
        NavPointNeighbourLink link = from.getOutgoingEdges().get(oe.getLinkId());
        if (link == null) {
            return new Location(255.0, 255.0, 100.0);
        }
        int linkFlags = link.getFlags();
        LinkFlag.DOOR.get();
        if ((linkFlags & LinkFlag.FLY.get()) > 0) {
            return new Location(255.0, 0.0, 0.0);
        }
        if ((linkFlags & LinkFlag.FORCED.get()) > 0) {
            return new Location(255.0, 170.0, 255.0);
        }
        if ((linkFlags & LinkFlag.LADDER.get()) > 0) {
            return new Location(255.0, 0.0, 0.0);
        }
        if ((linkFlags & LinkFlag.PLAYERONLY.get()) > 0) {
            return new Location(255.0, 0.0, 0.0);
        }
        if ((linkFlags & LinkFlag.PROSCRIBED.get()) > 0) {
            return new Location(255.0, 0.0, 0.0);
        }
        if ((linkFlags & LinkFlag.SPECIAL.get()) > 0) {
            return new Location(255.0, 0.0, 255.0);
        }
        if ((linkFlags & LinkFlag.SWIM.get()) > 0) {
            return new Location(255.0, 0.0, 0.0);
        }
        LinkFlag.WALK.get();
        if ((linkFlags & LinkFlag.JUMP.get()) > 0) {
            return new Location(100.0, 255.0, 255.0);
        }
        return new Location(255.0, 255.0, 100.0);
    }

    public static double transform2DVectorToRotation(Vector2d vector) {
        double x = vector.x;
        double y = vector.y;
        double yaw = x == 0.0 ? (y >= 0.0 ? UTQuarterAngle : 3.0 * UTQuarterAngle) : (y == 0.0 ? (x >= 0.0 ? 0.0 : 2.0 * UTQuarterAngle) : (y > 0.0 ? (x > 0.0 ? 0.0 * UTQuarterAngle + Math.atan(y / x) / (Math.PI * 2) * UTFullAngle : 1.0 * UTQuarterAngle + Math.atan(-x / y) / (Math.PI * 2) * UTFullAngle) : (x < 0.0 ? 2.0 * UTQuarterAngle + Math.atan(-y / -x) / (Math.PI * 2) * UTFullAngle : 3.0 * UTQuarterAngle + Math.atan(x / -y) / (Math.PI * 2) * UTFullAngle)));
        return yaw;
    }

    public static Vector2d transformRotationTo2DVector(double yaw) {
        Vector2d direction = null;
        while (yaw < 0.0) {
            yaw += UTFullAngle;
        }
        double yawRad = (yaw %= UTFullAngle) / UTFullAngle * 2.0 * Math.PI;
        if (yaw % UTQuarterAngle == 0.0) {
            if (yaw == 0.0 * UTQuarterAngle) {
                direction = new Vector2d(1.0, 0.0);
            }
            if (yaw == 1.0 * UTQuarterAngle) {
                direction = new Vector2d(0.0, 1.0);
            }
            if (yaw == 2.0 * UTQuarterAngle) {
                direction = new Vector2d(-1.0, 0.0);
            }
            if (yaw == 3.0 * UTQuarterAngle) {
                direction = new Vector2d(0.0, -1.0);
            }
        } else {
            direction = yaw < 2.0 * UTQuarterAngle ? (yaw < 1.0 * UTQuarterAngle ? new Vector2d(1.0, Math.tan(yawRad)) : new Vector2d(-Math.tan(yawRad - 1.5707963267948966), 1.0)) : (yaw < 3.0 * UTQuarterAngle ? new Vector2d(-1.0, Math.tan(yawRad - Math.PI)) : new Vector2d(-Math.tan(yawRad - 4.71238898038469), -1.0));
        }
        direction.normalize();
        return direction;
    }
}

