/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh;

import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.INavMeshAtom;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import java.util.ArrayList;
import java.util.List;

public class AStarNode {
    private INavMeshAtom atom;
    private AStarNode from;
    private List<AStarNode> followers;
    private double distanceFromStart;
    private double estimatedDistanceToTarget;
    private double estimatedTotalDistance;

    public AStarNode(AStarNode from, INavMeshAtom atom, NavMesh mesh, INavMeshAtom start, INavMeshAtom target) {
        this.from = from;
        this.atom = atom;
        this.followers = new ArrayList<AStarNode>();
        this.distanceFromStart = from == null ? 0.0 : from.getDistanceFromStart() + mesh.getDistance(from.atom, atom);
        this.estimatedDistanceToTarget = mesh.getDistance(atom, target);
        this.estimatedTotalDistance = this.distanceFromStart + this.estimatedDistanceToTarget;
    }

    public double getDistanceFromStart() {
        return this.distanceFromStart;
    }

    public double getEstimatedDistanceToTarget() {
        return this.estimatedDistanceToTarget;
    }

    public double getEstimatedTotalDistance() {
        return this.estimatedTotalDistance;
    }

    public INavMeshAtom getAtom() {
        return this.atom;
    }

    public AStarNode getFrom() {
        return this.from;
    }

    public List<AStarNode> getFollowers() {
        return this.followers;
    }
}

