/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor.visibility;

import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.visibility.model.VisibilityLocation;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.visibility.model.VisibilityMatrix;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.FastTrace;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.GetAllInvetories;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.GetAllNavPoints;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FastTraceResponse;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ServerRunner;
import cz.cuni.amis.utils.StopWatch;
import cz.cuni.amis.utils.Tuple3;
import cz.cuni.amis.utils.flag.FlagInteger;
import cz.cuni.amis.utils.maps.MapWithKeyListeners;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class VisibilityCreator {
    public static final int MATRIX_DENSITY = 100;
    public static final Location SECOND_TRACE_DELTA = new Location(0.0, 0.0, 50.0);
    public static final int THREAD_COUNT = 10;
    private UT2004Server server;
    private LogCategory log;
    private MapPointListObtained mapPointsTemp;
    private BusAwareCountDownLatch mapPointsLatch;
    private IWorldEventListener<MapPointListObtained> mapPointsListener = new IWorldEventListener<MapPointListObtained>(){

        public void notify(MapPointListObtained event) {
            VisibilityCreator.this.mapPointsTemp = event;
            ((UT2004WorldView)((Object)VisibilityCreator.this.server.getWorldView())).removeEventListener(MapPointListObtained.class, this);
            VisibilityCreator.this.mapPointsLatch.countDown();
        }
    };
    private int totalRaycast;
    private int jobsGenerated;
    private FlagInteger jobsCompleted = new FlagInteger(Integer.valueOf(0));
    private MapWithKeyListeners<Token, FastTraceResponse> fastTraceResponses;
    private VisibilityMatrix matrix;
    private IWorldEventListener<FastTraceResponse> fastTraceListener = new IWorldEventListener<FastTraceResponse>(){

        public void notify(FastTraceResponse event) {
            VisibilityCreator.this.fastTraceResponses.put((Object)Tokens.get((String)event.getId()), (Object)event);
        }
    };
    private Object nextIdMutex = new Object();
    private int nextId = 0;
    private ConcurrentLinkedQueue<Token> availableTokens = new ConcurrentLinkedQueue();

    public VisibilityCreator() {
        UT2004ServerModule serverModule = new UT2004ServerModule();
        UT2004ServerFactory serverFactory = new UT2004ServerFactory(serverModule);
        UT2004ServerRunner serverRunner = new UT2004ServerRunner(serverFactory);
        this.server = (UT2004Server)serverRunner.startAgent();
        this.log = this.server.getLogger().getCategory(this.getClass().getSimpleName());
        this.log.setLevel(Level.INFO);
    }

    public VisibilityCreator(UT2004Server server) {
        this.server = server;
        this.log = server.getLogger().getCategory(this.getClass().getSimpleName());
        this.log.setLevel(Level.INFO);
    }

    public UT2004Server getServer() {
        return this.server;
    }

    public LogCategory getLog() {
        return this.log;
    }

    public synchronized VisibilityMatrix create() {
        this.log.info("CREATING VISIBILITY MATRIX");
        StopWatch watch = new StopWatch();
        this.checkServer();
        this.log.info("Time: " + watch.checkStr());
        MapPointListObtained mapPoints = this.obtainMapPoints();
        this.log.info("Time: " + watch.checkStr());
        List<Tuple3<Location, NavPoint, NavPointNeighbourLink>> locations = this.generateLocations(mapPoints);
        this.log.info("Time: " + watch.checkStr());
        VisibilityMatrix matrix = this.precreateMatrix(locations);
        this.log.info("Time: " + watch.checkStr());
        this.fillMatrix(matrix);
        this.log.info("Time: " + watch.checkStr());
        this.log.info("Visibility stats: " + matrix.getVisiblePairCount() + " / " + matrix.getPairCount() + " visible pairs");
        return matrix;
    }

    public VisibilityMatrix createAndSave(File targetDirectory) {
        VisibilityMatrix matrix = this.create();
        this.log.info("SAVING VISIBILITY MATRIX");
        StopWatch watch = new StopWatch();
        this.save(matrix, targetDirectory);
        this.log.info("Time: " + watch.checkStr());
        return matrix;
    }

    private void checkServer() {
        this.log.info("Checking server...");
        if (!this.server.inState(new Class[]{IAgentStateUp.class})) {
            this.log.info("Server is not running, starting server...");
            this.server.start();
            this.log.info("Server started.");
        } else {
            this.log.info("Server running.");
        }
        this.log.info("Map name: " + this.server.getMapName());
    }

    private MapPointListObtained obtainMapPoints() {
        this.log.info("Getting navpoints...");
        this.mapPointsLatch = new BusAwareCountDownLatch(1, this.server.getEventBus(), new IComponent[]{this.server.getWorldView()});
        ((UT2004WorldView)((Object)this.server.getWorldView())).addEventListener(MapPointListObtained.class, this.mapPointsListener);
        this.server.getAct().act((CommandMessage)new GetAllNavPoints());
        this.server.getAct().act((CommandMessage)new GetAllInvetories());
        this.mapPointsLatch.await();
        this.mapPointsLatch = null;
        this.log.info("Navpoints obtained, total " + this.mapPointsTemp.getNavPoints().size() + " navpoints in map.");
        return this.mapPointsTemp;
    }

    private List<Tuple3<Location, NavPoint, NavPointNeighbourLink>> generateLocations(MapPointListObtained mapPoints) {
        this.log.info("Generating visibility locations...");
        if (mapPoints.getNavPoints() == null || mapPoints.getNavPoints().size() == 0) {
            throw new RuntimeException("No navpoints in map?");
        }
        HashSet<NavPoint> finished = new HashSet<NavPoint>();
        HashSet<NavPoint> pending = new HashSet<NavPoint>();
        pending.addAll(mapPoints.getNavPoints().values());
        ArrayList<Tuple3<Location, NavPoint, NavPointNeighbourLink>> result = new ArrayList<Tuple3<Location, NavPoint, NavPointNeighbourLink>>(mapPoints.getNavPoints().size() * 3);
        while (pending.size() > 0) {
            NavPoint from = (NavPoint)pending.iterator().next();
            pending.remove(from);
            result.add(new Tuple3((Object)from.getLocation(), (Object)from, null));
            for (NavPointNeighbourLink link : from.getOutgoingEdges().values()) {
                NavPoint to = link.getToNavPoint();
                if (finished.contains(to)) continue;
                List<Location> locations = this.getLocationsBetween(from, to);
                for (Location location : locations) {
                    result.add((Tuple3<Location, NavPoint, NavPointNeighbourLink>)new Tuple3((Object)location, null, (Object)link));
                }
            }
            finished.add(from);
        }
        this.log.info("Done, generated " + result.size() + " unique locations for visibility matrix.");
        this.log.info("Matrix " + result.size() + "x" + result.size() + " == " + result.size() * result.size() + " bits == " + result.size() * result.size() / 8 + " bytes.");
        return result;
    }

    private List<Location> getLocationsBetween(NavPoint from, NavPoint to) {
        double distance = from.getLocation().getDistance(to.getLocation());
        int parts = (int)Math.round(distance) / 100;
        if (parts <= 0) {
            return new ArrayList<Location>(0);
        }
        double oneLength = distance / (double)parts;
        Location vector = to.getLocation().sub(from.getLocation()).getNormalized().scale(oneLength);
        ArrayList<Location> result = new ArrayList<Location>(parts - 1);
        int i = 1;
        while (i < parts) {
            result.add(from.getLocation().add(vector.scale((double)i)));
            ++i;
        }
        return result;
    }

    private VisibilityMatrix precreateMatrix(List<Tuple3<Location, NavPoint, NavPointNeighbourLink>> locations) {
        this.log.info("Pre-creating visibility matrix, filling visibility-locations...");
        VisibilityMatrix result = new VisibilityMatrix(this.server.getMapName(), locations.size());
        int i = 0;
        for (Tuple3<Location, NavPoint, NavPointNeighbourLink> location : locations) {
            Location loc = (Location)location.getFirst();
            NavPoint np = (NavPoint)location.getSecond();
            NavPointNeighbourLink link = (NavPointNeighbourLink)((Object)location.getThird());
            VisibilityLocation vLoc = new VisibilityLocation();
            vLoc.x = loc.x;
            vLoc.y = loc.y;
            vLoc.z = loc.z;
            if (np != null) {
                vLoc.navPoint = np;
                vLoc.navPoint1Id = this.getNavPointId(this.server.getMapName(), np);
            } else if (link != null) {
                vLoc.link = link;
                vLoc.navPoint1Id = this.getNavPointId(this.server.getMapName(), link.getFromNavPoint());
                vLoc.navPoint2Id = this.getNavPointId(this.server.getMapName(), link.getToNavPoint());
            } else {
                throw new RuntimeException("Tuple3 has neither NavPoint nor Link information, invalid.");
            }
            result.getLocations().put(i, vLoc);
            ++i;
        }
        this.log.info("Visibility matrix pre-created.");
        return result;
    }

    private String getNavPointId(String mapName, NavPoint np) {
        String id = np.getId().getStringId();
        String result = id.substring(mapName.length() + 1);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillMatrix(VisibilityMatrix matrix) {
        this.log.info("Gathering visibility information...");
        this.matrix = matrix;
        this.jobsGenerated = 0;
        this.jobsCompleted.setFlag((Object)0);
        this.fastTraceResponses = new MapWithKeyListeners();
        this.totalRaycast = matrix.getLocations().size() * (matrix.getLocations().size() - 1) / 2;
        this.log.info("Estimated number of raycasts to perform: " + this.totalRaycast);
        this.log.info("Registering FastTraceResponse listener...");
        ((UT2004WorldView)((Object)this.server.getWorldView())).addEventListener(FastTraceResponse.class, this.fastTraceListener);
        try {
            this.log.info("Starting thread pool executor...");
            ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 10, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000));
            try {
                this.log.info("Generating jobs...");
                int locations = matrix.getLocations().size();
                int i = 0;
                while (i < locations) {
                    VisibilityMatrix visibilityMatrix = matrix;
                    synchronized (visibilityMatrix) {
                        matrix.getMatrix().set(i, i);
                    }
                    int j = i + 1;
                    while (j < locations) {
                        TraceJob job = new TraceJob(i, matrix.getLocation(i), j, matrix.getLocation(j));
                        ++this.jobsGenerated;
                        if (this.jobsGenerated % 1000 == 0) {
                            this.log.info("Generated " + this.jobsGenerated + " / " + this.totalRaycast + " jobs generated...");
                        }
                        while (true) {
                            try {
                                executor.execute(job);
                                break;
                            }
                            catch (RejectedExecutionException e1) {
                                try {
                                    Thread.sleep(5000L);
                                }
                                catch (InterruptedException e2) {
                                    throw new RuntimeException("Interrupted while asleep.", e2);
                                }
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                this.log.info("Generated all " + this.jobsGenerated + " jobs, waiting their completion...");
                this.jobsCompleted.waitFor((Object[])new Integer[]{this.jobsGenerated});
                this.log.info("All " + this.jobsGenerated + " jobs finished!");
            }
            finally {
                executor.shutdownNow();
            }
        }
        finally {
            try {
                this.log.info("Removing FastTraceResponse listener...");
            }
            finally {
                try {
                    ((UT2004WorldView)((Object)this.server.getWorldView())).removeEventListener(FastTraceResponse.class, this.fastTraceListener);
                }
                finally {
                    this.matrix = null;
                }
            }
        }
        this.log.info("Visibility information gathered.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token getNextFastTraceId() {
        int myId;
        try {
            if (this.availableTokens.size() > 0) {
                return (Token)this.availableTokens.remove();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = this.nextIdMutex;
        synchronized (object) {
            myId = this.nextId++;
        }
        return Tokens.get((String)("FTID-" + myId));
    }

    private void returnId(Token token) {
        this.availableTokens.add(token);
    }

    private void save(VisibilityMatrix matrix, File targetDirectory) {
        this.log.info("Saving visibility matrix into: " + targetDirectory.getAbsolutePath());
        if (targetDirectory.exists()) {
            if (targetDirectory.isFile()) {
                throw new RuntimeException("'targetDirectory' points to " + targetDirectory.getAbsolutePath() + " which is FILE not DIRECTORY");
            }
            if (!targetDirectory.isDirectory()) {
                throw new RuntimeException("'targetDirectory' points to " + targetDirectory.getAbsolutePath() + " which is not DIRECTORY");
            }
        } else if (!targetDirectory.mkdirs()) {
            throw new RuntimeException("Failed to create 'targetDirectory' -> " + targetDirectory.getAbsolutePath());
        }
        matrix.save(targetDirectory);
        this.log.info("Visibility matrix saved.");
    }

    public static void main(String[] args) {
        VisibilityCreator creator = new VisibilityCreator();
        try {
            creator.createAndSave(new File("."));
        }
        finally {
            try {
                creator.getServer().stop();
            }
            finally {
                Pogamut.getPlatform().close();
            }
        }
    }

    private class TraceJob
    implements Runnable {
        private VisibilityLocation from;
        private VisibilityLocation to;
        private int indexFrom;
        private int indexTo;

        public TraceJob(int indexFrom, VisibilityLocation from, int indexTo, VisibilityLocation to) {
            this.indexFrom = indexFrom;
            this.from = from;
            this.indexTo = indexTo;
            this.to = to;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            VisibilityMatrix visibilityMatrix = VisibilityCreator.this.matrix;
            synchronized (visibilityMatrix) {
                VisibilityCreator.this.matrix.getMatrix().unset(this.indexFrom, this.indexTo);
                VisibilityCreator.this.matrix.getMatrix().unset(this.indexTo, this.indexFrom);
            }
            Token id1 = VisibilityCreator.this.getNextFastTraceId();
            Token id2 = VisibilityCreator.this.getNextFastTraceId();
            final BusAwareCountDownLatch latch = new BusAwareCountDownLatch(2, VisibilityCreator.this.server.getEventBus(), new IComponent[]{VisibilityCreator.this.server.getWorldView()});
            FastTrace fastTrace1 = new FastTrace().setId(id1.getToken()).setFrom(this.from.getLocation()).setTo(this.to.getLocation());
            final FastTrace fastTrace2 = new FastTrace().setId(id2.getToken()).setFrom(this.from.getLocation().add(SECOND_TRACE_DELTA)).setTo(this.to.getLocation().add(SECOND_TRACE_DELTA));
            MapWithKeyListeners.IKeyCreatedListener<Token, FastTraceResponse> listener = new MapWithKeyListeners.IKeyCreatedListener<Token, FastTraceResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public void notify(MapWithKeyListeners.KeyCreatedEvent<Token, FastTraceResponse> event) {
                    block9: {
                        block8: {
                            var2_2 /* !! */  = VisibilityCreator.access$3(TraceJob.access$2(TraceJob.this));
                            synchronized (var2_2 /* !! */ ) {
                                VisibilityCreator.access$3(TraceJob.access$2(TraceJob.this)).remove((Object)((Token)event.getKey()));
                            }
                            if (((FastTraceResponse)event.getValue()).isResult()) break block8;
                            var2_2 /* !! */  = VisibilityCreator.access$4(TraceJob.access$2(TraceJob.this));
                            synchronized (var2_2 /* !! */ ) {
                                VisibilityCreator.access$4(TraceJob.access$2(TraceJob.this)).getMatrix().set(TraceJob.access$0(TraceJob.this), TraceJob.access$1(TraceJob.this));
                                VisibilityCreator.access$4(TraceJob.access$2(TraceJob.this)).getMatrix().set(TraceJob.access$1(TraceJob.this), TraceJob.access$0(TraceJob.this));
                                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2 /* !! */ 
                                if (true) ** GOTO lbl20
                            }
                            do {
                                latch.countDown();
lbl20:
                                // 2 sources

                            } while (latch.getCount() > 0L);
                            break block9;
                        }
                        latch.countDown();
                        if (latch.getCount() > 0L) {
                            VisibilityCreator.access$1(TraceJob.access$2(TraceJob.this)).getAct().act((CommandMessage)fastTrace2);
                        }
                    }
                }
            };
            VisibilityCreator.this.fastTraceResponses.addWeakListener((Object)id1, (MapWithKeyListeners.IKeyCreatedListener)listener);
            VisibilityCreator.this.fastTraceResponses.addWeakListener((Object)id2, (MapWithKeyListeners.IKeyCreatedListener)listener);
            VisibilityCreator.this.server.getAct().act((CommandMessage)fastTrace1);
            latch.await();
            VisibilityCreator.this.fastTraceResponses.removeListener((Object)id1, (MapWithKeyListeners.IKeyCreatedListener)listener);
            VisibilityCreator.this.fastTraceResponses.removeListener((Object)id2, (MapWithKeyListeners.IKeyCreatedListener)listener);
            VisibilityCreator.this.returnId(id1);
            VisibilityCreator.this.returnId(id2);
            VisibilityCreator.this.jobsCompleted.increment(1);
            int num = (Integer)VisibilityCreator.this.jobsCompleted.getFlag();
            if (num % 50 == 0) {
                VisibilityCreator.this.log.info("Raycast " + num + " / " + VisibilityCreator.this.totalRaycast);
            }
            if (num % 1000 == 0) {
                VisibilityCreator.this.log.info("Existing IDs: " + VisibilityCreator.this.nextId);
            }
        }

        static /* synthetic */ int access$0(TraceJob traceJob) {
            return traceJob.indexFrom;
        }

        static /* synthetic */ int access$1(TraceJob traceJob) {
            return traceJob.indexTo;
        }

        static /* synthetic */ VisibilityCreator access$2(TraceJob traceJob) {
            return traceJob.VisibilityCreator.this;
        }
    }
}

