/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathfollowing;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.AbstractUT2004PathNavigator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathRunner;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Mover;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.NullCheck;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NavMeshNavigator<PATH_ELEMENT extends ILocated>
extends AbstractUT2004PathNavigator<PATH_ELEMENT> {
    private Location navigDestination = null;
    private Stage navigStage = Stage.COMPLETED;
    private ILocated focus = null;
    private SelfListener selfListener;
    public static final int CLOSE_ENOUGH = 50;
    private Iterator<PATH_ELEMENT> navigIterator = null;
    private int navigNextLocationOffset = 0;
    private Location navigLastLocation = null;
    private NavPoint navigLastNode = null;
    private Location navigCurrentLocation = null;
    private NavPoint navigCurrentNode = null;
    private NavPointNeighbourLink navigCurrentLink = null;
    private Location navigNextLocation = null;
    private NavPoint navigNextNode = null;
    private int navigMoverRideUpCount;
    private int navigMoverRideDownCount;
    private Boolean navigMoverIsRidingUp;
    private Boolean navigMoverIsRidingDown;
    private IUT2004PathRunner runner;
    protected UT2004Bot main;
    protected AgentInfo memory;
    protected AdvancedLocomotion body;
    protected Logger log;

    @Override
    protected void navigate(ILocated focus, int pathElementIndex) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Current stage: {0}", (Object)this.navigStage);
        }
        this.focus = focus;
        this.navigStage = this.keepNavigating();
        switch (this.navigStage) {
            case AWAITING_MOVER: 
            case RIDING_MOVER: {
                this.setBotWaiting(true);
                break;
            }
            case TELEPORT: 
            case NAVIGATING: 
            case REACHING: {
                this.setBotWaiting(false);
                break;
            }
            case TIMEOUT: 
            case CRASHED: 
            case CANCELED: {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.log(Level.WARNING, "Navigation {0}", (Object)this.navigStage);
                }
                this.executor.stuck();
                return;
            }
            case COMPLETED: {
                this.executor.targetReached();
            }
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Next stage: {0}", (Object)this.navigStage);
        }
    }

    @Override
    public void reset() {
        this.navigCurrentLocation = null;
        this.navigCurrentNode = null;
        this.navigCurrentLink = null;
        this.navigDestination = null;
        this.navigIterator = null;
        this.navigLastLocation = null;
        this.navigLastNode = null;
        this.navigNextLocation = null;
        this.navigNextNode = null;
        this.navigNextLocationOffset = 0;
        this.navigStage = Stage.COMPLETED;
        this.setBotWaiting(false);
        this.resetNavigMoverVariables();
    }

    @Override
    public void newPath(List<PATH_ELEMENT> path) {
        this.reset();
        Location dest = ((ILocated)path.get(path.size() - 1)).getLocation();
        this.initPathNavigation(dest, path);
    }

    @Override
    public void pathExtended(List<PATH_ELEMENT> path, int currentPathIndex) {
        if (path == null || path.isEmpty()) {
            throw new RuntimeException("path is null or 0-sized!");
        }
        this.navigDestination = ((ILocated)path.get(path.size() - 1)).getLocation();
        this.navigIterator = path.iterator();
        int newOffset = -currentPathIndex;
        for (int i = 0; i < path.size() && i < currentPathIndex + this.navigNextLocationOffset && this.navigIterator.hasNext(); ++i) {
            ++newOffset;
            this.navigIterator.next();
        }
        this.log.fine("PATH EXTEND ... curr index " + currentPathIndex + ", old offset " + this.navigNextLocationOffset + ", new offset " + newOffset + ", path size " + path.size());
        this.navigNextLocationOffset = newOffset;
    }

    @Override
    public NavPointNeighbourLink getCurrentLink() {
        return this.navigCurrentLink;
    }

    protected void initDirectNavigation(Location dest) {
        int distance = (int)this.memory.getLocation().getDistance(dest);
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Navigator.initDirectNavigation(): initializing direct navigation, distance {0}", distance);
        }
        this.initDirectly(dest);
    }

    protected void initPathNavigation(Location dest, List<PATH_ELEMENT> path) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Navigator.initPathNavigation(): initializing path navigation, nodes {0}", path.size());
        }
        if (!this.initAlongPath(dest, path)) {
            this.initDirectNavigation(dest);
        }
    }

    protected Stage keepNavigating() {
        if (this.navigStage.terminated) {
            return this.navigStage;
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            if (this.navigLastNode != null) {
                this.log.fine("Navigator.keepNavigating(): navigating from     " + this.navigLastNode.getId().getStringId() + this.navigLastNode.getLocation());
            } else if (this.navigLastLocation != null) {
                this.log.fine("Navigator.keepNavigating(): navigating from     " + this.navigLastLocation + " (navpoint is unknown)");
            }
            if (this.navigCurrentNode != null) {
                this.log.fine("Navigator.keepNavigating(): navigating to       " + this.navigCurrentNode.getId().getStringId() + this.navigCurrentNode.getLocation());
            } else if (this.navigCurrentLocation != null) {
                this.log.fine("Navigator.keepNavigating(): navigating to       " + this.navigCurrentLocation + " (navpoint is unknown)");
            }
            if (this.navigLastLocation != null && this.navigCurrentLocation != null) {
                this.log.fine("Navigator.keepNavigating(): distance in-between " + this.navigCurrentLocation.getDistance(this.navigLastLocation));
            }
        }
        switch (this.navigStage) {
            case REACHING: {
                this.navigStage = this.navigDirectly();
                break;
            }
            default: {
                this.navigStage = this.navigAlongPath();
            }
        }
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Navigator.keepNavigating(): navigation stage " + (Object)((Object)this.navigStage));
        }
        return this.navigStage;
    }

    private Stage initDirectly(Location dest) {
        this.navigDestination = dest;
        this.runner.reset();
        this.navigStage = Stage.REACHING;
        return this.navigStage;
    }

    private Stage navigDirectly() {
        int distance = (int)this.memory.getLocation().getDistance(this.navigDestination);
        if (distance <= 50) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Navigator.navigDirectly(): destination close enough: " + distance);
            }
            return Stage.COMPLETED;
        }
        if (!this.runner.runToLocation(this.navigLastLocation, this.navigDestination, null, (ILocated)(this.focus == null ? this.navigDestination : this.focus), null, true)) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Navigator.navigDirectly(): direct navigation failed");
            }
            return Stage.CRASHED;
        }
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.finer("Navigator.navigDirectly(): traveling directly, distance = " + distance);
        }
        return this.navigStage;
    }

    protected NavPoint getNavPoint(ILocated location) {
        if (location instanceof NavPoint) {
            return (NavPoint)location;
        }
        NavPoint np = (NavPoint)DistanceUtils.getNearest(this.main.getWorldView().getAll(NavPoint.class).values(), (ILocated)location);
        if (np.getLocation().getDistance(location.getLocation()) < 50.0) {
            return np;
        }
        return null;
    }

    private boolean initAlongPath(Location dest, List<PATH_ELEMENT> path) {
        this.navigDestination = dest;
        this.navigIterator = path.iterator();
        this.navigCurrentLocation = this.bot.getLocation();
        this.navigCurrentNode = (NavPoint)DistanceUtils.getNearest(this.bot.getWorldView().getAll(NavPoint.class).values(), (ILocated)this.bot.getLocation(), (double)40.0);
        this.prepareNextNode();
        this.navigStage = Stage.NAVIGATING;
        return this.switchToNextNode();
    }

    private Stage navigAlongPath() {
        int totalDistance = (int)this.memory.getLocation().getDistance(this.navigDestination);
        if (totalDistance <= 50) {
            this.log.log(Level.FINEST, "Navigator.navigAlongPath(): destination close enough: {0}", totalDistance);
            return Stage.COMPLETED;
        }
        if (this.navigStage.mover) {
            this.log.fine("Navigator.navigAlongPath(): MOVER");
            return this.navigThroughMover();
        }
        if (this.navigStage.teleport) {
            this.log.fine("Navigator.navigAlongPath(): TELEPORT");
            return this.navigThroughTeleport();
        }
        this.log.fine("Navigator.navigAlongPath(): STANDARD");
        return this.navigToCurrentNode(true);
    }

    private void prepareNextNode() {
        if (this.navigCurrentNode != null && this.navigCurrentNode.isTeleporter()) {
            this.prepareNextNodeTeleporter();
            return;
        }
        ILocated located = null;
        this.navigNextLocation = null;
        this.navigNextNode = null;
        this.navigNextLocationOffset = 0;
        while (located == null && this.navigIterator.hasNext()) {
            located = (ILocated)this.navigIterator.next();
            ++this.navigNextLocationOffset;
            if (located != null) continue;
        }
        if (located == null) {
            this.navigNextLocationOffset = 0;
            return;
        }
        if (this.executor.getPathElementIndex() + this.navigNextLocationOffset >= this.executor.getPath().size()) {
            this.navigNextLocationOffset = 0;
        }
        this.navigNextLocation = located.getLocation();
        this.navigNextNode = this.getNavPoint(located);
    }

    private void prepareNextNodeTeleporter() {
        ILocated located = null;
        this.navigNextLocation = null;
        this.navigNextLocationOffset = 0;
        boolean nextTeleporterFound = false;
        while (located == null && this.navigIterator.hasNext()) {
            located = (ILocated)this.navigIterator.next();
            ++this.navigNextLocationOffset;
            if (located == null) continue;
            this.navigNextNode = this.getNavPoint(located);
            if (this.navigNextNode == null || !this.navigNextNode.isTeleporter()) break;
            if (!nextTeleporterFound) {
                located = null;
            }
            nextTeleporterFound = true;
        }
        if (located == null) {
            this.navigNextLocationOffset = 0;
            return;
        }
        if (this.executor.getPathElementIndex() + this.navigNextLocationOffset >= this.executor.getPath().size()) {
            this.navigNextLocationOffset = 0;
        }
        this.navigNextLocation = located.getLocation();
        this.navigNextNode = this.getNavPoint(located);
    }

    private boolean switchToNextNode() {
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("Navigator.switchToNextNode(): switching!");
        }
        this.navigLastLocation = this.navigCurrentLocation;
        this.navigLastNode = this.navigCurrentNode;
        this.navigCurrentLocation = this.navigNextLocation;
        if (null == this.navigCurrentLocation) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("Navigator.switchToNextNode(): no nodes left");
            }
            this.navigCurrentNode = null;
            return false;
        }
        this.navigCurrentNode = this.navigNextNode;
        this.navigCurrentLink = this.getNavPointsLink(this.navigLastNode, this.navigCurrentNode);
        if (this.navigCurrentLink == null) {
            this.getNavPointsLink(this.navigLastNode, this.navigCurrentNode);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("No link information...");
            }
        }
        if (this.navigLastLocation == null) {
            this.navigLastLocation = this.bot.getLocation();
            this.navigLastNode = this.navigCurrentNode;
        }
        int localDistance = (int)this.memory.getLocation().getDistance(this.navigCurrentLocation.getLocation());
        if (this.navigCurrentNode != null && this.navigCurrentNode.isTeleporter()) {
            this.navigStage = Stage.TeleporterStage();
        } else if (this.navigCurrentNode != null && this.navigCurrentNode.isLiftCenter()) {
            this.navigStage = Stage.FirstMoverStage();
            this.resetNavigMoverVariables();
            if (this.memory.getLocation().getDistance(this.navigCurrentNode.getLocation()) < 50.0) {
                this.navigStage = this.navigStage.next();
            }
        } else if (this.navigStage.mover) {
            this.navigStage = this.navigStage.next();
            this.runner.reset();
        } else if (this.navigStage.teleport) {
            this.navigStage = this.navigStage.next();
            this.runner.reset();
        } else {
            this.runner.reset();
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            if (this.navigCurrentNode != null) {
                this.log.fine("Navigator.switchToNextNode(): switch to next node " + this.navigCurrentNode.getId().getStringId() + ", distance " + localDistance + ", reachable " + this.isReachable(this.navigCurrentNode) + ", mover " + this.navigStage.mover);
            } else {
                this.log.log(Level.FINE, "Navigator.switchToNextNode(): switch to next location {0}, distance {1}, mover {2}", new Object[]{this.navigCurrentLocation, localDistance, this.navigStage.mover});
            }
        }
        if (this.executor.getPathElementIndex() < 0) {
            this.executor.switchToAnotherPathElement(0);
        } else if (this.navigNextLocationOffset > 0) {
            this.executor.switchToAnotherPathElement(this.executor.getPathElementIndex() + this.navigNextLocationOffset);
        } else {
            this.executor.switchToAnotherPathElement(this.executor.getPathElementIndex());
        }
        this.navigNextLocationOffset = 0;
        this.prepareNextNode();
        if (localDistance < 20) {
            return this.switchToNextNode();
        }
        return true;
    }

    protected boolean isReachable(NavPoint node) {
        return true;
    }

    private void resetNavigMoverVariables() {
        this.navigMoverIsRidingUp = null;
        this.navigMoverIsRidingDown = null;
        this.navigMoverRideUpCount = 0;
        this.navigMoverRideDownCount = 0;
    }

    private void checkMoverMovement(Mover mover) {
        if (mover.getVelocity().z > 0.0) {
            if (this.navigMoverIsRidingUp == null) {
                this.navigMoverIsRidingUp = true;
                this.navigMoverIsRidingDown = false;
                this.navigMoverRideUpCount = 1;
                this.navigMoverRideDownCount = 0;
            } else if (this.navigMoverIsRidingDown.booleanValue()) {
                this.navigMoverIsRidingUp = true;
                this.navigMoverIsRidingDown = false;
                ++this.navigMoverRideUpCount;
            }
        } else if (mover.getVelocity().z < 0.0) {
            if (this.navigMoverIsRidingDown == null) {
                this.navigMoverIsRidingUp = false;
                this.navigMoverIsRidingDown = true;
                this.navigMoverRideUpCount = 0;
                this.navigMoverRideDownCount = 1;
            } else if (this.navigMoverIsRidingUp.booleanValue()) {
                this.navigMoverIsRidingUp = false;
                this.navigMoverIsRidingDown = true;
                ++this.navigMoverRideDownCount;
            }
        }
    }

    private NavPointNeighbourLink getNavPointsLink(NavPoint start, NavPoint end) {
        if (start == null) {
            NavPoint tmp = this.getNavPoint((ILocated)this.memory.getLocation());
            if (tmp != null) {
                start = tmp;
            } else {
                return null;
            }
        }
        if (end == null) {
            return null;
        }
        if (end.getIncomingEdges().containsKey(start.getId())) {
            return end.getIncomingEdges().get(start.getId());
        }
        return null;
    }

    private Stage navigToCurrentNode(boolean useFocus) {
        ILocated focus;
        Location secondLocation;
        if (this.navigCurrentNode != null) {
            this.navigCurrentLocation = this.navigCurrentNode.getLocation();
        }
        if (this.navigNextNode != null) {
            this.navigNextLocation = this.navigNextNode.getLocation();
        }
        int localDistance = (int)this.memory.getLocation().getDistance(this.navigCurrentLocation.getLocation());
        int localDistance2D = (int)this.memory.getLocation().getDistance2D(this.navigCurrentLocation.getLocation());
        int distanceZ = (int)Math.abs(this.memory.getLocation().getDistanceZ(this.navigCurrentLocation));
        Location firstLocation = this.navigCurrentLocation.getLocation();
        Object object = this.navigNextNode != null ? (this.navigNextNode.isLiftCenter() || this.navigNextNode.isLiftExit() ? null : this.navigNextNode.getLocation()) : (secondLocation = this.navigNextLocation);
        Object object2 = this.focus == null || !useFocus ? (this.navigNextLocation == null ? firstLocation : this.navigNextLocation.getLocation()) : (focus = this.focus);
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Navigator.navigToCurrentNode(): FIRST  LOC      " + (firstLocation == null ? null : firstLocation.toString()));
            this.log.fine("Navigator.navigToCurrentNode(): FIRST  LOC Dist " + (firstLocation == null ? null : Double.valueOf(this.bot.getSelf().getLocation().getDistance(firstLocation))));
            this.log.fine("Navigator.navigToCurrentNode(): SECOND LOC      " + (secondLocation == null ? null : secondLocation.toString()));
            this.log.fine("Navigator.navigToCurrentNode(): SECOND LOC Dist " + (secondLocation == null ? null : Double.valueOf(firstLocation.getDistance(secondLocation))));
            this.log.fine("Navigator.navigToCurrentNode(): CURR SPEED      " + this.bot.getSelf().getVelocity().size());
        }
        if (!this.runner.runToLocation(this.navigLastLocation, firstLocation, secondLocation, focus, this.navigCurrentLink, this.navigCurrentNode == null ? true : this.isReachable(this.navigCurrentNode))) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Navigator.navigToCurrentNode(): navigation to current node failed");
            }
            return Stage.CRASHED;
        }
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Navigator.navigToCurrentNode(): traveling to current node, distance = " + localDistance);
        }
        int testDistance = 45;
        if (this.navigCurrentNode != null && (this.navigCurrentNode.isLiftCenter() || this.navigCurrentNode.isLiftExit())) {
            testDistance = 30;
        }
        if (this.navigCurrentNode != null && this.navigCurrentNode.isJumpPad()) {
            testDistance = 70;
            distanceZ = 0;
        }
        if (this.navigCurrentLocation != null && this.navigCurrentLocation.equals(this.executor.getPath().get(this.executor.getPath().size() - 1)) || !this.navigIterator.hasNext() && (this.navigNextLocation == null || this.navigCurrentLocation == this.navigNextLocation)) {
            testDistance = 50;
        }
        if (distanceZ < 40 && (localDistance < testDistance || localDistance2D < testDistance) || localDistance2D < 25 && distanceZ < 115) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "Navigator.navigToCurrentNode(): near enough - switching to next node. DistanceZ : {0}", distanceZ);
            }
            if (!this.switchToNextNode()) {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Navigator.navigToCurrentNode(): switching to direct navigation");
                }
                return this.initDirectly(this.navigDestination);
            }
            return this.keepNavigating();
        }
        Location botCurrentLocation = this.memory.getLocation();
        if (this.navigCurrentLocation != null && this.navigLastLocation != null && this.navigNextLocation != null && botCurrentLocation != null && !this.navigStage.teleport) {
            double FALL_THRESHOLD;
            double currentZ = Math.min(this.navigLastLocation.z, this.navigCurrentLocation.z);
            if (botCurrentLocation.z < currentZ - (FALL_THRESHOLD = 200.0) && Math.abs(botCurrentLocation.z - this.navigNextLocation.z) < FALL_THRESHOLD) {
                Location lastLocation = this.memory.getLocation();
                if (!this.switchToNextNode()) {
                    if (this.log != null && this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Navigator.navigToCurrentNode(): switching to direct navigation");
                    }
                    return this.initDirectly(this.navigDestination);
                }
                this.navigLastLocation = lastLocation;
                return this.keepNavigating();
            }
            if (botCurrentLocation.getDistance2D(this.navigNextLocation) < this.navigCurrentLocation.getDistance2D(this.navigNextLocation) + 45.0 && this.navigCurrentLink == null) {
                boolean isZok;
                Location navigDirection = this.navigCurrentLocation.sub(this.navigLastLocation);
                Location altDirection = this.navigNextLocation.sub(this.navigCurrentLocation).getNormalized();
                double angle = Math.acos(navigDirection.getNormalized().dot(altDirection));
                double correction = 50.0;
                double zMin = Math.min(this.navigCurrentLocation.z, this.navigNextLocation.z) - correction;
                double zMax = Math.max(this.navigCurrentLocation.z, this.navigNextLocation.z) + correction;
                boolean bl = isZok = botCurrentLocation.z > zMin && botCurrentLocation.z < zMax;
                if (angle < 1.0471975511965976 && isZok && botCurrentLocation.getDistance2D(this.navigNextLocation) < this.navigCurrentLocation.getDistance2D(this.navigNextLocation) + 45.0) {
                    this.log.log(Level.FINE, "We are closer to next target than current, switching to next node, angle: {0}", navigDirection.getNormalized().dot(altDirection));
                    Location lastLocation = this.memory.getLocation();
                    if (!this.switchToNextNode()) {
                        if (this.log != null && this.log.isLoggable(Level.FINE)) {
                            this.log.fine("Navigator.navigToCurrentNode(): switching to direct navigation");
                        }
                        return this.initDirectly(this.navigDestination);
                    }
                    this.navigLastLocation = lastLocation;
                    return this.keepNavigating();
                }
            }
        }
        return this.navigStage;
    }

    private Stage navigThroughMover() {
        boolean moverStandingStill;
        Stage stage = this.navigStage;
        if (this.navigCurrentNode == null) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): can't navigate through the mover without the navpoint instance (navigCurrentNode == null)");
            }
            return Stage.CRASHED;
        }
        Mover mover = (Mover)this.bot.getWorldView().get((WorldObjectId)this.navigCurrentNode.getMover());
        if (mover == null) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): can't navigate through the mover as current node does not represent a mover (moverId == null): " + this.navigCurrentNode);
            }
            return Stage.CRASHED;
        }
        this.navigCurrentLocation = this.navigCurrentNode.getLocation();
        if (this.navigNextNode != null) {
            this.navigNextLocation = this.navigNextNode.getLocation();
        }
        this.log.fine("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): CURR " + this.navigCurrentNode);
        this.log.fine("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): NEXT " + this.navigNextNode);
        int hDistance = (int)this.memory.getLocation().getDistance2D(this.navigCurrentLocation.getLocation());
        int zDistance = (int)this.navigCurrentLocation.getLocation().getDistanceZ(this.memory.getLocation());
        boolean moverRidingUp = mover.getVelocity().z > 0.0;
        boolean moverRidingDown = mover.getVelocity().z < 0.0;
        boolean bl = moverStandingStill = Math.abs(mover.getVelocity().z) < 1.0E-9;
        if (this.navigStage == Stage.AWAITING_MOVER) {
            if (zDistance > 0 && moverRidingUp) {
                if (this.log != null && this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): we are UNDER the mover and mover is RIDING UP ... getting back to waiting position" + ", zDistance " + zDistance + ", mover.velocity.z " + mover.getVelocity().z + ", mover " + (moverRidingUp ? "riding UP" : (moverRidingDown ? "riding DOWN" : (moverStandingStill ? "standing STILL" : " movement unknown"))));
                }
                if (!this.runner.runToLocation(this.memory.getLocation(), this.navigLastLocation, null, (ILocated)this.navigCurrentLocation, null, this.navigLastNode == null ? true : this.isReachable(this.navigLastNode))) {
                    if (this.log != null && this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): navigation to wait-for-mover node failed");
                    }
                    return Stage.CRASHED;
                }
                return this.navigStage;
            }
            if (zDistance > 30 && moverRidingUp) {
                if (this.log != null && this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): waiting for the mover to come" + " | zDistance " + zDistance + ", hDistance " + hDistance + ", mover " + (moverRidingUp ? "riding UP" : (moverRidingDown ? "riding DOWN" : (moverStandingStill ? "standing STILL" : " movement unknown"))) + ", node " + this.navigCurrentNode.getId().getStringId());
                }
                if (!this.runner.runToLocation(this.memory.getLocation(), this.navigLastLocation, null, (ILocated)this.navigCurrentLocation, this.navigCurrentLink, this.navigLastNode == null ? true : this.isReachable(this.navigLastNode))) {
                    if (this.log != null && this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): navigation to last node failed");
                    }
                    return Stage.CRASHED;
                }
                return this.navigStage;
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): mover arrived" + " | zDistance " + zDistance + ", hDistance " + hDistance + ", mover " + (moverRidingUp ? "riding UP" : (moverRidingDown ? "riding DOWN" : (moverStandingStill ? "standing STILL" : " movement unknown"))) + ", node " + this.navigCurrentNode.getId().getStringId());
            }
            return this.navigToCurrentNode(false);
        }
        if (this.navigStage == Stage.RIDING_MOVER) {
            this.checkMoverMovement(mover);
            if (this.navigMoverRideDownCount > 2 || this.navigMoverRideUpCount > 2) {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): navigation to mover exit node failed, we've rided twice up & down and there was no place suitable to exit the mover in order to get to get to " + this.navigCurrentNode);
                }
                return Stage.CRASHED;
            }
            if (hDistance > 400) {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): navigation to mover exit node failed, the node is too far, hDistance " + hDistance + " > 400, unsupported (wiered navigation graph link)");
                }
                return Stage.CRASHED;
            }
            if (Math.abs(zDistance) > 50) {
                if (this.log != null && this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): riding the mover" + " | zDistance " + zDistance + ", hDistance " + hDistance + ", mover " + (moverRidingUp ? "riding UP" : (moverRidingDown ? "riding DOWN" : (moverStandingStill ? "standing STILL" : " movement unknown"))) + ", node " + this.navigCurrentNode.getId().getStringId());
                }
                if (!this.runner.runToLocation(this.memory.getLocation(), this.navigLastLocation, null, (ILocated)this.navigCurrentLocation, this.navigCurrentLink, this.navigLastNode == null ? true : this.isReachable(this.navigLastNode))) {
                    if (this.log != null && this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): navigation to last node failed");
                    }
                    return Stage.CRASHED;
                }
                return this.navigStage;
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): exiting the mover" + " | zDistance " + zDistance + ", hDistance " + hDistance + ", mover " + (moverRidingUp ? "riding UP" : (moverRidingDown ? "riding DOWN" : (moverStandingStill ? "standing STILL" : " movement unknown"))) + ", node " + this.navigCurrentNode.getId().getStringId());
            }
            return this.navigToCurrentNode(false);
        }
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning("Navigator.navigThroughMover(" + (Object)((Object)stage) + "): invalid stage, neither AWAITING_MOVER nor RIDING MOVER");
        }
        return Stage.CRASHED;
    }

    private Stage navigThroughTeleport() {
        ILocated focus;
        Location secondLocation;
        if (this.navigCurrentNode != null) {
            this.navigCurrentLocation = this.navigCurrentNode.getLocation();
        }
        if (this.navigNextNode != null) {
            this.navigNextLocation = this.navigNextNode.getLocation();
        }
        int localDistance1_1 = (int)this.memory.getLocation().getDistance(this.navigCurrentLocation.getLocation());
        int localDistance1_2 = (int)this.memory.getLocation().getDistance(Location.add((Location)this.navigCurrentLocation.getLocation(), (Location)new Location(0.0, 0.0, 100.0)));
        boolean switchedToNextNode = false;
        int localDistance2_1 = Integer.MAX_VALUE;
        int localDistance2_2 = Integer.MAX_VALUE;
        for (NavPointNeighbourLink link : this.navigCurrentNode.getOutgoingEdges().values()) {
            if (!link.getToNavPoint().isTeleporter()) continue;
            localDistance2_1 = (int)this.memory.getLocation().getDistance(link.getToNavPoint().getLocation());
            localDistance2_2 = (int)this.memory.getLocation().getDistance(Location.add((Location)link.getToNavPoint().getLocation(), (Location)new Location(0.0, 0.0, 100.0)));
            if (localDistance2_1 < 200 || localDistance2_2 < 200) {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Navigator.navigThroughTeleport(): at the other end of teleport, switching...");
                }
                if (!this.switchToNextNode()) {
                    if (this.log != null && this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Navigator.navigThroughTeleport(): switch to direct navigation");
                    }
                    return this.initDirectly(this.navigDestination);
                }
                switchedToNextNode = true;
            } else if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "Navigator.navigThroughTeleport(): NOT at the other end of teleport: Distance: {0} Distance2: {1}", new Object[]{localDistance2_1, localDistance2_2});
            }
            if (!switchedToNextNode) continue;
            break;
        }
        Location firstLocation = this.navigCurrentLocation.getLocation();
        Location location = secondLocation = this.navigNextNode != null && !this.navigNextNode.isLiftCenter() && !this.navigNextNode.isLiftCenter() ? this.navigNextNode.getLocation() : this.navigNextLocation;
        Object object = this.focus == null ? (this.navigNextLocation == null ? firstLocation : this.navigNextLocation.getLocation()) : (focus = this.focus);
        if (!this.runner.runToLocation(this.navigLastLocation, firstLocation, secondLocation, focus, this.navigCurrentLink, this.navigCurrentNode == null ? true : this.isReachable(this.navigCurrentNode))) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Navigator.navigThroughTeleport(): navigation to current node failed");
            }
            return Stage.CRASHED;
        }
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Navigator.navigThroughTeleport(): traveling to current node");
        }
        if (!(switchedToNextNode || localDistance1_1 >= 20 && localDistance1_2 >= 20 || this.switchToNextNode())) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Navigator.navigThroughTeleport(): switch to direct navigation");
            }
            return this.initDirectly(this.navigDestination);
        }
        return this.navigStage;
    }

    public NavMeshNavigator(UT2004Bot bot, AgentInfo info, AdvancedLocomotion move, IUT2004PathRunner runner, Logger log) {
        this.main = bot;
        this.memory = info;
        this.body = move;
        this.log = log;
        this.selfListener = new SelfListener((IWorldView)bot.getWorldView());
        this.runner = runner;
        NullCheck.check((Object)this.runner, (String)"runner");
    }

    @Override
    public Logger getLog() {
        return this.log;
    }

    public static enum Stage {
        REACHING{

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        NAVIGATING{

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        AWAITING_MOVER(MoverStageType.WAITING){

            @Override
            protected Stage next() {
                return RIDING_MOVER;
            }
        }
        ,
        RIDING_MOVER(MoverStageType.RIDING){

            @Override
            protected Stage next() {
                return NAVIGATING;
            }
        }
        ,
        CANCELED(TerminatingStageType.FAILURE){

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        TIMEOUT(TerminatingStageType.FAILURE){

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        CRASHED(TerminatingStageType.FAILURE){

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        COMPLETED(TerminatingStageType.SUCCESS){

            @Override
            protected Stage next() {
                return this;
            }
        }
        ,
        TELEPORT(TeleportStageType.GOING_THROUGH){

            @Override
            protected Stage next() {
                return NAVIGATING;
            }
        };

        private boolean mover;
        public boolean terminated;
        public boolean failure;
        public boolean teleport;

        private Stage() {
            this.mover = false;
            this.teleport = false;
            this.terminated = false;
            this.failure = false;
        }

        private Stage(TeleportStageType type) {
            this.mover = false;
            this.teleport = true;
            this.failure = false;
            this.terminated = false;
        }

        private Stage(MoverStageType type) {
            this.mover = true;
            this.teleport = false;
            this.terminated = false;
            this.failure = false;
        }

        private Stage(TerminatingStageType type) {
            this.mover = false;
            this.teleport = false;
            this.terminated = true;
            this.failure = type.failure;
        }

        protected abstract Stage next();

        protected static Stage FirstMoverStage() {
            return AWAITING_MOVER;
        }

        protected static Stage TeleporterStage() {
            return TELEPORT;
        }
    }

    private static enum TeleportStageType {
        GOING_THROUGH;

    }

    private static enum MoverStageType {
        WAITING,
        RIDING;

    }

    private static enum TerminatingStageType {
        SUCCESS(false),
        FAILURE(true);

        public boolean failure;

        private TerminatingStageType(boolean failure) {
            this.failure = failure;
        }
    }

    private class SelfListener
    implements IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> {
        private IWorldView worldView;

        public SelfListener(IWorldView worldView) {
            this.worldView = worldView;
            worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }

        public void notify(WorldObjectUpdatedEvent<Self> event) {
            NavMeshNavigator.this.self = (Self)event.getObject();
        }
    }
}

