/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPrefs;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.utils.NullCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class WeaponPrefsRange {
    private double maxDistance;
    private WeaponPrefs owner;
    private List<WeaponPref> prefs = new ArrayList<WeaponPref>();

    protected WeaponPrefsRange(WeaponPrefs owner, double maxDistance) {
        NullCheck.check((Object)owner, (String)"owner");
        this.owner = owner;
        this.maxDistance = maxDistance;
    }

    public WeaponPrefsRange(WeaponPrefs owner, WeaponPrefsRange prefs) {
        NullCheck.check((Object)prefs, (String)"prefs");
        NullCheck.check((Object)owner, (String)"owner");
        this.prefs.addAll(prefs.prefs);
        this.owner = owner;
        this.maxDistance = prefs.maxDistance;
    }

    public WeaponPrefsRange add(ItemType weapon, boolean usePrimaryMode) {
        NullCheck.check((Object)weapon, (String)"weapon");
        this.prefs.add(new WeaponPref(weapon, usePrimaryMode));
        return this;
    }

    public WeaponPrefsRange add(Weapon weapon, boolean usePrimaryMode) {
        NullCheck.check((Object)weapon, (String)"weapon");
        this.add(weapon.getType(), usePrimaryMode);
        return this;
    }

    public double getMinDistance() {
        WeaponPrefsRange next = this.owner.getPreviousRange(this);
        if (next == null) {
            return 0.0;
        }
        return next.getMaxDistance();
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public WeaponPref getWeaponPreference() {
        return this.getWeaponPreference((ItemType[])null);
    }

    public WeaponPref getWeaponPreference(ItemType ... forbiddenWeapons) {
        List<Object> forbidden = forbiddenWeapons == null ? new ArrayList(0) : Arrays.asList(forbiddenWeapons);
        for (WeaponPref pref : this.prefs) {
            if (forbidden.contains(pref.getWeapon()) || !(pref.isPrimary() ? this.owner.weaponry.hasPrimaryLoadedWeapon(pref.getWeapon()) : this.owner.weaponry.hasSecondaryLoadedWeapon(pref.getWeapon()))) continue;
            return pref;
        }
        return null;
    }

    public WeaponPref getWeaponPreference(WeaponPref ... forbiddenWeapons) {
        HashSet<WeaponPref> forbidden = new HashSet<WeaponPref>();
        if (forbiddenWeapons != null) {
            for (WeaponPref pref : forbiddenWeapons) {
                forbidden.add(pref);
            }
        }
        for (WeaponPref pref : this.prefs) {
            if (forbidden.contains(pref) || !(pref.isPrimary() ? this.owner.weaponry.hasPrimaryLoadedWeapon(pref.getWeapon()) : this.owner.weaponry.hasSecondaryLoadedWeapon(pref.getWeapon()))) continue;
            return pref;
        }
        return null;
    }

    public void clear() {
        this.prefs.clear();
    }

    public List<WeaponPref> getPrefs() {
        return this.prefs;
    }

    public void setPrefs(List<WeaponPref> prefs) {
        this.prefs = prefs;
    }

    public WeaponPrefs getOwner() {
        return this.owner;
    }
}

