package cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages;
 		
 		// --- IMPORTS FROM /messages/settings/javasettings/javaimport BEGIN
			import java.util.*;import javax.vecmath.*;import cz.cuni.amis.pogamut.base.communication.messages.*;import cz.cuni.amis.pogamut.base.communication.worldview.*;import cz.cuni.amis.pogamut.base.communication.worldview.event.*;import cz.cuni.amis.pogamut.base.communication.worldview.object.*;import cz.cuni.amis.pogamut.multi.communication.worldview.object.*;import cz.cuni.amis.pogamut.base.communication.translator.event.*;import cz.cuni.amis.pogamut.multi.communication.translator.event.*;import cz.cuni.amis.pogamut.base3d.worldview.object.*;import cz.cuni.amis.pogamut.base3d.worldview.object.event.*;import cz.cuni.amis.pogamut.ut2004.communication.messages.*;import cz.cuni.amis.pogamut.ut2004.communication.worldview.objects.*;import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.objects.*;import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.*;import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType.Category;import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;import cz.cuni.amis.utils.exception.*;import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult.Result;import cz.cuni.amis.utils.SafeEquals;import cz.cuni.amis.pogamut.base.agent.*;import cz.cuni.amis.pogamut.multi.agent.*;import cz.cuni.amis.pogamut.multi.communication.worldview.property.*;import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.property.*;import cz.cuni.amis.utils.token.*;import cz.cuni.amis.utils.*;
		// --- IMPORTS FROM /messages/settings/javasettings/javaimport END
		
		
		// --- IMPORTS FROM extra/code/java/javapart/classcategory[@name='all'] BEGIN
				
		// --- IMPORTS FROM extra/code/java/javapart/classcategory[@name='all'] END
		
		// --- IMPORTS FROM extra/code/java/javapart/classcategory[@name=local]+classtype[@name=impl] BEGIN
		
		// --- IMPORTS FROM extra/code/java/javapart/classcategory[@name=local]+classtype[@name=impl] END
    
 		/**
         *  
            				Implementation of the local part of the GameBots2004 message UPD.  
            			
         *
         *  <p></p><p></p>
         *  Complete message documentation:               
         *  
		"Synchronous" message. Arrives outside sync. batch. The frequency of this message is configured through locUpdateMultiplier variable in GameBots2004.ini file. It gets exported N times faster than regular sync. batch where N equals locUpdateMultiplier. Holds information about Location, Velocity and Rotation of the bot and should help us to create more robust navigation.
	
         */
 	public class LocationUpdateLocalImpl 
  						extends
  						LocationUpdateLocal
	    {
 	
    	
    	
    	/**
    	 * Parameter-less contructor for the message.
    	 */
		public LocationUpdateLocalImpl()
		{
		}
	
    	
    	
    	
    	/**
		 * Creates new instance of the message LocationUpdate.
		 * 
		"Synchronous" message. Arrives outside sync. batch. The frequency of this message is configured through locUpdateMultiplier variable in GameBots2004.ini file. It gets exported N times faster than regular sync. batch where N equals locUpdateMultiplier. Holds information about Location, Velocity and Rotation of the bot and should help us to create more robust navigation.
	
		 * Corresponding GameBots message
		 *   (local part)
		 *   is
		 *   UPD.
		 * 
 	  	 * 
		 *   
		 *     @param Id Unique Id of this update message instance.
		 *   
		 * 
		 *   
		 *     @param Loc 
			An absolute location of the bot.
		
		 *   
		 * 
		 *   
		 *     @param Vel 
			Absolute velocity of the bot as a vector of movement per one
			game second.
		
		 *   
		 * 
		 *   
		 *     @param Rot 
			Which direction the bot is facing in absolute terms.
		
		 *   
		 * 
		 */
		public LocationUpdateLocalImpl(
			UnrealId Id,  Location Loc,  Velocity Vel,  Rotation Rot
		) {
			
					this.Id = Id;
				
					this.Loc = Loc;
				
					this.Vel = Vel;
				
					this.Rot = Rot;
				
		}
    
    	/**
		 * Cloning constructor from the full message.
		 *
		 * @param original
		 */
		public LocationUpdateLocalImpl(LocationUpdate original) {		
			
					this.Id = original.getId()
 	;
				
					this.Loc = original.getLoc()
 	;
				
					this.Vel = original.getVel()
 	;
				
					this.Rot = original.getRot()
 	;
				
			this.SimTime = original.getSimTime();			
		}
		
		/**
		 * Cloning constructor from the full message.
		 *
		 * @param original
		 */
		public LocationUpdateLocalImpl(LocationUpdateLocalImpl original) {		
			
					this.Id = original.getId()
 	;
				
					this.Loc = original.getLoc()
 	;
				
					this.Vel = original.getVel()
 	;
				
					this.Rot = original.getRot()
 	;
				
			this.SimTime = original.getSimTime();
		}
		
			/**
			 * Cloning constructor from the message part.
			 *
			 * @param original
			 */
			public LocationUpdateLocalImpl(LocationUpdateLocal original) {
				
						this.Id = original.getId()
 	;
					
						this.Loc = original.getLoc()
 	;
					
						this.Vel = original.getVel()
 	;
					
						this.Rot = original.getRot()
 	;
					
			}
		
   				
   				@Override
   				public void setSimTime(long SimTime) {
					super.setSimTime(SimTime);
				}
   			
	    				@Override
	    				public 
	    				LocationUpdateLocalImpl clone() {
	    					return new 
	    					LocationUpdateLocalImpl(this);
	    				}
	    				
	    				
    	
	    /**
         * Unique Id of this update message instance. 
         */
        protected
         UnrealId Id =
       	null;
	
 		/**
         * Unique Id of this update message instance. 
         */
        public  UnrealId getId()
 	 {
				    					return Id;
				    				}
				    			
    	
	    /**
         * 
			An absolute location of the bot.
		 
         */
        protected
         Location Loc =
       	null;
	
 		/**
         * 
			An absolute location of the bot.
		 
         */
        public  Location getLoc()
 	 {
				    					return Loc;
				    				}
				    			
    	
	    /**
         * 
			Absolute velocity of the bot as a vector of movement per one
			game second.
		 
         */
        protected
         Velocity Vel =
       	null;
	
 		/**
         * 
			Absolute velocity of the bot as a vector of movement per one
			game second.
		 
         */
        public  Velocity getVel()
 	 {
				    					return Vel;
				    				}
				    			
    	
	    /**
         * 
			Which direction the bot is facing in absolute terms.
		 
         */
        protected
         Rotation Rot =
       	null;
	
 		/**
         * 
			Which direction the bot is facing in absolute terms.
		 
         */
        public  Rotation getRot()
 	 {
				    					return Rot;
				    				}
				    			
    	
    	
    	
    	
    	public LocationUpdateLocalImpl getLocal() {
			return this;
    	}
		public ISharedWorldObject getShared() {
		 	throw new UnsupportedOperationException("Could not return LOCAL as SHARED");
		}
		public IStaticWorldObject getStatic() {
		    throw new UnsupportedOperationException("Could not return LOCAL as STATIC");
		}
 	
		public static class LocationUpdateLocalUpdate
     implements ILocalWorldObjectUpdatedEvent, IGBWorldObjectEvent
		{
			protected long time;
			
			protected LocationUpdateLocal data = null; //contains object data for this update
			
			public LocationUpdateLocalUpdate
    (LocationUpdateLocal moverLocal, long time)
			{
				this.data = moverLocal;
				this.time = time;
			}
			
			@Override
			public IWorldObjectUpdateResult<ILocalWorldObject> update(
					ILocalWorldObject object) 
			{
				if ( object == null)
				{
					data = new LocationUpdateLocalImpl(data); //we always return Impl object
					return new IWorldObjectUpdateResult.WorldObjectUpdateResult<ILocalWorldObject>(IWorldObjectUpdateResult.Result.CREATED, data);
				}
				if ( object instanceof LocationUpdateLocalImpl )
				{
					LocationUpdateLocalImpl toUpdate = (LocationUpdateLocalImpl)object;
					
					boolean updated = false;
					
					// UPDATING LOCAL PROPERTIES
					
	            if (!SafeEquals.equals(toUpdate.Loc, data.getLoc()
 	)) {
					toUpdate.Loc=data.getLoc()
 	;
					updated = true;
				}
			
				if (!SafeEquals.equals(toUpdate.Vel, data.getVel()
 	)) {
					toUpdate.Vel=data.getVel()
 	;
					updated = true;
				}
			
				if (!SafeEquals.equals(toUpdate.Rot, data.getRot()
 	)) {
					toUpdate.Rot=data.getRot()
 	;
					updated = true;
				}
			
					
					data = toUpdate; //the updating has finished
					
					if ( updated )
					{
						toUpdate.SimTime = this.time;
						return new IWorldObjectUpdateResult.WorldObjectUpdateResult<ILocalWorldObject>(IWorldObjectUpdateResult.Result.UPDATED, data);
					}
					
					return new IWorldObjectUpdateResult.WorldObjectUpdateResult<ILocalWorldObject>(IWorldObjectUpdateResult.Result.SAME, data);
				}
				throw new PogamutException("Unsupported object type for update. Expected LocationUpdateLocalImpl for object " + object.getId() +", not object of class " + object.getClass().getSimpleName() + ".", this);
			}
	
			/**
			 * Simulation time in MILLI SECONDS !!!
			 */
			@Override
			public long getSimTime() {
				return this.time;
			}
	
			@Override
			public IWorldObject getObject() {
				return data;
			}
	
			@Override
			public WorldObjectId getId() {
				return data.getId();
			}
			
		}	
 	
 		
 	    public String toString() {
            return
            	super.toString() + "[" +
            	
		              			"Id = " + String.valueOf(getId()
 	) + " | " + 
		              		
		              			"Loc = " + String.valueOf(getLoc()
 	) + " | " + 
		              		
		              			"Vel = " + String.valueOf(getVel()
 	) + " | " + 
		              		
		              			"Rot = " + String.valueOf(getRot()
 	) + " | " + 
		              		
				"]";           		
        }
 	
 		
 		public String toHtmlString() {
 			return super.toString() + "[<br/>" +
            	
		              			"<b>Id</b> = " + String.valueOf(getId()
 	) + " <br/> " + 
		              		
		              			"<b>Loc</b> = " + String.valueOf(getLoc()
 	) + " <br/> " + 
		              		
		              			"<b>Vel</b> = " + String.valueOf(getVel()
 	) + " <br/> " + 
		              		
		              			"<b>Rot</b> = " + String.valueOf(getRot()
 	) + " <br/> " + 
		              		
				"<br/>]";     
		}
 	
 		
 		// --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=all]) ---
        	
		// --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=all]) ---
		
	    // --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=local+classtype[@name=impl]) ---
	        
	    // --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=local+classtype[@name=impl]) ---        	            	
 	
		}
 	