/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.utils;

import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.utils.runner.impl.AgentRunner;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004BotController;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotModule;
import cz.cuni.amis.pogamut.ut2004.utils.PogamutUT2004Property;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.List;

public class UT2004BotRunner<BOT extends IUT2004Bot, PARAMS extends UT2004BotParameters>
extends AgentRunner<BOT, PARAMS> {
    protected String host;
    protected int port;
    protected String name;

    public UT2004BotRunner(IAgentFactory<BOT, PARAMS> factory, String name, String host, int port) {
        super(factory);
        this.name = name;
        this.port = port;
        this.host = host;
    }

    public UT2004BotRunner(IAgentFactory<BOT, PARAMS> factory, String name) {
        this(factory, name, Pogamut.getPlatform().getProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_HOST.getKey()) == null ? "localhost" : Pogamut.getPlatform().getProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_HOST.getKey()), Pogamut.getPlatform().getIntProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_PORT.getKey()) == 0 ? 3000 : Pogamut.getPlatform().getIntProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_PORT.getKey()));
    }

    public UT2004BotRunner(IAgentFactory<BOT, PARAMS> factory) {
        this(factory, "UT2004Bot");
    }

    public UT2004BotRunner(UT2004BotModule module, String name, String host, int port) {
        this((IAgentFactory<BOT, PARAMS>)new UT2004BotFactory(module), name, host, port);
    }

    public UT2004BotRunner(UT2004BotModule module, String name) {
        this(module, name, Pogamut.getPlatform().getProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_HOST.getKey()), Pogamut.getPlatform().getIntProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_PORT.getKey()));
    }

    public UT2004BotRunner(UT2004BotModule module) {
        this(module, "UT2004Bot");
    }

    public UT2004BotRunner(Class<? extends IUT2004BotController> botControllerClass, String name, String host, int port) {
        this(new UT2004BotModule(botControllerClass), name, host, port);
    }

    public UT2004BotRunner(Class<? extends IUT2004BotController> botControllerClass, String name) {
        this(new UT2004BotModule(botControllerClass), name, Pogamut.getPlatform().getProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_HOST.getKey()), Pogamut.getPlatform().getIntProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_PORT.getKey()));
    }

    public UT2004BotRunner(Class<? extends IUT2004BotController> botControllerClass) {
        this(new UT2004BotModule(botControllerClass), "UT2004Bot");
    }

    public BOT startAgent() throws PogamutException {
        return (BOT)((IUT2004Bot)super.startAgent());
    }

    public List<BOT> startAgents(int count) throws PogamutException {
        return super.startAgents(count);
    }

    public List<BOT> startAgents(PARAMS ... agentParameters) throws PogamutException {
        return super.startAgents(agentParameters);
    }

    public String getName() {
        return this.name;
    }

    public UT2004BotRunner<BOT, PARAMS> setName(String name) {
        if (name == null) {
            name = "UT2004Bot";
        }
        this.name = name;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public UT2004BotRunner<BOT, PARAMS> setHost(String host) {
        this.host = host;
        NullCheck.check((Object)this.host, (String)"host");
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public UT2004BotRunner<BOT, PARAMS> setPort(int port) {
        this.port = port;
        return this;
    }

    protected IAgentParameters newDefaultAgentParameters() {
        return new UT2004BotParameters().setAgentId(this.newAgentId(this.name)).setWorldAddress((IWorldConnectionAddress)new SocketConnectionAddress(this.host, this.port));
    }

    public UT2004BotRunner<BOT, PARAMS> setMain(boolean state) {
        super.setMain(state);
        return this;
    }

    public UT2004BotRunner<BOT, PARAMS> setConsoleLogging(boolean enabled) {
        super.setConsoleLogging(enabled);
        return this;
    }
}

