/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector;

import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004DistanceStuckDetector
implements IStuckDetector {
    private UT2004Bot bot;
    private Location botTarget;
    private boolean botWaiting = false;
    private int historyLength;
    private List<Location> positionHistory;
    private List<Double> distanceHistory;
    private Boolean closing;
    private Boolean distancing;
    private int closingCount = 0;
    private int distancingCount = 0;
    private boolean stuck = false;
    private boolean enabled = false;
    private int totalClosingCountMoreThanOne = 0;
    private int totalDistancingCountMoreThanOne = 0;
    private SelfListener selfListener;
    private Logger log;
    private double minMovementZ;

    public UT2004DistanceStuckDetector(UT2004Bot bot) {
        if (this.log == null) {
            this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        }
        this.bot = bot;
        this.selfListener = new SelfListener((IWorldView)bot.getWorldView());
        this.historyLength = 2;
        if (this.historyLength < 0) {
            throw new IllegalArgumentException("historyLength can't be < 0");
        }
        this.distanceHistory = new ArrayList<Double>(this.historyLength);
        this.positionHistory = new ArrayList<Location>(this.historyLength);
    }

    public void setEnabled(boolean state) {
        if (this.enabled == state) {
            return;
        }
        this.enabled = state;
    }

    public void setBotWaiting(boolean state) {
        this.botWaiting = state;
        if (this.botWaiting) {
            Location botTarget = this.botTarget;
            this.reset();
            this.botTarget = botTarget;
        }
    }

    public void setBotTarget(ILocated target) {
        if (this.botTarget != null) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("TARGET APPROACHING STUCK DETECTOR - previous stats:");
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("  Closing count:              " + this.closingCount);
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("  Distancing count:           " + this.distancingCount);
            }
            if (this.closingCount > 1) {
                ++this.totalClosingCountMoreThanOne;
            }
            if (this.distancingCount > 1) {
                ++this.totalDistancingCountMoreThanOne;
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("  Total closing count > 1:    " + this.totalClosingCountMoreThanOne);
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("  Total distancing count > 1: " + this.totalDistancingCountMoreThanOne);
            }
        }
        boolean botWaiting = this.botWaiting;
        this.reset();
        this.botWaiting = botWaiting;
        this.botTarget = target == null || target instanceof Player ? null : target.getLocation();
        if (this.botTarget == null) {
            this.stuck = false;
        }
    }

    public void eventSelf(IWorldObjectEvent<Self> event) {
        boolean currentDistancing;
        if (!this.enabled) {
            return;
        }
        if (this.botWaiting) {
            return;
        }
        if (this.botTarget == null) {
            return;
        }
        Location currentLocation = ((Self)event.getObject()).getLocation();
        double currentDistance = currentLocation.getDistance(this.botTarget);
        this.positionHistory.add(currentLocation);
        this.distanceHistory.add(currentDistance);
        if (this.positionHistory.size() == 1) {
            return;
        }
        Location previousLocation = this.positionHistory.get(this.positionHistory.size() - 2);
        double previousDistance = this.distanceHistory.get(this.distanceHistory.size() - 2);
        boolean currentClosing = currentDistance < previousDistance;
        boolean bl = currentDistancing = !currentClosing;
        if (this.closing == null) {
            this.closing = currentClosing;
            this.distancing = currentDistancing;
            this.closingCount = this.closing != false ? 1 : 0;
            this.distancingCount = this.distancing != false ? 1 : 0;
            return;
        }
        boolean previousClosing = this.closing;
        boolean previousDistancing = this.distancing;
        this.closing = currentClosing;
        this.distancing = currentDistancing;
        if (currentClosing) {
            if (!previousClosing) {
                ++this.closingCount;
            }
        } else if (!previousDistancing) {
            ++this.distancingCount;
            if (this.distancingCount > 1) {
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info("Bot stuck detected, #closing " + this.closingCount + ", #distancing " + this.distancingCount);
                }
                this.stuck = true;
            }
        }
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("TARGET APPROACHING STUCK DETECTOR");
        }
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("  Current distance:    " + currentDistance);
        }
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("  Current closing:     " + currentClosing);
        }
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("  Current distancing:  " + currentDistancing);
        }
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("  Previous closing:    " + previousClosing);
        }
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("  Previous distancing: " + previousDistancing);
        }
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("  Closing count:       " + this.closingCount);
        }
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("  Distancing count:    " + this.distancingCount);
        }
    }

    public boolean isStuck() {
        return this.stuck;
    }

    public void reset() {
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("Reset.");
        }
        this.distanceHistory.clear();
        this.positionHistory.clear();
        this.closing = null;
        this.distancing = null;
        this.closingCount = 0;
        this.distancingCount = 0;
        this.stuck = false;
        this.botTarget = null;
        this.botWaiting = false;
    }

    private class SelfListener
    implements IWorldObjectListener<Self> {
        public SelfListener(IWorldView worldView) {
            worldView.addObjectListener(Self.class, (IWorldObjectEventListener)this);
        }

        public void notify(IWorldObjectEvent<Self> event) {
            UT2004DistanceStuckDetector.this.eventSelf(event);
        }
    }
}

