/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector;

import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004TimeStuckDetector
implements IStuckDetector {
    private static final double NO_MOVEMENT_SIZE = 10.0;
    private static int DEFAULT_TIMEOUT = 3000;
    private static int DEFAULT_WAITING_TIMEOUT = 10000;
    private UT2004Bot bot;
    private double timeout;
    private double waitingTimeout;
    private boolean botWaiting = false;
    private boolean bWasIsStuckCalled = false;
    private long currentTime;
    private SelfListener selfListener;
    private Double lastMovementTime = null;
    private boolean stuck = false;
    private Logger log;

    public UT2004TimeStuckDetector(UT2004Bot bot) {
        this(bot, DEFAULT_TIMEOUT, DEFAULT_WAITING_TIMEOUT);
    }

    public UT2004TimeStuckDetector(UT2004Bot bot, double timeoutMillis, double waitingTimeoutMillis) {
        if (this.log == null) {
            this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        }
        this.bot = bot;
        this.timeout = timeoutMillis;
        this.waitingTimeout = waitingTimeoutMillis;
        this.selfListener = new SelfListener((IWorldView)bot.getWorldView());
    }

    public void eventSelf(IWorldObjectEvent<Self> event) {
        this.currentTime = ((Self)event.getObject()).getSimTime();
        if (!this.bWasIsStuckCalled) {
            return;
        }
        if (((Self)event.getObject()).getVelocity().size() > 10.0 || this.lastMovementTime == null) {
            this.lastMovementTime = ((Self)event.getObject()).getSimTime();
        }
        if (this.botWaiting) {
            if ((double)((Self)event.getObject()).getSimTime() - this.lastMovementTime >= this.waitingTimeout) {
                this.stuck = true;
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info("Bot is WAITING for more than " + this.waitingTimeout + " ms, considering that it has stuck.");
                }
            }
        } else if ((double)((Self)event.getObject()).getSimTime() - this.lastMovementTime >= this.timeout) {
            this.stuck = true;
            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                this.log.info("Bot should be moving but it is standing still for more than " + this.timeout + " ms, considering that it has stuck.");
            }
        }
    }

    public void setBotWaiting(boolean state) {
        this.botWaiting = state;
        this.lastMovementTime = null;
    }

    public boolean isStuck() {
        if (!this.bWasIsStuckCalled) {
            this.lastMovementTime = this.currentTime;
            this.bWasIsStuckCalled = true;
            return false;
        }
        return this.stuck;
    }

    public void reset() {
        this.lastMovementTime = Double.NEGATIVE_INFINITY;
        this.bWasIsStuckCalled = false;
        this.stuck = false;
    }

    public void setBotTarget(ILocated target) {
    }

    private class SelfListener
    implements IWorldObjectListener<Self> {
        public SelfListener(IWorldView worldView) {
            worldView.addObjectListener(Self.class, (IWorldObjectEventListener)this);
        }

        public void notify(IWorldObjectEvent<Self> event) {
            UT2004TimeStuckDetector.this.eventSelf(event);
        }
    }
}

