package cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.converter;

import org.junit.Assert;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.WorldViewTestContext;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.InputEventWrapper;

public class InputEventWrapperConverter implements Converter {

	private WorldViewTestContext ctx;

	public InputEventWrapperConverter(WorldViewTestContext ctx) {
		this.ctx = ctx;
	}

	@Override
	public void marshal(Object value, HierarchicalStreamWriter writer,
			MarshallingContext context) {
		
		InputEventWrapper wrapper = (InputEventWrapper)value;
		
		writer.addAttribute("raiseTimes", Integer.toString(wrapper.getRaiseTimes()));
		
		writer.startNode("Wrapper");
		writer.addAttribute("class", wrapper.getEvent().getClass().getName());
		context.convertAnother(wrapper.getEvent());		
		writer.endNode();
	}

	@Override
	public Object unmarshal(HierarchicalStreamReader reader,
			UnmarshallingContext context) {

		int raiseTimes = Integer.parseInt(reader.getAttribute("raiseTimes"));		
		
		reader.moveDown();				
		
		IWorldChangeEvent event;
		try {
			event = (IWorldChangeEvent) context.convertAnother(this,
					Class.forName(reader.getAttribute("class")));
			
			reader.moveUp();
			
			InputEventWrapper wrapper = new InputEventWrapper(event, raiseTimes);
			
			return wrapper;
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			Assert.fail("Invalid class encountered as an InputEvent in InputEventWrapper. In " +
					reader.getNodeName());
			
			return null;
		}		
				
	}

	@SuppressWarnings("unchecked")
	@Override
	public boolean canConvert(Class clazz) {
		return InputEventWrapper.class.isAssignableFrom(clazz);
	}

}
