package cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages;
 		
 		// --- IMPORTS FROM /messages/settings/javasettings/javaimport BEGIN
			import java.util.*;import javax.vecmath.*;import cz.cuni.amis.pogamut.base.communication.messages.*;import cz.cuni.amis.pogamut.base.communication.worldview.*;import cz.cuni.amis.pogamut.base.communication.worldview.event.*;import cz.cuni.amis.pogamut.base.communication.worldview.object.*;import cz.cuni.amis.pogamut.multi.communication.worldview.object.*;import cz.cuni.amis.pogamut.base.communication.translator.event.*;import cz.cuni.amis.pogamut.multi.communication.translator.event.*;import cz.cuni.amis.pogamut.base3d.worldview.object.*;import cz.cuni.amis.pogamut.base3d.worldview.object.event.*;import cz.cuni.amis.pogamut.ut2004.communication.messages.*;import cz.cuni.amis.pogamut.ut2004.communication.worldview.objects.*;import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.objects.*;import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.*;import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType.Category;import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;import cz.cuni.amis.utils.exception.*;import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult.Result;import cz.cuni.amis.utils.SafeEquals;import cz.cuni.amis.pogamut.base.agent.*;import cz.cuni.amis.pogamut.multi.agent.*;import cz.cuni.amis.pogamut.multi.communication.worldview.property.*;import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.property.*;import cz.cuni.amis.utils.token.*;import cz.cuni.amis.utils.*;
		// --- IMPORTS FROM /messages/settings/javasettings/javaimport END
		
		
		// --- IMPORTS FROM extra/code/java/javapart/classcategory[@name='all'] BEGIN
				
		// --- IMPORTS FROM extra/code/java/javapart/classcategory[@name='all'] END
		
		// --- IMPORTS FROM extra/code/java/javapart/classcategory[@name=base]+classtype[@name=message] BEGIN
		
		// --- IMPORTS FROM extra/code/java/javapart/classcategory[@name=base]+classtype[@name=message] END
    
 		/**
         *  
             				Implementation of the GameBots2004 message PRJ contains also its Local/Shared/Static subpart class definitions..  
            			
         *
         *  <p></p><p></p>
         *  Complete message documentation:               
         *  
		Both asynchronous and synchronous message. Incoming projectile that we can see.
	
         */
 	public class IncomingProjectileMessage   
  				extends 
  				IncomingProjectile
  						implements IWorldObjectUpdatedEvent
  						
	    {
 	
    	
    	
    	/**
    	 * Parameter-less contructor for the message.
    	 */
		public IncomingProjectileMessage()
		{
		}
	
    	
    	
    	
    	/**
		 * Creates new instance of the message IncomingProjectile.
		 * 
		Both asynchronous and synchronous message. Incoming projectile that we can see.
	
		 * Corresponding GameBots message
		 *   
		 *   is
		 *   PRJ.
		 * 
 	  	 * 
		 *   
		 *     @param Id Unique Id of the projectile.
		 *   
		 * 
		 *   
		 *     @param ImpactTime Estimated time till impact.
		 *   
		 * 
		 *   
		 *     @param Direction 
			Which direction projectile is heading to -> orientation
			vector.
		
		 *   
		 * 
		 *   
		 *     @param Location 
			Current location of the projectile.
		
		 *   
		 * 
		 *   
		 *     @param Velocity 
			Current velocity vector of the projectile.
		
		 *   
		 * 
		 *   
		 *     @param Speed 
			Current speed of the projectile.
		
		 *   
		 * 
		 *   
		 *     @param Origin 
			Possition of the origin, when combined with direction can
			define the line of fire.
		
		 *   
		 * 
		 *   
		 *     @param DamageRadius 
			If the projectile has splash damage, how big it is – in ut
			units.
		
		 *   
		 * 
		 *   
		 *     @param Type 
			The class of the projectile (so you know what is flying
			against you).
		
		 *   
		 * 
		 */
		public IncomingProjectileMessage(
			UnrealId Id,  double ImpactTime,  Vector3d Direction,  Location Location,  Velocity Velocity,  double Speed,  Location Origin,  double DamageRadius,  String Type
		) {
			
					this.Id = Id;
				
					this.ImpactTime = ImpactTime;
				
					this.Direction = Direction;
				
					this.Location = Location;
				
					this.Velocity = Velocity;
				
					this.Speed = Speed;
				
					this.Origin = Origin;
				
					this.DamageRadius = DamageRadius;
				
					this.Type = Type;
				
		}
    
		/**
		 * Cloning constructor from the full message.
		 *
		 * @param original
		 */
		public IncomingProjectileMessage(IncomingProjectileMessage original) {		
			
					this.Id = original.getId()
 	;
				
					this.ImpactTime = original.getImpactTime()
 	;
				
					this.Direction = original.getDirection()
 	;
				
					this.Location = original.getLocation()
 	;
				
					this.Velocity = original.getVelocity()
 	;
				
					this.Speed = original.getSpeed()
 	;
				
					this.Origin = original.getOrigin()
 	;
				
					this.DamageRadius = original.getDamageRadius()
 	;
				
					this.Type = original.getType()
 	;
				
				this.TeamId = original.getTeamId();
			
			this.SimTime = original.getSimTime();
		}
		
    				
    					protected ITeamId TeamId;
    					
    					/**
    					 * Used by Yylex to slip corretn TeamId.
    					 */
    					protected void setTeamId(ITeamId TeamId) {
    					    this.TeamId = TeamId;
    					}
    				
    					public ITeamId getTeamId() {
							return TeamId;
						}
    	
    					
    					
    	
	    /**
         * Unique Id of the projectile. 
         */
        protected
         UnrealId Id =
       	null;
	
    						@Override
		    				
 		/**
         * Unique Id of the projectile. 
         */
        public  UnrealId getId()
 	 {
		    					return Id;
		    				}
		    			
    	
	    /**
         * Estimated time till impact. 
         */
        protected
         double ImpactTime =
       	0;
	
    						@Override
		    				
 		/**
         * Estimated time till impact. 
         */
        public  double getImpactTime()
 	 {
		    					return ImpactTime;
		    				}
		    			
    	
	    /**
         * 
			Which direction projectile is heading to -> orientation
			vector.
		 
         */
        protected
         Vector3d Direction =
       	null;
	
    						@Override
		    				
 		/**
         * 
			Which direction projectile is heading to -> orientation
			vector.
		 
         */
        public  Vector3d getDirection()
 	 {
		    					return Direction;
		    				}
		    			
    	
	    /**
         * 
			Current location of the projectile.
		 
         */
        protected
         Location Location =
       	null;
	
    						@Override
		    				
 		/**
         * 
			Current location of the projectile.
		 
         */
        public  Location getLocation()
 	 {
		    					return Location;
		    				}
		    			
    	
	    /**
         * 
			Current velocity vector of the projectile.
		 
         */
        protected
         Velocity Velocity =
       	null;
	
    						@Override
		    				
 		/**
         * 
			Current velocity vector of the projectile.
		 
         */
        public  Velocity getVelocity()
 	 {
		    					return Velocity;
		    				}
		    			
    	
	    /**
         * 
			Current speed of the projectile.
		 
         */
        protected
         double Speed =
       	0;
	
    						@Override
		    				
 		/**
         * 
			Current speed of the projectile.
		 
         */
        public  double getSpeed()
 	 {
		    					return Speed;
		    				}
		    			
    	
	    /**
         * 
			Possition of the origin, when combined with direction can
			define the line of fire.
		 
         */
        protected
         Location Origin =
       	null;
	
    						@Override
		    				
 		/**
         * 
			Possition of the origin, when combined with direction can
			define the line of fire.
		 
         */
        public  Location getOrigin()
 	 {
		    					return Origin;
		    				}
		    			
    	
	    /**
         * 
			If the projectile has splash damage, how big it is – in ut
			units.
		 
         */
        protected
         double DamageRadius =
       	0;
	
    						@Override
		    				
 		/**
         * 
			If the projectile has splash damage, how big it is – in ut
			units.
		 
         */
        public  double getDamageRadius()
 	 {
		    					return DamageRadius;
		    				}
		    			
    	
	    /**
         * 
			The class of the projectile (so you know what is flying
			against you).
		 
         */
        protected
         String Type =
       	null;
	
    						@Override
		    				
 		/**
         * 
			The class of the projectile (so you know what is flying
			against you).
		 
         */
        public  String getType()
 	 {
		    					return Type;
		    				}
		    			
		    			
		    			private IncomingProjectileLocal localPart = null;
		    			
		    			@Override
						public IncomingProjectileLocal 
						getLocal() {
							if (localPart != null) return localPart;
							return localPart = new 
								IncomingProjectileLocalMessage();
						}
					
						private IncomingProjectileShared sharedPart = null;
					
						@Override
						public IncomingProjectileShared 
						getShared() {
							if (sharedPart != null) return sharedPart;							
							return sharedPart = new 
								IncomingProjectileSharedMessage();
						}
					
						private IncomingProjectileStatic staticPart = null; 
					
						@Override
						public IncomingProjectileStatic 
						getStatic() {
							if (staticPart != null) return staticPart;
							return staticPart = new 
								IncomingProjectileStaticMessage();
						}
    				
 		/**
         *  
            				Implementation of the local part of the GameBots2004 message PRJ, used
            				to facade PRJMessage.  
            			
         *
         *  <p></p><p></p>
         *  Complete message documentation:               
         *  
		Both asynchronous and synchronous message. Incoming projectile that we can see.
	
         */
 	public class IncomingProjectileLocalMessage 
	  					extends
  						IncomingProjectileLocal
	    {
 	
		    			@Override
		    			public 
		    			IncomingProjectileLocalMessage clone() {
		    				return this;
		    			}
		    			
		    				public IncomingProjectileLocalMessage getLocal() {
								return this;
					    	}
							public ISharedWorldObject getShared() {
							 	throw new UnsupportedOperationException("Could not return LOCAL as SHARED");
							}
							public IStaticWorldObject getStatic() {
							    throw new UnsupportedOperationException("Could not return LOCAL as STATIC");
							}
		    			
 		/**
         * Unique Id of the projectile. 
         */
        public  UnrealId getId()
 	 {
				    					return Id;
				    				}
				    			
 		/**
         * Estimated time till impact. 
         */
        public  double getImpactTime()
 	 {
				    					return ImpactTime;
				    				}
				    			
 		/**
         * 
			Which direction projectile is heading to -> orientation
			vector.
		 
         */
        public  Vector3d getDirection()
 	 {
				    					return Direction;
				    				}
				    			
 		/**
         * 
			Current location of the projectile.
		 
         */
        public  Location getLocation()
 	 {
				    					return Location;
				    				}
				    			
 		/**
         * 
			Current velocity vector of the projectile.
		 
         */
        public  Velocity getVelocity()
 	 {
				    					return Velocity;
				    				}
				    			
 		/**
         * 
			Current speed of the projectile.
		 
         */
        public  double getSpeed()
 	 {
				    					return Speed;
				    				}
				    			
 		/**
         * 
			Possition of the origin, when combined with direction can
			define the line of fire.
		 
         */
        public  Location getOrigin()
 	 {
				    					return Origin;
				    				}
				    			
 		/**
         * 
			If the projectile has splash damage, how big it is – in ut
			units.
		 
         */
        public  double getDamageRadius()
 	 {
				    					return DamageRadius;
				    				}
				    			
 		/**
         * 
			The class of the projectile (so you know what is flying
			against you).
		 
         */
        public  String getType()
 	 {
				    					return Type;
				    				}
				    			
 		
 	    public String toString() {
            return
            	super.toString() + "[" +
            	
		              			"Id = " + String.valueOf(getId()
 	) + " | " + 
		              		
		              			"ImpactTime = " + String.valueOf(getImpactTime()
 	) + " | " + 
		              		
		              			"Direction = " + String.valueOf(getDirection()
 	) + " | " + 
		              		
		              			"Location = " + String.valueOf(getLocation()
 	) + " | " + 
		              		
		              			"Velocity = " + String.valueOf(getVelocity()
 	) + " | " + 
		              		
		              			"Speed = " + String.valueOf(getSpeed()
 	) + " | " + 
		              		
		              			"Origin = " + String.valueOf(getOrigin()
 	) + " | " + 
		              		
		              			"DamageRadius = " + String.valueOf(getDamageRadius()
 	) + " | " + 
		              		
		              			"Type = " + String.valueOf(getType()
 	) + " | " + 
		              		
				"]";           		
        }
 	
 		
 		public String toHtmlString() {
 			return super.toString() + "[<br/>" +
            	
		              			"<b>Id</b> = " + String.valueOf(getId()
 	) + " <br/> " + 
		              		
		              			"<b>ImpactTime</b> = " + String.valueOf(getImpactTime()
 	) + " <br/> " + 
		              		
		              			"<b>Direction</b> = " + String.valueOf(getDirection()
 	) + " <br/> " + 
		              		
		              			"<b>Location</b> = " + String.valueOf(getLocation()
 	) + " <br/> " + 
		              		
		              			"<b>Velocity</b> = " + String.valueOf(getVelocity()
 	) + " <br/> " + 
		              		
		              			"<b>Speed</b> = " + String.valueOf(getSpeed()
 	) + " <br/> " + 
		              		
		              			"<b>Origin</b> = " + String.valueOf(getOrigin()
 	) + " <br/> " + 
		              		
		              			"<b>DamageRadius</b> = " + String.valueOf(getDamageRadius()
 	) + " <br/> " + 
		              		
		              			"<b>Type</b> = " + String.valueOf(getType()
 	) + " <br/> " + 
		              		
				"<br/>]";     
		}
 	
 		
 		// --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=all]) ---
        	
		// --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=all]) ---
		
	    // --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=local+classtype[@name=message]) ---
	        
	    // --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=local+classtype[@name=message]) ---        	            	
 	
		}
 	
 		/**
         *  
            				Implementation of the static part of the GameBots2004 message PRJ, used
            				to facade PRJMessage.  
            			
         *
         *  <p></p><p></p>
         *  Complete message documentation:               
         *  
		Both asynchronous and synchronous message. Incoming projectile that we can see.
	
         */
 	public class IncomingProjectileStaticMessage 
	  					extends
  						IncomingProjectileStatic
	    {
 	
		    			@Override
		    			public 
		    			IncomingProjectileStaticMessage clone() {
		    				return this;
		    			}
		    			
 		/**
         * Unique Id of the projectile. 
         */
        public  UnrealId getId()
 	 {
				    					return Id;
				    				}
				    			
 		
 	    public String toString() {
            return
            	super.toString() + "[" +
            	
		              			"Id = " + String.valueOf(getId()
 	) + " | " + 
		              		
				"]";           		
        }
 	
 		
 		public String toHtmlString() {
 			return super.toString() + "[<br/>" +
            	
		              			"<b>Id</b> = " + String.valueOf(getId()
 	) + " <br/> " + 
		              		
				"<br/>]";     
		}
 	
 		
 		// --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=all]) ---
        	
		// --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=all]) ---
		
	    // --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=static+classtype[@name=message]) ---
	        
	    // --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=static+classtype[@name=message]) ---        	            	
 	
		}
 	
 		/**
         *  
            				Implementation of the shared part of the GameBots2004 message PRJ, used
            				to facade PRJMessage.  
            			
         *
         *  <p></p><p></p>
         *  Complete message documentation:               
         *  
		Both asynchronous and synchronous message. Incoming projectile that we can see.
	
         */
 	public class IncomingProjectileSharedMessage 
	  					extends
  						IncomingProjectileShared
	    {
 	
    	
    	
		public IncomingProjectileSharedMessage()
		{
			
		}		
    
		    			@Override
		    			public 
		    			IncomingProjectileSharedMessage clone() {
		    				return this;
		    			}
		    			
		
		
		
		protected HashMap<PropertyId, ISharedProperty> propertyMap = new HashMap<PropertyId, ISharedProperty>(
			0
		);
		
		@Override
		public ISharedProperty getProperty(PropertyId id) {
			return propertyMap.get(id);
		}

		@Override
		public Map<PropertyId, ISharedProperty> getProperties() {
			return propertyMap;
		}
	
		
		
 		/**
         * Unique Id of the projectile. 
         */
        public  UnrealId getId()
 	 {
  			return Id;
  		}
  		
 		
 	    public String toString() {
            return
            	super.toString() + "[" +
            	
		              			"Id = " + String.valueOf(getId()
 	) + " | " + 
		              		
				"]";           		
        }
 	
 		
 		public String toHtmlString() {
 			return super.toString() + "[<br/>" +
            	
		              			"<b>Id</b> = " + String.valueOf(getId()
 	) + " <br/> " + 
		              		
				"<br/>]";     
		}
 	
 		
 		// --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=all]) ---
        	
		// --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=all]) ---
		
	    // --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=shared+classtype[@name=message]) ---
	        
	    // --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=shared+classtype[@name=message]) ---        	            	
 	
		}
 	
    	
    	
 	
		@Override
		public IWorldObjectUpdateResult<IWorldObject> update(IWorldObject object) {
			if (object == null)
			{
				return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.CREATED, this);
			}
			if (!( object instanceof IncomingProjectileMessage) ) {
				throw new PogamutException("Can't update different class than IncomingProjectileMessage, got class " + object.getClass().getSimpleName() + "!", this);		
			}
			IncomingProjectileMessage toUpdate = (IncomingProjectileMessage)object;
			
			boolean updated = false;
			
			// UPDATING LOCAL PROPERTIES
			
				if (toUpdate.ImpactTime != getImpactTime()
 	) {
				    toUpdate.ImpactTime=getImpactTime()
 	;
					updated = true;
				}
			
				if (!SafeEquals.equals(toUpdate.Direction, getDirection()
 	)) {
					toUpdate.Direction=getDirection()
 	;
					updated = true;
				}
			
	            if (!SafeEquals.equals(toUpdate.Location, getLocation()
 	)) {
					toUpdate.Location=getLocation()
 	;
					updated = true;
				}
			
				if (!SafeEquals.equals(toUpdate.Velocity, getVelocity()
 	)) {
					toUpdate.Velocity=getVelocity()
 	;
					updated = true;
				}
			
				if (toUpdate.Speed != getSpeed()
 	) {
				    toUpdate.Speed=getSpeed()
 	;
					updated = true;
				}
			
	            if (!SafeEquals.equals(toUpdate.Origin, getOrigin()
 	)) {
					toUpdate.Origin=getOrigin()
 	;
					updated = true;
				}
			
				if (toUpdate.DamageRadius != getDamageRadius()
 	) {
				    toUpdate.DamageRadius=getDamageRadius()
 	;
					updated = true;
				}
			
				if (!SafeEquals.equals(toUpdate.Type, getType()
 	)) {
					toUpdate.Type=getType()
 	;
					updated = true;
				}
			
         	
         	// UPDATING SHARED PROPERTIES
         	
         	
         	// UPDATE TIME
         	toUpdate.SimTime = SimTime;
			
			if (updated) {
				return new IWorldObjectUpdateResult.WorldObjectUpdateResult<IWorldObject>(IWorldObjectUpdateResult.Result.UPDATED, toUpdate);
			} else {
				return new IWorldObjectUpdateResult.WorldObjectUpdateResult<IWorldObject>(IWorldObjectUpdateResult.Result.SAME, toUpdate);
			}
		}
 	
 		
 	    public String toString() {
            return
            	super.toString() + "[" +
            	
		              			"Id = " + String.valueOf(getId()
 	) + " | " + 
		              		
		              			"ImpactTime = " + String.valueOf(getImpactTime()
 	) + " | " + 
		              		
		              			"Direction = " + String.valueOf(getDirection()
 	) + " | " + 
		              		
		              			"Location = " + String.valueOf(getLocation()
 	) + " | " + 
		              		
		              			"Velocity = " + String.valueOf(getVelocity()
 	) + " | " + 
		              		
		              			"Speed = " + String.valueOf(getSpeed()
 	) + " | " + 
		              		
		              			"Origin = " + String.valueOf(getOrigin()
 	) + " | " + 
		              		
		              			"DamageRadius = " + String.valueOf(getDamageRadius()
 	) + " | " + 
		              		
		              			"Type = " + String.valueOf(getType()
 	) + " | " + 
		              		
				"]";           		
        }
 	
 		
 		public String toHtmlString() {
 			return super.toString() + "[<br/>" +
            	
		              			"<b>Id</b> = " + String.valueOf(getId()
 	) + " <br/> " + 
		              		
		              			"<b>ImpactTime</b> = " + String.valueOf(getImpactTime()
 	) + " <br/> " + 
		              		
		              			"<b>Direction</b> = " + String.valueOf(getDirection()
 	) + " <br/> " + 
		              		
		              			"<b>Location</b> = " + String.valueOf(getLocation()
 	) + " <br/> " + 
		              		
		              			"<b>Velocity</b> = " + String.valueOf(getVelocity()
 	) + " <br/> " + 
		              		
		              			"<b>Speed</b> = " + String.valueOf(getSpeed()
 	) + " <br/> " + 
		              		
		              			"<b>Origin</b> = " + String.valueOf(getOrigin()
 	) + " <br/> " + 
		              		
		              			"<b>DamageRadius</b> = " + String.valueOf(getDamageRadius()
 	) + " <br/> " + 
		              		
		              			"<b>Type</b> = " + String.valueOf(getType()
 	) + " <br/> " + 
		              		
				"<br/>]";     
		}
 	
 		
 		// --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=all]) ---
        	
		// --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=all]) ---
		
	    // --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=base+classtype[@name=message]) ---
	        
	    // --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=base+classtype[@name=message]) ---        	            	
 	
		}
 	