/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.multi.agent.ITeamId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedPropertyUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.BooleanProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.LocationProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.PropertyId;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.VelocityProperty;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointShared;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class NavPointSharedImpl
extends NavPointShared {
    protected HashMap<PropertyId, ISharedProperty> propertyMap = new HashMap(4);
    protected UnrealId Id = null;
    protected LocationProperty myLocation = null;
    protected VelocityProperty myVelocity = null;
    protected BooleanProperty myItemSpawned = null;
    protected BooleanProperty myDoorOpened = null;

    public NavPointSharedImpl(NavPointSharedImpl source) {
        this.Id = source.getId();
        this.myLocation = source.myLocation;
        this.myVelocity = source.myVelocity;
        this.myItemSpawned = source.myItemSpawned;
        this.myDoorOpened = source.myDoorOpened;
    }

    public NavPointSharedImpl(WorldObjectId objectId, Collection<ISharedProperty> properties) {
        this.Id = (UnrealId)objectId;
        NullCheck.check((Object)this.Id, (String)"objectId");
        if (properties.size() != 4) {
            throw new PogamutException("Not enough properties passed to the constructor.", NavPointSharedImpl.class);
        }
        for (ISharedProperty property : properties) {
            PropertyId pId = property.getPropertyId();
            if (!objectId.equals((Object)property.getObjectId())) {
                throw new PogamutException("Trying to create a NavPointSharedImpl with different WorldObjectId properties : " + this.Id.getStringId() + " / " + property.getObjectId().getStringId(), (Object)this);
            }
            if (!NavPointShared.SharedPropertyTokens.contains(pId.getPropertyToken())) {
                throw new PogamutException("Trying to create a NavPointSharedImpl with invalid property (invalid property token): " + this.Id.getStringId() + " / " + property.getPropertyId().getPropertyToken().getToken(), (Object)this);
            }
            this.propertyMap.put(property.getPropertyId(), property);
        }
    }

    @Override
    public void setSimTime(long SimTime) {
        super.setSimTime(SimTime);
    }

    @Override
    public NavPointSharedImpl clone() {
        return new NavPointSharedImpl(this);
    }

    public ISharedProperty getProperty(PropertyId id) {
        return this.propertyMap.get(id);
    }

    public Map<PropertyId, ISharedProperty> getProperties() {
        return this.propertyMap;
    }

    @Override
    public UnrealId getId() {
        return this.Id;
    }

    @Override
    public Location getLocation() {
        return (Location)this.myLocation.getValue();
    }

    @Override
    public Velocity getVelocity() {
        return (Velocity)this.myVelocity.getValue();
    }

    @Override
    public boolean isItemSpawned() {
        return (Boolean)this.myItemSpawned.getValue();
    }

    @Override
    public boolean isDoorOpened() {
        return (Boolean)this.myDoorOpened.getValue();
    }

    @Override
    public String toString() {
        return super.toString() + "[" + "Id = " + String.valueOf(this.getId()) + " | " + "Location = " + String.valueOf(this.getLocation()) + " | " + "Velocity = " + String.valueOf(this.getVelocity()) + " | " + "ItemSpawned = " + String.valueOf(this.isItemSpawned()) + " | " + "DoorOpened = " + String.valueOf(this.isDoorOpened()) + " | " + "]";
    }

    @Override
    public String toHtmlString() {
        return super.toString() + "[<br/>" + "<b>Id</b> = " + String.valueOf(this.getId()) + " <br/> " + "<b>Location</b> = " + String.valueOf(this.getLocation()) + " <br/> " + "<b>Velocity</b> = " + String.valueOf(this.getVelocity()) + " <br/> " + "<b>ItemSpawned</b> = " + String.valueOf(this.isItemSpawned()) + " <br/> " + "<b>DoorOpened</b> = " + String.valueOf(this.isDoorOpened()) + " <br/> " + "<br/>]";
    }

    public static class NavPointSharedUpdate
    implements ISharedWorldObjectUpdatedEvent {
        private NavPointShared object;
        private long time;
        private ITeamId teamId;

        public NavPointSharedUpdate(NavPointShared data, long time, ITeamId teamId) {
            this.object = data;
            this.time = time;
            this.teamId = teamId;
        }

        public long getSimTime() {
            return this.time;
        }

        public WorldObjectId getId() {
            return this.object.getId();
        }

        public ITeamId getTeamId() {
            return this.teamId;
        }

        public Class getCompositeObjectClass() {
            return this.object.getCompositeClass();
        }

        public Collection<ISharedPropertyUpdatedEvent> getPropertyEvents() {
            LinkedList<ISharedPropertyUpdatedEvent> events = new LinkedList<ISharedPropertyUpdatedEvent>();
            for (ISharedProperty property : this.object.getProperties().values()) {
                if (property == null) continue;
                events.push(property.createUpdateEvent(this.time, this.teamId));
            }
            return events;
        }
    }
}

