/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.t3dgenerator.elements.map;

import cz.cuni.amis.pogamut.unreal.t3dgenerator.annotations.StaticText;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.annotations.UnrealBean;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.annotations.UnrealHeaderField;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.Vector3D;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;

@UnrealBean(value="Polygon")
public class Polygon {
    @UnrealHeaderField
    private String texture;
    @UnrealHeaderField
    private Long flags;
    @UnrealHeaderField
    private Integer link;
    private transient Vector3D textureOrigin;
    private transient Vector3D textureNormal;
    private transient Vector3D textureU;
    private transient Vector3D textureV;
    private transient List<Vector3D> vertices;
    private static final NumberFormat numberFormat;

    public Polygon() {
    }

    public Polygon(String texture, Vector3D textureOrigin, Vector3D textureNormal, Vector3D textureU, Vector3D textureV, List<Vector3D> vertices) {
        this.texture = texture;
        this.textureOrigin = textureOrigin;
        this.textureNormal = textureNormal;
        this.textureU = textureU;
        this.textureV = textureV;
        this.vertices = vertices;
    }

    public Polygon(String texture, Vector3D textureOrigin, Vector3D textureNormal, Vector3D textureU, Vector3D textureV, Vector3D[] vertices) {
        this(texture, textureOrigin, textureNormal, textureU, textureV, Arrays.asList(vertices));
    }

    protected String translateVectorToT3d(String label, Vector3D vector) {
        return "\t\t\t\t\t" + label + " " + numberFormat.format(vector.getX() + 0.0f) + "," + numberFormat.format(vector.getY() + 0.0f) + "," + numberFormat.format(vector.getZ() + 0.0f) + "\n";
    }

    @StaticText
    public String translateToT3D() {
        StringBuilder theText = new StringBuilder();
        theText.append(this.translateVectorToT3d("Origin", this.textureOrigin));
        theText.append(this.translateVectorToT3d("Normal", this.textureNormal));
        theText.append(this.translateVectorToT3d("TextureU", this.textureU));
        theText.append(this.translateVectorToT3d("TextureV", this.textureV));
        for (Vector3D v : this.vertices) {
            theText.append(this.translateVectorToT3d("Vertex", v));
        }
        return theText.toString();
    }

    public String getTexture() {
        return this.texture;
    }

    public void setTexture(String texture) {
        this.texture = texture;
    }

    public Long getFlags() {
        return this.flags;
    }

    public void setFlags(Long flags) {
        this.flags = flags;
    }

    public Integer getLink() {
        return this.link;
    }

    public void setLink(Integer link) {
        this.link = link;
    }

    public Vector3D getTextureOrigin() {
        return this.textureOrigin;
    }

    public void setTextureOrigin(Vector3D textureOrigin) {
        this.textureOrigin = textureOrigin;
    }

    public Vector3D getTextureNormal() {
        return this.textureNormal;
    }

    public void setTextureNormal(Vector3D textureNormal) {
        this.textureNormal = textureNormal;
    }

    public Vector3D getTextureU() {
        return this.textureU;
    }

    public void setTextureU(Vector3D textureU) {
        this.textureU = textureU;
    }

    public Vector3D getTextureV() {
        return this.textureV;
    }

    public void setTextureV(Vector3D textureV) {
        this.textureV = textureV;
    }

    public List<Vector3D> getVertices() {
        return this.vertices;
    }

    public void addVertex(Vector3D vertex) {
        this.vertices.add(vertex);
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        numberFormat = new DecimalFormat("+00000.000000;-00000.000000", symbols);
    }
}

