package cz.cuni.amis.pogamut.udk.communication.translator.observer.state;


import cz.cuni.amis.fsm.FSMState;
import cz.cuni.amis.fsm.FSMTransition;
import cz.cuni.amis.fsm.IFSMState;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.HandShakeEnd;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.ItemCategoryStart;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.ItemListStart;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.MapListStart;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.MutatorListStart;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.NavPointListStart;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.PlayerListStart;
import cz.cuni.amis.pogamut.udk.communication.translator.TranslatorContext;
import cz.cuni.amis.pogamut.udk.communication.translator.TranslatorMessages;
import cz.cuni.amis.pogamut.udk.communication.translator.UnexpectedMessageException;
import cz.cuni.amis.pogamut.udk.communication.translator.observer.support.AbstractObserverFSMState;
import cz.cuni.amis.pogamut.udk.communication.translator.shared.events.MapPointListObtained;

/**
 * This class implements a batch handling logic.
 * @author Jimmy
 */
@FSMState(map = { 
					@FSMTransition(
						state=ItemCategoryState.class, 
						symbol={ItemCategoryStart.class}, 
						transition={}
					),				
					@FSMTransition(
						state=MutatorListState.class, 
						symbol={MutatorListStart.class}, 
						transition={}),
					@FSMTransition(
						state = NavPointListState.class, 
						symbol = { NavPointListStart.class }, 
						transition = {}
					),
					@FSMTransition(
						state = ItemListState.class,
						symbol = { ItemListStart.class },
						transition = {}
					),
					@FSMTransition(
							state = PlayerListState.class, 
							symbol = { PlayerListStart.class }, 
							transition = {}
					),
                    @FSMTransition(
							state = MapListState.class,
							symbol = { MapListStart.class },
							transition = {}
					)
				}
)
public class ObserverRunningState extends AbstractObserverFSMState<InfoMessage, TranslatorContext> {

    @Override
    public void stateEntering(TranslatorContext context, IFSMState<InfoMessage, TranslatorContext> arg1, InfoMessage arg2) {
    }

    @Override
    protected void innerStateSymbol(TranslatorContext context, InfoMessage obj) {
        if (obj instanceof IWorldChangeEvent) {
        	if (obj instanceof HandShakeEnd) {
        		context.getEventQueue().pushEvent(new MapPointListObtained(context.getNavPoints(), context.getItems()));
        	} else {
        		context.getEventQueue().pushEvent((IWorldChangeEvent) obj);
        	}
        } else {
        	throw new UnexpectedMessageException(TranslatorMessages.messageNotWorldEvent(this, obj), context.getLogger(), this);
        }

    }

    @Override
    public void stateLeaving(TranslatorContext context, IFSMState<InfoMessage, TranslatorContext> arg1, InfoMessage symbol) {
    }

    @Override
    public void init(TranslatorContext arg0) {        
    }

    @Override
    public void restart(TranslatorContext arg0) {
    }
    
}