package cz.cuni.amis.pogamut.udk.bot.impl;

import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.udk.agent.module.logic.SyncUDKBotLogic;
import cz.cuni.amis.pogamut.udk.bot.IUDKBotLogicController;

@AgentScoped
public class UDKBotLogicController<BOT extends UDKBot> extends UDKBotController<BOT> implements IUDKBotLogicController<BOT, LogicModule>{

	protected SyncUDKBotLogic logicModule;
	
	@Override
	public void initializeController(BOT bot) {
		super.initializeController(bot);
		logicModule = new SyncUDKBotLogic(bot, this);	
	}
	
	@Override
	public long getLogicInitializeTime() {
		return 120000;
	}

	@Override
	public long getLogicShutdownTime() {
		return 120000;
	}
	
	@Override
	public void beforeFirstLogic() {
	}

	@Override
	public void logic() {
	}

	@Override
	public void logicInitialize(LogicModule logicModule) {		
	}

	@Override
	public void logicShutdown() {
	}
	
}
