/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.agent.navigation.loquenavigator;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.Senses;
import cz.cuni.amis.pogamut.udk.agent.navigation.IUDKPathRunner;
import cz.cuni.amis.pogamut.udk.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.utils.NullCheck;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Tuple3d;

public class LoqueRunner
implements IUDKPathRunner {
    private int runnerStep = 0;
    private int runnerSingleJump = 0;
    private int runnerDoubleJump = 0;
    private int collisionCount = 0;
    private Location collisionSpot = null;
    protected UDKBot bot;
    protected AgentInfo memory;
    protected AdvancedLocomotion body;
    protected Logger log;
    protected Senses senses;

    @Override
    public void reset() {
        this.runnerStep = 0;
        this.runnerSingleJump = 0;
        this.runnerDoubleJump = 0;
        this.collisionCount = 0;
        this.collisionSpot = null;
    }

    @Override
    public boolean runToLocation(Location firstLocation, Location secondLocation, Location focus, NavPointNeighbourLink navPointsLink, boolean reachable) {
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("Runner.runToLocation(): runnerStep is " + this.runnerStep + ", reachable is " + reachable + ",  navPointsLink is" + (Object)((Object)navPointsLink) + " location is" + this.bot.getLocation());
        }
        ++this.runnerStep;
        if (this.runnerStep <= 0) {
            return true;
        }
        if (this.runnerStep <= 1) {
            this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
            if (navPointsLink != null && (navPointsLink.isForceDoubleJump() || navPointsLink.getNeededJump() != null || (navPointsLink.getFlags() & 8) != 0) && ((navPointsLink.getFlags() & 8) == 0 || this.memory.getLocation().z - 100.0 <= firstLocation.z)) {
                Location direction = Location.sub((Location)firstLocation, (Location)this.memory.getLocation()).getNormalized();
                Location velocityDir = new Location((Tuple3d)this.memory.getVelocity().asVector3d()).getNormalized();
                Double result = Math.acos(direction.dot(velocityDir));
                if (this.memory.getVelocity().size() > 200.0 && !result.isNaN() && result < 0.3490658503988659) {
                    return this.resolveJump(firstLocation, secondLocation, focus, navPointsLink, reachable);
                }
            }
            return true;
        }
        if (this.runnerSingleJump > 0) {
            return this.iterateSingleJumpSequence(firstLocation, secondLocation, focus, reachable);
        }
        if (this.runnerDoubleJump > 0) {
            return this.iterateDoubleJumpSequence(firstLocation, secondLocation, focus, reachable);
        }
        if (this.senses.isCollidingOnce()) {
            return this.resolveCollision(firstLocation, secondLocation, focus, reachable);
        }
        if (this.runnerSingleJump == 0 && this.runnerDoubleJump == 0 && (!reachable || navPointsLink != null && (navPointsLink.isForceDoubleJump() || navPointsLink.getNeededJump() != null || (navPointsLink.getFlags() & 8) != 0))) {
            return this.resolveJump(firstLocation, secondLocation, focus, navPointsLink, reachable);
        }
        this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("Runner.runToLocation(): issuing default move command to: " + firstLocation + ", second location: " + secondLocation);
        }
        return true;
    }

    private boolean resolveCollision(Location firstLocation, Location secondLocation, Location focus, boolean reachable) {
        if (this.collisionSpot == null || this.memory.getLocation().getDistance2D(this.collisionSpot) > 120.0) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("Runner.resolveCollision(): collision at " + (int)this.memory.getLocation().getDistance2D(firstLocation));
            }
            this.collisionSpot = this.memory.getLocation();
            this.collisionCount = 1;
            this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
            return true;
        }
        switch (this.collisionCount++ % 2) {
            case 0: {
                if (this.log != null && this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Runner.resolveCollision(): repeated collision (" + this.collisionCount + "):" + " double-jumping at " + (int)this.memory.getLocation().getDistance2D(firstLocation));
                }
                return this.initDoubleJumpSequence(firstLocation, secondLocation, focus, reachable);
            }
        }
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("Runner.resolveCollision(): repeated collision (" + this.collisionCount + "):" + " single-jumping at " + (int)this.memory.getLocation().getDistance2D(firstLocation));
        }
        return this.initSingleJumpSequence(firstLocation, secondLocation, focus, reachable);
    }

    private boolean resolveJump(Location firstLocation, Location secondLocation, Location focus, NavPointNeighbourLink navPointsLink, boolean reachable) {
        int distance = (int)this.memory.getLocation().getDistance2D(firstLocation);
        int velocity = (int)this.memory.getVelocity().size();
        int jumpDistance = distance % 1000;
        int zDistance = (int)firstLocation.getDistanceZ(this.memory.getLocation());
        this.log.finer("Runner.resolveJump: distance = " + distance + ", velocity = " + velocity + ", jumpDistance = " + (jumpDistance += Math.min(200, Math.max(-200, zDistance))) + ", zDistance = " + zDistance);
        boolean enforceDoubleJump = false;
        if (navPointsLink != null && (navPointsLink.getNeededJump() != null || (navPointsLink.getFlags() & 8) != 0) && zDistance > 60) {
            enforceDoubleJump = true;
            this.log.finest("Runner.resolveJump(): double jump indicated");
        }
        if (jumpDistance < 370) {
            if (navPointsLink != null) {
                if ((navPointsLink.getNeededJump() != null || (navPointsLink.getFlags() & 8) != 0) && enforceDoubleJump) {
                    return this.initDoubleJumpSequence(firstLocation, secondLocation, focus, reachable);
                }
                return this.initSingleJumpSequence(firstLocation, secondLocation, focus, reachable);
            }
            if (reachable || distance >= 1000) {
                this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
                return true;
            }
            this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
            return true;
        }
        if (jumpDistance < 470) {
            if (enforceDoubleJump) {
                return this.initDoubleJumpSequence(firstLocation, secondLocation, focus, reachable);
            }
            return this.initSingleJumpSequence(firstLocation, secondLocation, focus, reachable);
        }
        if (jumpDistance < 600) {
            if (enforceDoubleJump) {
                return this.initDoubleJumpSequence(firstLocation, secondLocation, focus, reachable);
            }
            this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
            return true;
        }
        if (jumpDistance < 700 && velocity > 300) {
            if (!enforceDoubleJump && navPointsLink != null && (navPointsLink.getFlags() & 8) != 0) {
                this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
                return true;
            }
            return this.initDoubleJumpSequence(firstLocation, secondLocation, focus, reachable);
        }
        this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
        return true;
    }

    private boolean initSingleJumpSequence(Location firstLocation, Location secondLocation, Location focus, boolean reachable) {
        if (this.runnerSingleJump > 0 || this.runnerDoubleJump > 0) {
            throw new RuntimeException("jumping sequence aleady started");
        }
        this.log.finer("Runner.initSingleJumpSequence() !");
        this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
        this.body.jump();
        this.runnerSingleJump = 1;
        return true;
    }

    private boolean iterateSingleJumpSequence(Location firstLocation, Location secondLocation, Location focus, boolean reachable) {
        int distance = (int)this.memory.getLocation().getDistance2D(firstLocation);
        int zVelocity = (int)this.memory.getVelocity().z;
        switch (this.runnerSingleJump) {
            case 1: {
                if (zVelocity > 100) {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer("Runner.iterateSingleJumpSequence(): single-jump registered at " + distance + ", z-velo " + zVelocity);
                    }
                    ++this.runnerSingleJump;
                }
                this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
                return true;
            }
        }
        if (zVelocity <= 0) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("Runner.iterateSingleJumpSequence(): single-jump completed at " + distance + ", z-velo " + zVelocity);
            }
            this.runnerSingleJump = 0;
        }
        this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
        return true;
    }

    private boolean initDoubleJumpSequence(Location firstLocation, Location secondLocation, Location focus, boolean reachable) {
        if (this.runnerSingleJump > 0 || this.runnerDoubleJump > 0) {
            throw new RuntimeException("jumping sequence aleady started");
        }
        double delay = 0.39;
        double jumpZ = 680.0;
        double distanceZ = firstLocation.getDistanceZ(this.memory.getLocation());
        if (distanceZ > 0.0) {
            jumpZ = 680.0 * distanceZ / 70.0;
        }
        if (jumpZ < 480.0) {
            jumpZ = 480.0;
        }
        this.log.finer("Runner.initDoubleJumpSequence(): double jump delay = " + delay + ", jumpZ = " + jumpZ);
        this.body.doubleJump(delay, jumpZ);
        this.runnerDoubleJump = 1;
        return true;
    }

    private boolean iterateDoubleJumpSequence(Location firstLocation, Location secondLocation, Location focus, boolean reachable) {
        int distance = (int)this.memory.getLocation().getDistance2D(firstLocation);
        int zVelocity = (int)this.memory.getVelocity().z;
        switch (this.runnerDoubleJump) {
            case 1: {
                if (zVelocity > 100) {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer("Runner.iterateDoubleJumpSequence(): double-jump registered at " + distance + ", z-velo " + zVelocity);
                    }
                    ++this.runnerDoubleJump;
                }
                this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
                return true;
            }
            case 2: {
                if (zVelocity < 150) {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer("Runner.iterateDoubleJumpSequence(): double-jump boost at " + distance + ", z-velo " + zVelocity);
                    }
                    this.body.jump();
                    ++this.runnerDoubleJump;
                    return true;
                }
                this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
                return true;
            }
        }
        if (zVelocity <= 0) {
            this.runnerDoubleJump = 0;
        }
        this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
        return true;
    }

    public LoqueRunner(UDKBot bot, AgentInfo agentInfo, AdvancedLocomotion locomotion, Logger log) {
        NullCheck.check((Object)bot, (String)"bot");
        this.bot = bot;
        NullCheck.check((Object)((Object)agentInfo), (String)"agentInfo");
        this.memory = agentInfo;
        NullCheck.check((Object)((Object)locomotion), (String)"locomotion");
        this.body = new AdvancedLocomotion(bot, log);
        this.senses = new Senses(bot, this.memory, new Players(bot), log);
        this.log = log;
    }
}

