/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.agent;

import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBotModuleController;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.util.concurrent.CountDownLatch;

@AgentScoped
public class UDKBotTestController<BOT extends UDKBot>
extends UDKBotModuleController<BOT> {
    private CountDownLatch latch;
    private Flag<Boolean> success = new Flag((Object)false);
    private Flag<Boolean> failure = new Flag((Object)false);
    private String message;
    private Throwable cause;

    public void initializeController(BOT bot) {
        super.initializeController(bot);
        this.latch = new BusAwareCountDownLatch(1, bot.getEventBus(), new IComponent[]{bot.getWorldView()});
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setTestLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    public void setSuccess() {
        this.success.setFlag((Object)true);
        this.latch.countDown();
    }

    public void setSuccess(String message) {
        this.message = message;
        this.getLog().info(message);
        this.success.setFlag((Object)true);
        this.latch.countDown();
    }

    public void timeout() {
        this.latch.countDown();
        this.setFailure("Timeout!");
    }

    public void setFailure() {
        this.failure.setFlag((Object)true);
        this.latch.countDown();
    }

    public void setFailure(String message) {
        this.setMessage(message);
        this.setFailure();
    }

    public void setFailure(Throwable cause) {
        this.setCause(cause);
        this.setFailure();
    }

    public void setFailure(String message, Throwable cause) {
        this.setMessage(message);
        this.setCause(cause);
        this.setFailure();
    }

    private void setCause(Throwable cause) {
        this.cause = cause;
        if (cause != null) {
            this.getLog().severe(this.message);
        } else {
            this.getLog().severe("setFailure(cause): cause == null !!!");
        }
    }

    private void setMessage(String message) {
        this.message = message;
        if (message != null) {
            this.getLog().severe(message);
        } else {
            this.getLog().severe("setFailure(message): message == null !!!");
        }
    }

    public boolean isFailure() {
        return (Boolean)this.failure.getFlag() != false || this.latch.getCount() == 0L && (Boolean)this.failure.getFlag() == false && (Boolean)this.success.getFlag() == false;
    }

    public ImmutableFlag<Boolean> getFailureFlag() {
        return this.failure.getImmutable();
    }

    public boolean isSuccess() {
        return (Boolean)this.success.getFlag();
    }

    public ImmutableFlag<Boolean> getSuccessFlag() {
        return this.success.getImmutable();
    }

    public CountDownLatch getTestLatch() {
        return this.latch;
    }

    protected LogicModule getLogicModule() {
        return this.logicModule;
    }
}

