/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.impl.PathFuture;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReact;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReactOnce;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.udk.agent.navigation.UDKAStarPathTimeoutException;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.GetPath;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.udk.communication.translator.shared.events.Path;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.utils.future.FutureStatus;
import java.util.ArrayList;
import java.util.logging.Logger;

public class UDKAStarPathFuture
extends PathFuture<ILocated> {
    private static final int PATH_TIMEOUT = 10;
    private static Object idMutex = new Object();
    private static long lastId = 0L;
    private String pathId;
    private EventReactOnce<Path> pathReaction;
    private EventReact<EndMessage> endReaction;
    private IVisionWorldView worldView;
    private Logger log;
    private Double startTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UDKAStarPathFuture(UDKBot bot, ILocated pathFrom, ILocated pathTo) {
        super((Object)pathFrom, (Object)pathTo, bot.getEventBus(), new IComponent[]{bot.getWorldView()});
        this.log = bot.getLogger().getCategory(((Object)((Object)this)).getClass().getSimpleName());
        Object object = idMutex;
        synchronized (object) {
            this.pathId = "UDKAStarPathFuture_" + ++lastId;
        }
        this.pathReaction = new EventReactOnce<Path>(Path.class, bot.getWorldView()){

            protected void react(Path event) {
                if (UDKAStarPathFuture.this.pathId.equals(event.getPathId())) {
                    UDKAStarPathFuture.this.eventPath(event);
                }
            }
        };
        this.endReaction = new EventReact<EndMessage>(EndMessage.class, bot.getWorldView()){

            protected void react(EndMessage event) {
                UDKAStarPathFuture.this.eventEndMessage(event);
            }
        };
        this.log.finer("Requesting path from '" + pathFrom + "' to '" + pathTo + "' under id '" + this.pathId + "'.");
        bot.getAct().act((CommandMessage)new GetPath().setLocation(pathTo.getLocation()).setId(this.pathId));
        this.log.fine("Path requested, listening for the result (timeout 10s)");
        this.worldView = bot.getWorldView();
    }

    protected boolean cancelComputation(boolean mayInterruptIfRunning) {
        this.pathReaction.disable();
        this.endReaction.disable();
        return this.getStatus() == FutureStatus.FUTURE_IS_BEING_COMPUTED;
    }

    protected void eventEndMessage(EndMessage event) {
        if (this.startTime == null) {
            this.startTime = event.getTime();
        }
        if (event.getTime() - this.startTime > 10.0) {
            this.pathReaction.disable();
            this.endReaction.disable();
            if (this.getStatus() == FutureStatus.FUTURE_IS_BEING_COMPUTED) {
                this.computationException((Exception)((Object)new UDKAStarPathTimeoutException("Path did not came from GB2004 in 10s.", this.log, (Object)this)));
            }
        }
    }

    protected void eventPath(Path event) {
        this.endReaction.disable();
        ArrayList<Object> result = new ArrayList<Object>(event.getPath().size());
        for (int i = 0; i < event.getPath().size(); ++i) {
            UnrealId routeId = event.getPath().get(i).getRouteId();
            NavPoint nav = (NavPoint)this.worldView.get((WorldObjectId)routeId);
            if (nav == null) {
                result.add(event.getPath().get(i).getLocation());
                continue;
            }
            result.add(nav);
        }
        this.setResult(result);
    }
}

