/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.communication.worldview;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentPausedException;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.ILockableVisionWorldView;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.udk.communication.worldview.UDKWorldView;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;

@AgentScoped
public class UDKSyncLockableWorldView
extends UDKWorldView
implements ILockableVisionWorldView {
    public static final String WORLDVIEW_DEPENDENCY = "UDKSyncLockableWorldViewDependency";
    private Queue<List<IWorldChangeEvent>> batches = new LinkedList<List<IWorldChangeEvent>>();
    private List<IWorldChangeEvent> currentBatch = new ArrayList<IWorldChangeEvent>();
    private boolean locked = false;
    private boolean inLock = false;
    private boolean beginCame = false;
    private final Object objectMutex = new Object();
    private BusAwareCountDownLatch lockLatch;
    private boolean stopRequested = false;
    private boolean pauseRequested = false;

    @Inject
    public UDKSyncLockableWorldView(@Named(value="UDKSyncLockableWorldViewDependency") ComponentDependencies dependencies, IMediator mediator, IComponentBus bus, IAgentLogger log) {
        super(dependencies, mediator, bus, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws PogamutInterruptedException, ComponentNotRunningException {
        if (this.isPaused()) {
            throw new ComponentPausedException((ComponentState)this.controller.getState().getFlag(), (Object)this);
        }
        if (!this.isRunning()) {
            throw new ComponentNotRunningException((ComponentState)this.controller.getState().getFlag(), (Object)this);
        }
        Object object = this.objectMutex;
        synchronized (object) {
            if (this.isLocked()) {
                return;
            }
            this.locked = true;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("World view is being locked.");
            }
        }
        if (this.isPaused()) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("World view paused, unlocking.");
            }
            this.locked = false;
            throw new ComponentPausedException((ComponentState)this.controller.getState().getFlag(), (Object)this);
        }
        if (!this.isRunning()) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("World view not running, unlocking.");
            }
            this.locked = false;
            throw new ComponentNotRunningException((ComponentState)this.controller.getState().getFlag(), (Object)this);
        }
        this.lockLatch.await();
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("World view locked.");
        }
        if (this.pauseRequested) {
            throw new ComponentPausedException("Component pause requested.", (Object)this);
        }
        if (this.stopRequested) {
            throw new ComponentNotRunningException("Component stop requested.", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() throws ComponentNotRunningException {
        Object object = this.objectMutex;
        synchronized (object) {
            if (!this.isLocked()) {
                return;
            }
            this.locked = false;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("World view is being unlocked.");
            }
            this.inLock = false;
            this.processBatches();
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("World view unlocked.");
            }
            this.lockLatch = new BusAwareCountDownLatch(1, this.eventBus, new IComponent[]{this});
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isInLock() {
        return this.inLock;
    }

    private void processBatches() {
        for (List list : this.batches) {
            this.processBatch(list);
        }
        this.batches.clear();
        this.processBatch(this.currentBatch);
    }

    private void processBatch(List<IWorldChangeEvent> batch) {
        for (IWorldChangeEvent event : batch) {
            super.notify(event);
        }
        batch.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(IWorldChangeEvent event) {
        Object object = this.objectMutex;
        synchronized (object) {
            if (!this.beginCame) {
                if (event instanceof BeginMessage) {
                    this.beginCame = true;
                } else {
                    super.notify(event);
                    return;
                }
            }
            if (this.isLocked()) {
                if (this.isInLock()) {
                    if (event instanceof EndMessage) {
                        this.currentBatch.add(event);
                        this.batches.add(this.currentBatch);
                        this.currentBatch = new ArrayList<IWorldChangeEvent>(this.currentBatch.size() + 10);
                    } else {
                        this.currentBatch.add(event);
                    }
                } else if (event instanceof EndMessage) {
                    super.notify(event);
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.finer("World view in-locked state, raising the lock() latch.");
                    }
                    this.lockLatch.countDown();
                    this.inLock = true;
                } else {
                    super.notify(event);
                }
            } else {
                super.notify(event);
            }
        }
    }

    protected void start(boolean startPaused) {
        super.start(startPaused);
        this.lockLatch = new BusAwareCountDownLatch(1, this.eventBus, new IComponent[]{this});
        this.stopRequested = false;
        this.pauseRequested = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preStop() {
        super.preStop();
        Object object = this.objectMutex;
        synchronized (object) {
            this.stopRequested = true;
            this.lockLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prePause() {
        super.preStop();
        Object object = this.objectMutex;
        synchronized (object) {
            this.pauseRequested = true;
            this.lockLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resume() {
        super.resume();
        Object object = this.objectMutex;
        synchronized (object) {
            this.lockLatch.countDown();
            this.lockLatch = new BusAwareCountDownLatch(1, this.eventBus, new IComponent[]{this});
            this.pauseRequested = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() {
        super.stop();
        Object object = this.objectMutex;
        synchronized (object) {
            this.stopRequested = true;
            this.lockLatch.countDown();
        }
    }
}

