/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.agent.module.sensomotoric;

import cz.cuni.amis.pogamut.udk.communication.messages.ItemType;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.AddInventoryMsg;
import cz.cuni.amis.pogamut.udk.communication.translator.itemdescriptor.WeaponDescriptor;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.utils.exception.PogamutException;

public class Weapon {
    protected ItemType weaponType = null;
    protected int primaryAmmo = 0;
    protected int secondaryAmmo = 0;
    protected UnrealId inventoryId;
    protected WeaponDescriptor descriptor = null;

    protected Weapon(AddInventoryMsg weaponGained, int primaryAmmo, int secondaryAmmo) {
        if (weaponGained.getPickupType().getCategory() != ItemType.Category.WEAPON) {
            throw new PogamutException("Could not create Weapon class out of inventory item that is not a weapon.", (Object)this);
        }
        this.weaponType = weaponGained.getPickupType();
        this.inventoryId = weaponGained.getId();
        this.descriptor = (WeaponDescriptor)weaponGained.getDescriptor();
        this.primaryAmmo = primaryAmmo;
        this.secondaryAmmo = secondaryAmmo;
    }

    public ItemType getType() {
        return this.weaponType;
    }

    public ItemType.Group getGroup() {
        return this.weaponType.getGroup();
    }

    public int getPrimaryAmmo() {
        return this.primaryAmmo;
    }

    public int getSecondaryAmmo() {
        return this.secondaryAmmo;
    }

    public UnrealId getInventoryId() {
        return this.inventoryId;
    }

    public WeaponDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean hasSecondaryAmmoType() {
        return this.getDescriptor().getSecAmmoItemType() != null && this.getDescriptor().getPriAmmoItemType() != this.getDescriptor().getSecAmmoItemType();
    }

    public int getAmmo() {
        return this.getPrimaryAmmo() + this.getSecondaryAmmo();
    }

    public String toString() {
        if (this.hasSecondaryAmmoType()) {
            return "Weapon[type=" + this.getType().getName() + ", primary ammo=" + this.getPrimaryAmmo() + ", secondary ammo=" + this.getSecondaryAmmo() + "]";
        }
        return "Weapon[type=" + this.getType().getName() + ", ammo=" + this.getPrimaryAmmo() + "]";
    }
}

