package cz.cuni.amis.pogamut.udk.agent.navigation;

import java.util.List;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorHelper;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.exception.PogamutException;

/**
 * Simple stub of the {@link IUDKPathNavigator} that implements {@link AbstractUDKPathNavigator#setBot(UDKBot)} and 
 * {@link AbstractUDKPathNavigator#setExecutor(IPathExecutorHelper)}.
 * 
 * @author Jimmy
 *
 * @param <PATH_ELEMENT>
 */
public abstract class AbstractUDKPathNavigator<PATH_ELEMENT extends ILocated> implements IUDKPathNavigator<PATH_ELEMENT>{

	/**
	 * Bot, the navigator is navigating. Set by {@link AbstractUDKPathNavigator#setBot(UDKBot)}.
	 * See {@link IUDKPathNavigator#setBot(UDKBot)}.
	 */
	protected UDKBot bot;
	
	/**
	 * Executor who is using the navigator. See {@link IUDKPathNavigator#setExecutor(IPathExecutorHelper)}
	 * for more info.
	 */
	protected IPathExecutorHelper<PATH_ELEMENT> executor;

	/**
	 * {@link Self} object that is lazy-initialized inside {@link AbstractUDKPathNavigator#self}.
	 */
	protected Self self;
	
	@Override
	public void setBot(UDKBot bot) {
		this.bot = bot;
	}

	@Override
	public void setExecutor(IPathExecutorHelper<PATH_ELEMENT> owner) {
		this.executor = owner;		
	}
	
	@Override
	public void navigate() {
		if (bot == null) throw new PogamutException("The 'bot' field is null (or was not set by the executor), can't navigate.", this);
		if (executor == null) throw new PogamutException("The 'executor' field is null (ow was not set by the executor), can't navigate.", this);
		// check that we're running in correct context
		int pathElementIndex = executor.getPathElementIndex();
		if (pathElementIndex < 0 || pathElementIndex >= executor.getPath().size()) throw new PogamutException("Can't navigate as the current path element index is out of path range (index = " + pathElementIndex + ", path.size() = " + executor.getPath().size() + ".", this);
		if (self == null) {
			self = bot.getWorldView().getSingle(Self.class);
			if (self == null) throw new PogamutException("Can't navigate the bot, no Self instance is available in the world view.", this);
		}
		// fire the navigation
		navigate(pathElementIndex);
	}
		
	/**
	 * Does the actual navigation of the bot, it should steer it towards path element of the index 'pathElementIndex'.
	 * Called (after several checks) from {@link AbstractUDKPathNavigator#navigate()}.
	 * @param pathElementIndex
	 */
	protected abstract void navigate(int pathElementIndex);

}
