/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.agent.module.logic;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReact;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReactOnce;
import cz.cuni.amis.pogamut.base.communication.worldview.react.ObjectEventReact;
import cz.cuni.amis.pogamut.base.communication.worldview.react.ObjectEventReactOnce;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GamePaused;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameResumed;
import cz.cuni.amis.utils.token.IToken;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UDKBotLogic<BOT extends UDKBot>
extends LogicModule<BOT> {
    private EventReact<GamePaused> pauseReaction;
    private EventReact<GameResumed> resumeReaction;
    private ObjectEventReact<GameInfo, ?> gameInfoReaction;
    private EventReact<EndMessage> endReaction;
    private BusAwareCountDownLatch latch;

    @Inject
    public UDKBotLogic(BOT agent, IAgentLogic logic) {
        this(agent, logic, null, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(((UDKBot)agent).getWorldView()));
    }

    public UDKBotLogic(BOT agent, IAgentLogic logic, Logger log) {
        this(agent, logic, log, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(((UDKBot)agent).getWorldView()));
    }

    public UDKBotLogic(BOT agent, IAgentLogic logic, Logger log, ComponentDependencies dependencies) {
        super(agent, logic, log, dependencies);
        this.pauseReaction = new EventReact<GamePaused>(GamePaused.class, ((UDKBot)agent).getWorldView()){

            protected void react(GamePaused event) {
                UDKBotLogic.this.controller.manualPause("Game paused.");
            }
        };
        this.resumeReaction = new EventReact<GameResumed>(GameResumed.class, ((UDKBot)agent).getWorldView()){

            protected void react(GameResumed event) {
                UDKBotLogic.this.controller.manualResume("Game resumed.");
            }
        };
        this.gameInfoReaction = new ObjectEventReactOnce<GameInfo, IWorldObjectEvent<GameInfo>>((WorldObjectId)GameInfo.GameInfoId, ((UDKBot)agent).getWorldView()){

            protected void react(IWorldObjectEvent<GameInfo> event) {
                if (((GameInfo)event.getObject()).isBotsPaused() || ((GameInfo)event.getObject()).isGamePaused()) {
                    UDKBotLogic.this.controller.manualPause("Bot launched into paused game.");
                }
            }
        };
        this.endReaction = new EventReactOnce<EndMessage>(EndMessage.class, ((UDKBot)agent).getWorldView()){

            protected void react(EndMessage event) {
                UDKBotLogic.this.latch.countDown();
            }
        };
    }

    protected void logicLatch(String threadName) {
        super.logicLatch(threadName);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(threadName + ": Waiting for the first End message.");
        }
        if (!this.latch.await(60L, TimeUnit.SECONDS)) {
            throw new ComponentCantStartException("End message was not received in 60secs.", (IComponent)this);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(threadName + ": First END message received, starting logic cycles.");
        }
    }

    protected void start(boolean startPaused) throws AgentException {
        super.start(startPaused);
        this.gameInfoReaction.enable();
        this.endReaction.enable();
        this.latch = new BusAwareCountDownLatch(1, ((UDKBot)this.agent).getEventBus(), new IToken[]{((UDKBot)this.agent).getWorldView().getComponentId()});
    }
}

