/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.communication.worldview.testplan.converter;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.udk.communication.worldview.testplan.wrapper.EventWrapper;
import java.util.LinkedList;
import org.junit.Assert;

public class EventWrapperListConverter
implements Converter {
    protected final LinkedList<? extends IWorldChangeEvent> inputEvents;
    protected final LinkedList<? extends IWorldEvent> expectedEvents;

    public EventWrapperListConverter(LinkedList<? extends IWorldChangeEvent> inputEvents, LinkedList<? extends IWorldEvent> expectedEvents) {
        this.inputEvents = inputEvents;
        this.expectedEvents = expectedEvents;
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        LinkedList event_wrappers = (LinkedList)value;
        int i = 0;
        for (EventWrapper event_wrapper : event_wrappers) {
            writer.startNode("EventWrapper");
            writer.addAttribute("type", event_wrapper.getClass().getName());
            context.convertAnother((Object)event_wrapper);
            writer.endNode();
            ++i;
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        LinkedList<EventWrapper> event_wrappers = new LinkedList<EventWrapper>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String type = reader.getAttribute("type");
            try {
                EventWrapper wrapper = (EventWrapper)context.convertAnother((Object)this, Class.forName(type));
                event_wrappers.add(wrapper);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                Assert.fail((String)("Could not find class of this type: " + type));
            }
            reader.moveUp();
        }
        return event_wrappers;
    }

    public boolean canConvert(Class clazz) {
        return clazz == LinkedList.class;
    }
}

