package cz.cuni.amis.pogamut.udk.communication.translator.testplan;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;

import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;

public class MyUnrealId extends UnrealId {

	private static int num = 0;
	
	private UnrealId realId = null;

	@XStreamAlias("unrealId")
	@XStreamAsAttribute
	private String unrealId;
	
	public MyUnrealId() {
		super();
	}
	
	private UnrealId readResolve() {
		return getRealId();
	}

	public boolean equals(Object obj) {
		if (obj == null) return false;
		if (obj instanceof UnrealId) {
			return getRealId().equals(obj);
		} else {
			return false;
		}
	}
	
	public int hashCode() {
		return getRealId().hashCode();
	}

	private UnrealId getRealId() {
		if (realId == null) {
			if (unrealId == null) realId = UnrealId.get("Obj" + (++num));
			else realId = UnrealId.get(unrealId);
		}
		return realId;
	}	
	
	@Override
	public String toString() {
		return "MyUnrealId[" + getRealId() + "]]";
	}

}
