package cz.cuni.amis.pogamut.udk.communication.worldview;

import java.io.File;

import org.junit.Assert;

import cz.cuni.amis.pogamut.base3d.worldview.impl.BatchAwareWorldView;

/**
 * Abstract class for all batchaware worldviews.
 * @author Radek 'Black_Hand' Pibil
 *
 */
public abstract class AbstractBatchAwareWorldViewTest extends AbstractWorldViewTest {

	protected AbstractBatchAwareWorldViewTest(File planFile) {
		super(planFile);
	}	

	/**
	 * This method is executed after sending all notifications for worldview
	 */
	@Override
	protected void postNotifications() {
		int counter = 0;
		while (((BatchAwareWorldView)getContext().getWorldView()).hasObjectsToProcess()) {
			Assert.assertTrue("postNotifications: tested world view " + 
					"failed to finish processing events in time.", counter < 100);				
			try {
				Thread.sleep(100);
			} catch (InterruptedException e) {
				Assert.fail("Interrupted during sleep in postNotifications.");
			}
			++counter;
		}
	}
}
