package cz.cuni.amis.pogamut.udk.communication.worldview;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.logging.Logger;

import junit.framework.Assert;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.udk.communication.worldview.testplan.TestPlanLoader;
import cz.cuni.amis.pogamut.udk.communication.worldview.testplan.WorldViewTestPlanContainer;
import cz.cuni.amis.pogamut.udk.communication.worldview.testplan.wrapper.EventWrapperWithCallCount;
import cz.cuni.amis.pogamut.udk.communication.worldview.testplan.wrapper.InputEventWrapper;
import cz.cuni.amis.utils.flag.Flag;
import java.util.logging.Level;

/**
 * @author Jimmy
 */
public class WorldViewTestContext {
	
	private final File planFile;
	private final Logger log;
	private final IWorldView worldView;
	
	/**
	 * Initialized in constructor, contains all events/wrappers that defined the test for the worldview.
	 */
	private final WorldViewTestPlanContainer container;
	
	private boolean strictExecution = true;
	private int currentEventForStrictExecution = 0;
	
	private Flag<Boolean> runningFlag = new Flag<Boolean>(true);
	
	private String failString = null;
	
	public WorldViewTestContext(File planFile, Logger log, IWorldView worldView) {
		this.planFile = planFile;
		Assert.assertTrue("Plan file not found: " + planFile.getAbsolutePath(), planFile.exists() && planFile.isFile());
		this.log = log;
		Assert.assertTrue("Log is null.", log != null);
		this.worldView = worldView;
		Assert.assertTrue("WorldView is null.", worldView != null);
		
		// loading the plan
		try {
			this.container = TestPlanLoader.loadPlan(this, new FileReader(planFile));
		} catch (FileNotFoundException e) {			
			e.printStackTrace();
			Assert.fail("Plan file not found: " + planFile.getAbsolutePath());
			throw new RuntimeException("WorldViewTestContext initialization failed.");
		}
		
		int i = 0;
		if (log.isLoggable(Level.INFO)) log.info("Events in testplan:");
		for (InputEventWrapper e : container.getInputEventsPlan()) {
			if (log.isLoggable(Level.INFO)) log.info(++i + " - " + e.getEvent());
		}
	}
	
	public WorldViewTestPlanContainer getContainer() {
		return container;
	}

	public String getFailString() {
		return failString;
	}

	public void setFailString(String failString) {
		this.failString = failString;
	}

	public Flag<Boolean> getRunningFlag() {
		return runningFlag;
	}

	public File getPlanFile() {
		return planFile;
	}

	public Logger getLog() {
		return log;
	}

	public boolean isStrictExecution() {
		return strictExecution;
	}
	
	public IWorldView getWorldView() {
		return worldView;
	}

	public int getCurrentEventForStrictExecution() {
		return currentEventForStrictExecution;
	}
	
	public void incCurrentEventForStrictExecution() {
		++this.currentEventForStrictExecution;
	}

	public void setCurrentEventForStrictExecution(int currentEventForStrictExecution) {
		this.currentEventForStrictExecution = currentEventForStrictExecution;
	}

	public LinkedList<? extends EventWrapperWithCallCount> getExpectedEventsPlan() {
		return container.getExpectedEventsPlan();
	}

	public LinkedList<? extends InputEventWrapper> getInputEventsPlan() {
		return container.getInputEventsPlan();
	}
	
	public EventWrapperWithCallCount getCurrentMockWrapper() {
		return getExpectedEventsPlan().get(currentEventForStrictExecution);
	}

	public boolean isFailStringSet() {
		return !"".equals(failString);
	}
	
}
