package cz.cuni.amis.pogamut.udk.communication.worldview;

import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldChangeEventInput;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;

public class MockMediator implements IMediator {

	private static Object NUM_MUTEX = new Object();
	
	private static int NUM = 0;
	
	private IToken id;

	private IWorldChangeEventInput consumer;

	public MockMediator() {
		synchronized(NUM_MUTEX) {
			this.id = Tokens.get("MockMediator"+ (++NUM));
		}
	}
	
	@Override
	public void setConsumer(IWorldChangeEventInput consumer) {
		this.consumer = consumer;
	}

	@Override
	public IToken getComponentId() {
		return id;
	}

}
