package cz.cuni.amis.pogamut.udk.communication.parser;


import com.google.inject.Inject;
import com.google.inject.internal.Nullable;

import cz.cuni.amis.pogamut.base.communication.connection.IWorldReaderProvider;
import cz.cuni.amis.pogamut.base.communication.exception.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.parser.impl.yylex.IYylexObserver;
import cz.cuni.amis.pogamut.base.communication.parser.impl.yylex.YylexParser;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.udk.communication.messages.UnrealIdTranslator;
import cz.cuni.amis.pogamut.udk.communication.translator.itemdescriptor.ItemTranslator;
import cz.cuni.amis.utils.NullCheck;

@AgentScoped
public class UDKParser extends YylexParser {
	
	@Inject
	public UDKParser(UnrealIdTranslator unrealIdTranslator, ItemTranslator itemTranslator,
					    IWorldReaderProvider readerProvider, IUDKYylex yylex, @Nullable IYylexObserver yylexObserver, 
			            IComponentBus bus, IAgentLogger logger) throws CommunicationException {
		super(readerProvider, yylex, yylexObserver, bus, logger);
		NullCheck.check(unrealIdTranslator, "unrealIdTranslator");
		yylex.setTranslator(unrealIdTranslator);
		NullCheck.check(itemTranslator, "itemTranslator");
		yylex.setItemTranslator(itemTranslator);
	}
	
//	@Override
//	public InfoMessage parse() throws ParserException {
//		log.warning("going to parse message");
//		InfoMessage msg = super.parse();
//		log.warning("Message: " + msg);
//		return msg;
//	}

}
